/**
* The AVENUE Project
* Language Technologies Institute
* School of Computer Science
* (c) 2007 Carnegie Mellon University
* 
* Corpus Navigator
* Written by Jonathan Clark
*/
package edu.cmu.cs.lti.avenue.navigation.featuredetection.deductive;

public class RuleConstants {

	// major rule components
	public static final String RULE = "rule";
	public static final String VARIABLES = "variables";
	public static final String SENTENCES = "sentences";
	public static final String OVERLAP = "overlap";
	public static final String IF = "if";
	public static final String THEN = "then";
	public static final String WALS = "WALS";

	// overlap functions
	public static final String DEFAULT = "default";
	public static final String ALL = "all";
	public static final String NONE = "none";

	// boolean functions
	public static final String DIFFERENT = "different";
	public static final String DIFFERENT_SUFFIX = "different-suffix";
	public static final String DIFFERENT_PREFIX = "different-prefix";
	public static final String DIFFERENT_AFFIX = "different-affix";
	public static final String SAME = "same";
	public static final String SAME_SUFFIX = "same-suffix";
	public static final String SAME_PREFIX = "same-prefix";
	public static final String SAME_AFFIX = "same-affix";
	public static final String IN_ORDER = "in-order";
	public static final String PRESENT = "present";
	public static final String NOT_PRESENT = "not-present";
	public static final String GREATER = ">";
	public static final String LESS = "<";
	public static final String EQUALS = "=";
	public static final String AND = "and";
	public static final String OR = "or";
	public static final String ASSERTED = "asserted";
	public static final String NOT_ASSERTED = "not-asserted";

	// count functions
	public static final String COUNT_DIFF = "count-diff";

	// lexical functions
	public static final String SOURCE_LEX = "source-lex";
	public static final String TARGET_LEX = "target-lex";
	public static final String SOURCE_LEX_IHEAD = "source-lex-ihead";
	public static final String TARGET_LEX_IHEAD = "target-lex-ihead";
	public static final String SOURCE_LEX_UHEAD = "source-lex-uhead";
	public static final String TARGET_LEX_UHEAD = "target-lex-uhead";
	public static final String FNODE = "fnode";
	public static final String POS = "pos";
}


