/**
* The AVENUE Project
* Language Technologies Institute
* School of Computer Science
* (c) 2007 Carnegie Mellon University
* 
* Corpus Navigator
* Written by Jonathan Clark
*/
package edu.cmu.cs.lti.avenue.navigation.featuredetection.deductive;

import info.jonclark.util.StringUtils;

public class Implication {
	private String featureSet;
	private String featureName;
	private String featureValue;

	public Implication(String featureSet, String featureName, String featureValue) {

		// trim leading/trailing quotes, iff present
		this.featureSet = StringUtils.substringBetween(featureSet, "\"", "\"");
		this.featureName = StringUtils.substringBetween(featureName, "\"", "\"");
		this.featureValue = StringUtils.substringBetween(featureValue, "\"", "\"");
	}

	public String getFeatureSet() {
		return featureSet;
	}

	public void setFeatureSet(String featureSet) {
		this.featureSet = featureSet;
	}

	public String getFeatureName() {
		return featureName;
	}

	public void setFeatureName(String featureName) {
		this.featureName = featureName;
	}

	public String getFeatureValue() {
		return featureValue;
	}

	public void setFeatureValue(String featureValue) {
		this.featureValue = featureValue;
	}
	
	public String toString() {
		return featureSet + ":" + featureName + "=" + featureValue; 
	}

}



