/**
 * The AVENUE Project
 * Language Technologies Institute
 * School of Computer Science
 * (c) 2007 Carnegie Mellon University
 * 
 * Corpus Navigator
 * Written by Jonathan Clark
 */
package edu.cmu.cs.lti.avenue.navigation.featuredetection.deductive;

import edu.cmu.cs.lti.avenue.trees.smart.TreeNode;

/**
 * A representation of the "if" and "then" portions of a Rule.
 */
public class Condition {
	private final TreeNode condition;
	private final Implication[] implications;
	private final float weight;

	public Condition(float weight, TreeNode condition, Implication[] implications) {
		this.condition = condition;
		this.implications = implications;
		this.weight = weight;
	}

	public TreeNode getConditionNode() {
		return condition;
	}

	public Implication[] getImplications() {
		return implications;
	}
	
	public float getWeight() {
		return weight;
	}
}
