package edu.cmu.cs.lti.avenue.navigation.elicitation;

import edu.cmu.cs.lti.avenue.corpus.SentencePair;

/**
 * Serves as a point of contact (a server from the point of view of the
 * ElicitationTool) between the human using the ElicitationTool and the Corpus
 * Navigation process. All implementations of this class must provide a
 * constructor parameterized by (Properties props, String namespace).
 * 
 * @author jon
 */
public interface ElicitationInterface {

	/**
	 * Asks the user to give us a translation of the specified source sentence.
	 * The translated version of the sentence is returned.
	 * 
	 * @param pair
	 * @return
	 */
	public SentencePair elicitTranslation(SentencePair pair);

	/**
	 * Asks the user to give an alignment for the specified source-target
	 * sentence pair. The aligned version of the SentencePair is returned.
	 * 
	 * @param pair
	 * @return
	 */
	public SentencePair elicitAlignment(SentencePair pair);

	/**
	 * Asks the user to confirm what we guess to be the alignment of a
	 * source-target sentence pair (or correct the alignment if we guessed
	 * wrong). The correctly aligned version of the SentencePair is returned. We
	 * can often guess the alignment of a sentence if we have already seen a
	 * sentence that has identical source and target sides.
	 * 
	 * @param pair
	 * @return
	 */
	public SentencePair confirmAlignment(SentencePair pair);
}
