package edu.cmu.cs.lti.avenue.featurespecification;

public class FeatureValueSpec {
	
	private FeatureSpec parent;
	private String name;
	private String notes = "";
	private FeatureValueRestriction[] restrictions;

	public boolean equals(Object obj) {
		if (obj instanceof FeatureValueSpec) {
			FeatureValueSpec other = (FeatureValueSpec) obj;
			return name.equals(other.name);
		} else {
			return false;
		}
	}

	public FeatureSpec getParent() {
		return parent;
	}

	public String getName() {
		return name;
	}

	public FeatureValueRestriction[] getRestrictions() {
		return restrictions;
	}
	
	public int hashCode() {
		return name.hashCode();
	}
	
	public String toString() {
		return "(" + parent.name + " " + this.name + ")";
	}

	protected void setParent(FeatureSpec parent) {
		this.parent = parent;
	}

	protected void setName(String name) {
		this.name = name;
	}
	
	protected void setNotes(String notes) {
		this.notes = notes;
	}
	
	public String getNotes() {
		return notes;
	}

	protected void setRestrictions(FeatureValueRestriction[] restrictions) {
		this.restrictions = restrictions;
	}
}
