/**
* The AVENUE Project
* Language Technologies Institute
* School of Computer Science
* (c) 2007 Carnegie Mellon University
* 
* Corpus Navigator
* Written by Jonathan Clark
*/
package edu.cmu.cs.lti.avenue.corpus;

import java.util.ArrayList;

import edu.cmu.cs.lti.avenue.navigation.search.generation0.featurebitmaps.Feature;

/**
 * Some test from which we hope to learn some feature of a language based on
 * whether or not the presented sentence pair is different from another
 * particular sentence pair.
 */
public class SentenceTest {
	private final int[] requiredPairs;
	private final ArrayList<Feature> equalityImplications;
	private final ArrayList<Feature> inequalityImplications;

	public SentenceTest(int[] requiredPairs, ArrayList<Feature> equalityImplications,
			ArrayList<Feature> inequalityImplications) {
		this.requiredPairs = requiredPairs;
		this.equalityImplications = equalityImplications;
		this.inequalityImplications = inequalityImplications;
	}

	/**
	 * Get the ID's of the sentence pairs required to run this test.
	 * 
	 * @return
	 */
	public int[] getRequiredPairs() {
		return requiredPairs;
	}

	/**
	 * Get the language features that are implied by this sentence being equal
	 * with all of its required pairs.
	 * 
	 * @return
	 */
	public ArrayList<Feature> getEqualityImplications() {
		return equalityImplications;
	}

	/**
	 * Get the language features that are implied by this sentence being NOT
	 * equal with all of its required pairs.
	 */
	public ArrayList<Feature> getInequalityImplications() {
		return inequalityImplications;
	}

}




