/**
 * The AVENUE Project
 * Language Technologies Institute
 * School of Computer Science
 * (c) 2007 Carnegie Mellon University
 * 
 * Corpus Navigator
 * Written by Jonathan Clark
 */
package edu.cmu.cs.lti.avenue.corpus;

import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;

import edu.cmu.cs.lti.avenue.trees.smart.SmartTree;

/**
 * A factory to ensure a 1-1 relation between SentencePair instances and
 * sentence pair ID's.
 */
public class SentencePairFactory {

	private static final HashMap<Integer, SentencePair> pairs =
			new HashMap<Integer, SentencePair>();

	/**
	 * Create a new SentencePair object.
	 * 
	 * @param id
	 * @param eSentence
	 * @param fSentence
	 * @param alignments
	 * @param context
	 * @param comment
	 * @return
	 * @throws ParseException
	 * @throws CorpusException
	 * @throws IOException
	 */
	public static SentencePair getInstance(int id, String[] eSentence, String[] fSentence,
			boolean[] sourceMorphemeBoundaries, boolean[] targetMorphemeBoundaries,
			String alignments, String context, String comment, SmartTree featureStructure,
			SmartTree sourceConstituentStructure, SmartTree targetConstituentStructure,
			PhiPlusMapping phiPlusMapping, String fstLine, String cstLine, String myLine)
			throws ParseException, CorpusException, IOException {

		// assert id != -1;

		SentencePair pair = null; // pairs.get(id);
		if (id == -1 || pair == null) {
			pair =
					new SentencePair(id, eSentence, fSentence, sourceMorphemeBoundaries,
							targetMorphemeBoundaries, alignments, context, comment,
							featureStructure, sourceConstituentStructure,
							targetConstituentStructure, phiPlusMapping, fstLine, cstLine, myLine);
			pairs.put(id, pair);
		}

		return pair;
	}

	/**
	 * Lookup an existing SentencePair object by its unique id
	 * 
	 * @param id
	 * @return
	 * @deprecated Due to difficulties with assigning ID's to alternates.
	 *             Behavior is now undefined when alternates are present.
	 */
	@Deprecated
	public static SentencePair getById(int id) {
		return pairs.get(id);
	}
}
