package edu.cmu.cs.lti.avenue.corpus;

import info.jonclark.util.MathUtils;
import info.jonclark.util.StringUtils;

public class RawAlignment {
	public int[] sourceTerminals;
	public int[] targetTerminals;

	public int getSourceMin() {
		return MathUtils.min(sourceTerminals);
	}

	public int getSourceMax() {
		return MathUtils.max(sourceTerminals);
	}

	public int getTargetMin() {
		return MathUtils.min(targetTerminals);
	}

	public int getTargetMax() {
		return MathUtils.max(targetTerminals);
	}

	public String toString() {
		return "(" + StringUtils.untokenize(sourceTerminals, " ") + ","
				+ StringUtils.untokenize(targetTerminals, " ") + ")";
	}

	public static String toString(RawAlignment[] alignments) {
		return "(" + StringUtils.untokenize(alignments, ",") + ")";
	}
}
