/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.bytes.AbstractByteCollection;
import it.unimi.dsi.fastutil.bytes.AbstractByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.chars.AbstractCharIterator;
import it.unimi.dsi.fastutil.chars.AbstractCharSet;
import it.unimi.dsi.fastutil.chars.Char2ByteMap;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChar2ByteMap
implements Char2ByteMap,
Serializable {
    protected byte defRetValue;

    protected AbstractChar2ByteMap() {
    }

    @Override
    public void defaultReturnValue(byte rv) {
        this.defRetValue = rv;
    }

    @Override
    public byte defaultReturnValue() {
        return this.defRetValue;
    }

    @Override
    public byte put(char key, byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte remove(char key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Byte get(Object ok) {
        char k = ((Character)ok).charValue();
        return this.containsKey(k) ? Byte.valueOf(this.get(k)) : null;
    }

    @Override
    public Byte put(Character ok, Byte ov) {
        char k = ok.charValue();
        byte v = this.put(k, (byte)ov);
        return this.containsKey(k) ? Byte.valueOf(v) : null;
    }

    @Override
    public Byte remove(Object ok) {
        char k = ((Character)ok).charValue();
        byte v = this.remove(k);
        return this.containsKey(k) ? Byte.valueOf(v) : null;
    }

    @Override
    public boolean containsValue(Object ov) {
        return this.containsValue((Byte)ov);
    }

    @Override
    public boolean containsKey(Object ok) {
        return this.containsKey(((Character)ok).charValue());
    }

    @Override
    public boolean containsValue(byte v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(char k) {
        return this.keySet().contains(k);
    }

    @Override
    public void putAll(Map<? extends Character, ? extends Byte> m) {
        int n = m.size();
        Iterator<Map.Entry<? extends Character, ? extends Byte>> i = m.entrySet().iterator();
        if (m instanceof Char2ByteMap) {
            while (n-- != 0) {
                Char2ByteMap.Entry e = (Char2ByteMap.Entry)i.next();
                this.put(e.getCharKey(), e.getByteValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry<? extends Character, ? extends Byte> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public CharSet keySet() {
        return new AbstractCharSet(){

            public boolean contains(char k) {
                return AbstractChar2ByteMap.this.containsKey(k);
            }

            public int size() {
                return AbstractChar2ByteMap.this.size();
            }

            public void clear() {
                AbstractChar2ByteMap.this.clear();
            }

            public CharIterator iterator() {
                return new AbstractCharIterator(){
                    final ObjectIterator<Map.Entry<Character, Byte>> i;
                    {
                        this.i = AbstractChar2ByteMap.this.entrySet().iterator();
                    }

                    public char nextChar() {
                        return ((Char2ByteMap.Entry)this.i.next()).getCharKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public ByteCollection values() {
        return new AbstractByteCollection(){

            public boolean contains(byte k) {
                return AbstractChar2ByteMap.this.containsValue(k);
            }

            public int size() {
                return AbstractChar2ByteMap.this.size();
            }

            public void clear() {
                AbstractChar2ByteMap.this.clear();
            }

            public ByteIterator iterator() {
                return new AbstractByteIterator(){
                    final ObjectIterator<Map.Entry<Character, Byte>> i;
                    {
                        this.i = AbstractChar2ByteMap.this.entrySet().iterator();
                    }

                    public byte nextByte() {
                        return ((Char2ByteMap.Entry)this.i.next()).getByteValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public int hashCode() {
        int h = 0;
        int n = this.size();
        ObjectIterator<Map.Entry<Character, Byte>> i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)((Map.Entry)i.next())).hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator<Map.Entry<Character, Byte>> i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Char2ByteMap.Entry e = (Char2ByteMap.Entry)i.next();
            s.append(String.valueOf(e.getCharKey()));
            s.append("=>");
            s.append(String.valueOf(e.getByteValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Char2ByteMap.Entry {
        protected char key;
        protected byte value;

        public BasicEntry(Character key, Byte value) {
            this.key = key.charValue();
            this.value = value;
        }

        public BasicEntry(char key, byte value) {
            this.key = key;
            this.value = value;
        }

        public Character getKey() {
            return Character.valueOf(this.key);
        }

        public char getCharKey() {
            return this.key;
        }

        public Byte getValue() {
            return this.value;
        }

        public byte getByteValue() {
            return this.value;
        }

        public byte setValue(byte value) {
            throw new UnsupportedOperationException();
        }

        public Byte setValue(Byte value) {
            return this.setValue((byte)value);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == ((Character)e.getKey()).charValue() && this.value == (Byte)e.getValue();
        }

        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

