/*
 * Decompiled with CFR 0.152.
 */
package cmu.survey;

import cmu.survey.DatabaseConnection;
import cmu.survey.DatabaseList;
import cmu.survey.Maintenance;
import java.io.IOException;
import java.util.Vector;

public class TableField
extends DatabaseList {
    String table;
    String sqlwhere;
    String sqlOrderBy;

    public void init(String databaseName) {
        DatabaseConnection connection = new DatabaseConnection();
        connection.setDatabaseName(databaseName);
        connection.setPageContext(this.pageContext);
        connection.doStartTag();
        this.setupConnection(connection);
    }

    public void init(String table, String field, String sqlWhere, String sqlOrderBy, String databaseName, String startWith, String endWith) {
        this.setField(field);
        this.setTable(table);
        this.setSQLOrderBy(sqlOrderBy);
        this.setSqlwhere(sqlWhere);
        this.setStartWith(startWith);
        this.setEndWith(endWith);
        DatabaseConnection connection = new DatabaseConnection();
        connection.setDatabaseName(databaseName);
        connection.doStartTag();
        connection.setPageContext(this.pageContext);
        this.setupConnection(connection);
    }

    public void init(String table, String field, String sqlWhere, String databaseName, String startWith, String endWith) {
        this.init(table, field, sqlWhere, null, databaseName, startWith, endWith);
    }

    public Vector doQueryGetVector(String queryString) {
        try {
            if (queryString != null && queryString.length() > 0) {
                this.doQuery(queryString);
                if (this.moveToNextRecord()) {
                    return this.getFields(this.field);
                }
            }
        }
        catch (Throwable ex) {
            try {
                String errorMessage = Maintenance.sendBugGetMessage(ex);
                if (this.out != null) {
                    this.out.print("<br>" + errorMessage);
                }
            }
            catch (IOException ioe) {
                String errorMessage = "\n And then, while trying to print out an error in cmu.survey.TableField.doQueryGetVector(), we got another error: " + ioe;
                Maintenance.sendBug(errorMessage, ioe);
            }
        }
        return null;
    }

    public static Vector doQueryGetVector(String query, String databaseName) {
        TableField tableField = new TableField();
        tableField.init(databaseName);
        Vector v = tableField.doQueryGetVector(query);
        tableField.close();
        return v;
    }

    public static String getTableField(String table, String field, String sqlWhere, String sqlOrderBy, String databaseName, String startWith, String endWith) {
        TableField tableField = new TableField();
        tableField.init(table, field, sqlWhere, sqlOrderBy, databaseName, startWith, endWith);
        return tableField.getTableField();
    }

    public static String getTableField(String table, String field, String sqlWhere, String databaseName, String startWith, String endWith) {
        TableField tableField = new TableField();
        tableField.init(table, field, sqlWhere, databaseName, startWith, endWith);
        return tableField.getTableField();
    }

    public static String getTableField(String table, String field, String sqlWhere, String databaseName) {
        TableField tableField = new TableField();
        tableField.init(table, field, sqlWhere, databaseName, null, null);
        return tableField.getTableField();
    }

    public static Vector getPlainTableFieldsVector(String table, String field, String sqlWhere, String databaseName) {
        TableField tableField = new TableField();
        tableField.init(table, field, sqlWhere, databaseName, null, null);
        return tableField.getPlainTableFieldsVector();
    }

    public static Vector getPlainTableFieldsVectorOfVectors(String table, String field, String sqlWhere, String databaseName) {
        return TableField.getPlainTableFieldsVectorOfVectors(table, field, sqlWhere, null, databaseName);
    }

    public static Vector getPlainTableFieldsVectorOfVectors(String table, String field, String sqlWhere, String sqlOrderBy, String databaseName) {
        TableField tableField = new TableField();
        tableField.init(table, field, sqlWhere, sqlOrderBy, databaseName, null, null);
        return tableField.getPlainTableFieldsVectorOfVectors();
    }

    public Vector getVectorOfVectors(String table, String field, String sqlWhere, String sqlOrderBy) {
        this.setTable(table);
        this.setField(field);
        this.setSQLOrderBy(sqlOrderBy);
        this.setSqlwhere(sqlWhere);
        return this.getPlainTableFieldsVectorOfVectors();
    }

    public String getTableField() {
        try {
            String queryString = this.generateQuery();
            if (queryString != null && queryString.length() > 0) {
                this.doQuery(queryString);
                return this.getList(this.field);
            }
        }
        catch (Throwable ex) {
            String errorMessage = "In cmu.survey.TableField.doStartTag(), while getting the list of \"" + this.field + "\" we got an error: " + ex;
            try {
                errorMessage = Maintenance.sendBugGetMessage(errorMessage, ex);
                if (this.out != null) {
                    this.out.print("<br>" + errorMessage);
                }
            }
            catch (IOException ioe) {
                errorMessage = errorMessage + "\n And then, while trying to print out an error in cmu.survey.TableField.doStartTag(), we got another error: " + ioe;
                Maintenance.sendBug(errorMessage, ioe);
            }
        }
        return "";
    }

    public Vector getPlainTableFieldsVector() {
        try {
            String queryString = this.generateQuery();
            if (queryString != null && queryString.length() > 0) {
                this.doQuery(queryString);
                if (this.moveToNextRecord()) {
                    return this.getFields(this.field);
                }
                Maintenance.debugOutput("TableField.getPlainTableFieldsVector(): There are no rows in the database that match the query.");
            }
        }
        catch (Throwable ex) {
            try {
                String errorMessage = Maintenance.sendBugGetMessage(ex);
                if (this.out != null) {
                    this.out.print("<br>" + errorMessage);
                }
            }
            catch (IOException ioe) {
                String errorMessage = "\n And then, while trying to print out an error in cmu.survey.TableField.getPlainTableFieldsVector(), we got another error: " + ioe;
                Maintenance.sendBug(errorMessage, ioe);
            }
        }
        return null;
    }

    public String generateQuery() {
        String queryString = "SELECT " + this.field;
        if (this.getFieldToPassInLink() != null && !this.getFieldToPassInLink().equals(this.field)) {
            queryString = queryString + ", " + this.getFieldToPassInLink();
        }
        queryString = queryString + " FROM " + this.table;
        if (this.sqlwhere != null) {
            if (!this.sqlwhere.equals("") && !this.sqlwhere.equalsIgnoreCase("EMPTY")) {
                queryString = queryString + " WHERE " + this.sqlwhere;
            }
            if (this.sqlwhere.equals("EMPTY")) {
                return null;
            }
        }
        if (this.sqlOrderBy != null) {
            queryString = queryString + " ORDER BY " + this.sqlOrderBy;
        }
        return queryString;
    }

    public Vector getPlainTableFieldsVectorOfVectors() {
        Vector<Vector> fields = new Vector<Vector>();
        String queryString = null;
        try {
            queryString = this.generateQuery();
            if (queryString != null && queryString.length() > 0) {
                this.doQuery(queryString);
                while (this.moveToNextRecord()) {
                    fields.add(this.getFields(this.field));
                }
            }
        }
        catch (Throwable ex) {
            String errorMessage = "In cmu.survey.TableField.doStartTag(), while getting the list of \"" + this.field + "\" we got an error: " + ex;
            errorMessage = errorMessage + "\nqueryString=" + queryString + "\n";
            try {
                errorMessage = Maintenance.sendBugGetMessage(errorMessage, ex);
                if (this.out != null) {
                    this.out.print("<br>" + errorMessage);
                }
            }
            catch (IOException ioe) {
                errorMessage = errorMessage + "\n And then, while trying to print out an error in cmu.survey.TableField.doStartTag(), we got another error: " + ioe;
                Maintenance.sendBug(errorMessage, ioe);
            }
        }
        return fields;
    }

    public int doStartTag() {
        this.setupConnection();
        this.queryObjectName = this.field;
        try {
            String tableField = this.getTableField();
            this.out.print(tableField);
        }
        catch (IOException ioe) {
            String errorMessage = "And then, while trying to print out an error in cmu.survey.TableField.doStartTag(), we got another error: " + ioe;
            Maintenance.sendBug(errorMessage, ioe);
        }
        return 0;
    }

    public void setTable(String value) {
        this.table = value;
    }

    public String getTable() {
        return this.table;
    }

    public void setSqlwhere(String value) {
        this.sqlwhere = value;
    }

    public String getSqlwhere() {
        return this.sqlwhere;
    }

    public void setSQLOrderBy(String value) {
        this.sqlOrderBy = value;
    }

    public void reinit() {
        super.reinit();
        this.sqlOrderBy = null;
        this.sqlwhere = null;
        this.table = null;
    }
}

