/*
 * Decompiled with CFR 0.152.
 */
package cmu.survey;

import cmu.survey.Maintenance;
import cmu.survey.TextQuestion;

public class PasswordQuestion
extends TextQuestion {
    public static final String DefaultPasswordValue = "sEcuRePaSs8&)(_SoUsersCantSeeIt";

    public PasswordQuestion() {
        this.inputType = "password";
        this.type = "password";
    }

    public String getValueFromDB() {
        String val = super.getValueFromDB();
        if (!(val == null || val.length() <= 0 || this.defaultValue != null && val.equals(this.defaultValue))) {
            return DefaultPasswordValue;
        }
        return this.defaultValue;
    }

    public void reinit() {
        super.reinit();
        this.type = "password";
    }

    public void setType(String newType) {
        boolean isValidType = false;
        String[] FieldTypesForPasswords = new String[]{"string", "stringKey", "password", "passwordKey"};
        if (newType != null) {
            int i = 0;
            while (i < FieldTypesForPasswords.length) {
                if (newType.equalsIgnoreCase(FieldTypesForPasswords[i])) {
                    isValidType = true;
                    if (i >= 2) break;
                    newType = FieldTypesForPasswords[i += 2];
                    break;
                }
                ++i;
            }
        }
        if (isValidType) {
            this.type = newType;
        } else {
            Maintenance.sendBug("In cmu.survey.PasswordQuestion.setType(), the type '" + newType + "' was not a valid type.\n" + "It was not one of the following types: \n" + "    password   (used for passwords in the database field '[fieldName]')\n" + "    passwordKey   (used for passwords that are keys/unique IDs in the database field '[fieldName]')\n");
        }
    }

    static {
        DefaultPasswordValue = DefaultPasswordValue;
    }
}

