/*
 * Decompiled with CFR 0.152.
 */
package cmu.survey;

import cmu.survey.DatabaseConnection;
import cmu.survey.DatabaseList;
import cmu.survey.DatabaseUpdate;
import cmu.survey.Maintenance;
import cmu.survey.Survey;
import cmu.survey.TimeZoneQuestion;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.http.HttpSession;

public class GenericUpdate
extends DatabaseUpdate {
    Vector stringNames;
    Vector stringValues;
    Vector numberNames;
    Vector numberValues;
    Vector numberKeyNames;
    Vector numberKeyValues;
    Vector stringKeyNames;
    Vector stringKeyValues;
    Survey survey;
    String whereOfKeys = null;
    boolean saveChangesToDB = true;
    boolean changedDBLastUpdate = false;
    String lastMessage;
    int lastThingDone = -1;
    public static final int NOTHING = -1;
    public static final int UPDATE = 1;
    public static final int INSERT = 2;
    public static final int DELETE = 3;

    public String cleanStringValue(String string) {
        if (this.survey != null) {
            return this.survey.cleanStringBetter(string);
        }
        return DatabaseConnection.cleanString(string);
    }

    public void setLastMessage(String string) {
        this.lastMessage = this.lastMessage == null ? "" : this.lastMessage + " ... ";
        this.lastMessage = this.lastMessage + string;
        this.pageContext.setAttribute("dbMessage", (Object)this.lastMessage);
    }

    public String getLastMessage() {
        return this.lastMessage;
    }

    public boolean getChangedDBLastUpdate() {
        return this.changedDBLastUpdate;
    }

    public void setSaveChangesToDB(boolean allowChangesToDB) {
        this.saveChangesToDB = allowChangesToDB;
    }

    public String getWhereOfKeys() {
        return this.whereOfKeys;
    }

    void doUpdate() throws IOException {
        int i;
        String badParamsFound = "";
        this.stringNames = new Vector();
        this.stringValues = new Vector();
        this.numberNames = new Vector();
        this.numberValues = new Vector();
        this.numberKeyNames = new Vector();
        this.numberKeyValues = new Vector();
        this.stringKeyNames = new Vector();
        this.stringKeyValues = new Vector();
        HttpSession theSession = null;
        theSession = this.pageContext.getSession();
        if (this.survey == null && this.theConnection instanceof Survey) {
            this.survey = (Survey)this.theConnection;
        }
        String tableName = null;
        if (this.survey != null && tableName == null) {
            tableName = this.survey.getTable();
        }
        if (tableName == null) {
            Object tableNameObject = theSession.getAttribute("tableName");
            if (DatabaseList.debug) {
                Maintenance.debugOutput("GenericUpdate.tableNameObject=" + tableNameObject);
            }
            if (tableNameObject == null) {
                this.returnMessage = null;
                this.changedDBLastUpdate = false;
            } else {
                tableName = tableNameObject.toString();
            }
        }
        Enumeration paramNames = this.theRequest.getParameterNames();
        boolean foundSubmit = false;
        int thingToDo = -1;
        String emailBody = "Survey Results:\n";
        emailBody = emailBody + "Name\tValue\n";
        while (paramNames.hasMoreElements()) {
            String newParamName;
            int index;
            String paramName = (String)paramNames.nextElement();
            String paramValue = this.cleanStringValue(this.theRequest.getParameter(paramName));
            if (DatabaseList.debug) {
                Maintenance.debugOutput("  Param: " + paramName + "='" + paramValue + "'");
            }
            if (this.survey != null && this.survey.getEmailResultsTo() != null && this.survey.getEmailResultsTo().length() > 0 && (index = (newParamName = paramName).indexOf("_")) > 0) {
                emailBody = emailBody + paramName.substring(index + 1) + "\t" + paramValue + "\n";
            }
            if (paramValue.length() == 0 && (this.survey == null || !this.survey.getRetrieveValuesFromDB() || paramName.startsWith("number") || paramName.startsWith("date") || this.survey.getIsLoginPage())) {
                if (!DatabaseList.debug) continue;
                Maintenance.debugOutput("  Filtering out '" + paramName + "'");
                continue;
            }
            if (paramName.startsWith("string_")) {
                this.stringNames.add(Survey.cleanStringThatShouldHaveBeenClean(paramName.substring(7), this.pageContext));
                this.stringValues.add(paramValue);
                continue;
            }
            if (paramName.startsWith("number_")) {
                this.numberNames.add(Survey.cleanStringThatShouldHaveBeenClean(paramName.substring(7), this.pageContext));
                this.numberValues.add(paramValue);
                continue;
            }
            if (paramName.startsWith("numberKey_")) {
                this.numberKeyNames.add(Survey.cleanStringThatShouldHaveBeenClean(paramName.substring(10), this.pageContext));
                this.numberKeyValues.add(paramValue);
                continue;
            }
            if (paramName.startsWith("stringKey_")) {
                this.stringKeyNames.add(Survey.cleanStringThatShouldHaveBeenClean(paramName.substring(10), this.pageContext));
                this.stringKeyValues.add(paramValue);
                continue;
            }
            if (paramName.startsWith("datetime_")) {
                this.numberNames.add(Survey.cleanStringThatShouldHaveBeenClean(paramName.substring(9), this.pageContext));
                if (paramValue.equalsIgnoreCase("AUTO-GENERATE-DATETIME")) {
                    paramValue = this.formatDateTimeSQL(new Date());
                }
                this.numberValues.add(paramValue);
                continue;
            }
            if (paramName.startsWith("timezone_")) {
                this.stringNames.add(Survey.cleanStringThatShouldHaveBeenClean(paramName.substring(9), this.pageContext));
                paramValue = TimeZoneQuestion.convertHTTPRequestStringToSQL(paramValue);
                this.stringValues.add(paramValue);
                continue;
            }
            if (paramName.startsWith("timezoneKey_")) {
                this.stringKeyNames.add(Survey.cleanStringThatShouldHaveBeenClean(paramName.substring(12), this.pageContext));
                paramValue = TimeZoneQuestion.convertHTTPRequestStringToSQL(paramValue);
                this.stringKeyValues.add(paramValue);
                continue;
            }
            if (paramName.startsWith("password_")) {
                if (paramValue.equals("sEcuRePaSs8&)(_SoUsersCantSeeIt")) continue;
                this.stringNames.add(Survey.cleanStringThatShouldHaveBeenClean(paramName.substring(9), this.pageContext));
                this.stringValues.add(paramValue);
                continue;
            }
            if (paramName.startsWith("passwordKey_")) {
                if (paramValue.equals("sEcuRePaSs8&)(_SoUsersCantSeeIt")) continue;
                this.stringKeyNames.add(Survey.cleanStringThatShouldHaveBeenClean(paramName.substring(12), this.pageContext));
                this.stringKeyValues.add(paramValue);
                continue;
            }
            if (paramName.startsWith("submit")) {
                foundSubmit = true;
                if (!paramName.equalsIgnoreCase("submitDelete") || !this.survey.getShowDeleteButton()) continue;
                if (this.survey == null || this.survey.getShowDeleteButton()) {
                    thingToDo = 3;
                    continue;
                }
                Maintenance.sendHackerError("The user tried to add a 'delete' into the form when there was no button on the page to delete!  The user may have been trying to hack into the system and delete records!  \ntable=" + tableName, this.pageContext);
                continue;
            }
            if (paramName.equalsIgnoreCase("Action")) {
                foundSubmit = true;
                if (!paramValue.equalsIgnoreCase("Delete") && paramValue.indexOf("delete") <= -1) continue;
                if (this.survey.getShowDeleteButton()) {
                    thingToDo = 3;
                    continue;
                }
                Maintenance.sendHackerError("The user tried to add a 'delete' into the form when there was no button on the page to delete!  The user may have been trying to hack into the system and delete records!  \ntable=" + tableName, this.pageContext);
                continue;
            }
            if (paramName.equals("redir") || paramName.startsWith("ignore_")) continue;
            badParamsFound = badParamsFound + "There was a type sent to cmu.survey.GenericUpdate.doUpdate() which was not a standard type.  We couldn't parse it: \n Name: " + paramName + "\n Value: " + paramValue + "\n" + "Was not one of the following types: \n" + "    number_[fieldName]   (used for saving numbers in the database field '[fieldName]')\n" + "    string_[fieldName]   (used for saving strings in the database field '[fieldName]')\n" + "    numberKey_[fieldName]   (used for numbers that are keys/unique IDs in the database field '[fieldName]')\n" + "    stringKey_[fieldName]   (used for numbers that are keys/unique IDs in the database field '[fieldName]')\n" + "    submit     (the submit button should be named submit)\n";
        }
        if (foundSubmit && badParamsFound.length() > 0) {
            Maintenance.sendBug(badParamsFound);
            this.setLastMessage("Some of your data has not been saved.  An error occurred, which was reported to the administrator for urgent notice.  Try again in a few days.");
        }
        if (this.stringNames.size() == 0 && this.numberNames.size() == 0 && this.numberKeyNames.size() == 0 && this.stringKeyNames.size() == 0) {
            if (DatabaseList.debug) {
                Maintenance.debugOutput("  GenericUpdate.doUpdate(): There's nothing to update.");
            }
            this.changedDBLastUpdate = false;
            return;
        }
        if (this.survey != null && this.survey.getEmailResultsTo() != null && this.survey.getEmailResultsTo().length() > 0) {
            Maintenance.sendMail(this.survey.getEmailResultsTo(), new String[]{this.survey.getEmailResultsTo()}, this.survey.getEmailResultsSubjectLine() == null ? "Survey Results" : this.survey.getEmailResultsSubjectLine(), emailBody);
            Maintenance.debugOutput("Sent out form with survey results to " + this.survey.getEmailResultsTo());
        }
        if (this.theConnection.getDatabaseName() == null || this.theConnection.getDatabaseName().length() < 1) {
            this.changedDBLastUpdate = true;
            return;
        }
        if (this.whereClause == null || this.whereClause.equals("") || this.whereClause.equals("EMPTY")) {
            this.whereClause = this.survey != null && this.survey.getWhere() != null ? this.survey.getWhere() : "";
        }
        if (this.stringKeyNames.size() > 0 || this.numberKeyNames.size() > 0) {
            this.whereClause = this.whereClause + " ";
            this.whereOfKeys = " ";
            if (this.stringKeyNames.size() > 0 || this.numberKeyNames.size() > 0) {
                boolean addToWhere;
                String toAdd;
                int i2 = 0;
                while (i2 < this.stringKeyNames.size()) {
                    String name = this.stringKeyNames.get(i2).toString();
                    toAdd = name + "=";
                    addToWhere = false;
                    if (this.whereClause.indexOf(toAdd) == -1) {
                        if (this.whereClause.length() > 2 && !this.whereClause.endsWith("AND ")) {
                            this.whereClause = this.whereClause + " AND ";
                        }
                        this.whereClause = this.whereClause + toAdd + "'";
                        addToWhere = true;
                    }
                    if (this.whereOfKeys.length() > 2 && !this.whereOfKeys.endsWith("AND ")) {
                        this.whereOfKeys = this.whereOfKeys + " AND ";
                    }
                    this.whereOfKeys = this.whereOfKeys + toAdd + "'";
                    String value = this.stringKeyValues.get(i2).toString();
                    if (value.equals("")) {
                        int j = 0;
                        while (j < this.stringNames.size() && value.equals("")) {
                            if (this.stringNames.get(j).toString().equals(name)) {
                                value = this.stringValues.get(j).toString();
                            }
                            ++j;
                        }
                    }
                    if (addToWhere) {
                        this.whereClause = this.whereClause + value + "'";
                    }
                    this.whereOfKeys = this.whereOfKeys + value + "'";
                    theSession.setAttribute("stringKey_" + name, (Object)value);
                    ++i2;
                }
                int i3 = 0;
                while (i3 < this.numberKeyNames.size()) {
                    toAdd = this.numberKeyNames.get(i3) + "=";
                    addToWhere = false;
                    if (this.whereClause.indexOf(toAdd) == -1) {
                        if (this.whereClause.length() > 2 && !this.whereClause.endsWith("AND ")) {
                            this.whereClause = this.whereClause + " AND ";
                        }
                        this.whereClause = this.whereClause + toAdd;
                        addToWhere = true;
                    }
                    if (this.whereOfKeys.length() > 2 && !this.whereOfKeys.endsWith("AND ")) {
                        this.whereOfKeys = this.whereOfKeys + " AND ";
                    }
                    this.whereOfKeys = this.whereOfKeys + toAdd;
                    String name = this.numberKeyNames.get(i3).toString();
                    String value = this.numberKeyValues.get(i3).toString();
                    if (value.equals("")) {
                        int j = 0;
                        while (j < this.numberNames.size() && value.equals("")) {
                            if (this.numberNames.get(j).toString().equals(name) && !this.numberValues.get(j).toString().equalsIgnoreCase("null")) {
                                value = this.numberValues.get(j).toString();
                            }
                            ++j;
                        }
                    }
                    if (addToWhere) {
                        this.whereClause = this.whereClause + value;
                    }
                    this.whereOfKeys = this.whereOfKeys + value;
                    theSession.setAttribute("numberKey_" + this.numberKeyNames.get(i3).toString(), (Object)this.numberKeyValues.get(i3).toString());
                    ++i3;
                }
            }
        }
        if (DatabaseList.debug) {
            Maintenance.debugOutput(" Planning: Before evaluating heuristics, thingToDo=" + thingToDo);
        }
        if (thingToDo == -1) {
            if (this.survey != null && this.survey.getNeverMakeNewRecord()) {
                thingToDo = 1;
            } else if (this.whereClause.equals("")) {
                thingToDo = 2;
            } else {
                if (DatabaseList.debug) {
                    Maintenance.debugOutput("Checking to see if record exists: ");
                }
                this.doQuery("SELECT * FROM " + tableName + " WHERE " + this.whereClause);
                if (!this.moveToNextRecord()) {
                    if (DatabaseList.debug) {
                        Maintenance.debugOutput("  There are no records matching these keys, so this will be an insert.");
                    }
                    thingToDo = 2;
                } else {
                    thingToDo = 1;
                }
            }
        }
        if (DatabaseList.debug) {
            Maintenance.debugOutput(" Planning: After evaluating heuristics, thingToDo=" + thingToDo);
        }
        if (this.stringNames.size() == 0 && this.numberNames.size() == 0 && thingToDo == 1) {
            if (DatabaseList.debug) {
                Maintenance.debugOutput("  There's already a match of these keys in the database, and there's no non-key values to update.  Skipping insert/update.");
            }
            this.changedDBLastUpdate = false;
            return;
        }
        if (!this.saveChangesToDB) {
            if (DatabaseList.debug) {
                Maintenance.debugOutput("  Returning because changes to the database are not allowed..");
            }
            this.changedDBLastUpdate = false;
            return;
        }
        String query = null;
        if (thingToDo == 2) {
            this.whereClause = null;
            query = "INSERT INTO " + tableName + "(";
            int i4 = 0;
            while (i4 < this.stringNames.size()) {
                if (this.stringValues.get(i4).toString().length() > 0) {
                    query = query + this.stringNames.get(i4) + ", ";
                }
                ++i4;
            }
            int i5 = 0;
            while (i5 < this.numberNames.size()) {
                query = query + this.numberNames.get(i5) + ", ";
                ++i5;
            }
            i = 0;
            while (i < this.stringKeyNames.size()) {
                query = query + this.stringKeyNames.get(i) + ", ";
                ++i;
            }
            int i6 = 0;
            while (i6 < this.numberKeyNames.size()) {
                query = query + this.numberKeyNames.get(i6) + ", ";
                ++i6;
            }
            query = query.substring(0, query.length() - 2);
            query = query + ") VALUES(";
            int i7 = 0;
            while (i7 < this.stringValues.size()) {
                if (this.stringValues.get(i7).toString().length() > 0) {
                    query = query + "'" + this.stringValues.get(i7) + "', ";
                }
                ++i7;
            }
            int i8 = 0;
            while (i8 < this.numberValues.size()) {
                query = query + this.numberValues.get(i8) + ", ";
                ++i8;
            }
            int i9 = 0;
            while (i9 < this.stringKeyValues.size()) {
                query = query + "'" + this.stringKeyValues.get(i9) + "', ";
                ++i9;
            }
            int i10 = 0;
            while (i10 < this.numberKeyValues.size()) {
                query = query + this.numberKeyValues.get(i10) + ", ";
                ++i10;
            }
            query = query.substring(0, query.length() - 2);
            query = query + ")";
        } else if (thingToDo == 1) {
            query = "UPDATE " + tableName + " SET ";
            int i11 = 0;
            while (i11 < this.stringNames.size()) {
                query = this.stringValues.get(i11).toString().length() > 0 ? query + this.stringNames.get(i11) + "='" + this.stringValues.get(i11) + "', " : query + this.stringNames.get(i11) + "=' ', ";
                ++i11;
            }
            int i12 = 0;
            while (i12 < this.stringKeyNames.size()) {
                query = this.stringKeyValues.get(i12).toString().length() > 0 ? query + this.stringKeyNames.get(i12) + "='" + this.stringKeyValues.get(i12) + "', " : query + this.stringKeyNames.get(i12) + "=' ', ";
                ++i12;
            }
            i = 0;
            while (i < this.numberNames.size()) {
                query = query + this.numberNames.get(i) + "=" + this.numberValues.get(i) + ", ";
                ++i;
            }
            query = query.substring(0, query.length() - 2);
        } else if (thingToDo == 3) {
            this.cleanExecute("SELECT * FROM " + tableName);
            int records = 0;
            while (this.moveToNextRecord()) {
                ++records;
            }
            if (records == 1) {
                query = "DELETE FROM " + tableName;
            } else if (records > 1) {
                Maintenance.sendBug("Survey author made an error:  He set it to delete when there was more than one record that was deleted at a time.  The delete did not occur!  Query: " + query + "\nWhere: " + this.whereClause + "\nwhereOfKeys=" + this.whereOfKeys + "\nNumber of Records=" + records);
                this.setLastMessage("This record was not deleted because the programmer made an error.  The programmer has been notified.");
            }
        }
        if (DatabaseList.debug) {
            Maintenance.debugOutput("  GenericUpdate.doUpdate(): Query: " + query + " (WHERE " + this.whereClause + ")");
        }
        if (query != null) {
            this.cleanExecute(query);
            this.changedDBLastUpdate = true;
            if (thingToDo == 3) {
                this.setLastMessage("The record was deleted.");
            } else if (thingToDo == 1) {
                this.setLastMessage("The record was updated.");
            } else if (thingToDo == 2) {
                this.setLastMessage("The new record was added.");
            }
        }
    }

    public void setupConnection(Survey surveySetup) {
        super.setupConnection(surveySetup);
        this.survey = surveySetup;
    }

    public int doStartTag() {
        try {
            this.initAttributes();
            if (DatabaseList.debug) {
                Maintenance.debugOutput("GenericUpdate.doStartTag()");
            }
            this.doUpdate();
            if (this.returnMessage != null) {
                this.setLastMessage(this.returnMessage);
            }
        }
        catch (Exception e) {
            String errorMessage = "cmu.survey.GenericUpdate.doStartTag() has thrown an error: " + e;
            Maintenance.sendBug(errorMessage, e);
            this.setLastMessage("Error: " + e);
        }
        return 0;
    }

    public void reinit() {
        super.reinit();
        this.whereOfKeys = null;
        this.saveChangesToDB = true;
        this.changedDBLastUpdate = false;
        this.lastMessage = null;
    }

    static {
        NOTHING = -1;
        UPDATE = 1;
        INSERT = 2;
        DELETE = 3;
    }
}

