/*
 * Decompiled with CFR 0.152.
 */
package cmu.survey;

import cmu.survey.DatabaseList;
import cmu.survey.Maintenance;
import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;

public class DatabaseUpdate
extends DatabaseList {
    protected String dbTable;
    protected String whereClause = null;
    protected Enumeration formFields;
    protected static final int dbInsert = 1;
    protected static final int dbUpdate = 2;
    protected static final int dbDelete = 3;
    protected int currentMode = 0;
    protected HttpServletRequest theRequest = null;
    public static final String[] monthArray;
    public static final String[] weekdayArray;

    protected void initAttributes() throws IOException {
        this.setupConnection();
        this.theRequest = (HttpServletRequest)this.pageContext.getRequest();
        this.dbTable = this.theRequest.getParameter("tableName");
        this.whereClause = this.theRequest.getParameter("queryWhere");
        this.formFields = this.theRequest.getParameterNames();
        String dbmode = this.theRequest.getParameter("databaseAction");
        if (dbmode != null) {
            this.currentMode = Integer.parseInt(dbmode.trim());
        }
    }

    public int doStartTag() {
        try {
            this.initAttributes();
            if (this.dbTable == null || this.whereClause == null) {
                return 0;
            }
            DatabaseMetaData dbMeta = this.databaseConnection.getMetaData();
            this.pageContext.setAttribute("dbMessage", (Object)this.returnMessage);
        }
        catch (Exception e) {
            Maintenance.sendBug("cmu.survey.DatabaseUpdate.doStartTag() threw an error: " + e, e);
            System.out.println("DatabaseUpdate() has thrown an error: " + e);
        }
        return 0;
    }

    protected void cleanExecute(String SQLstring) throws IOException {
        if (this.whereClause != null && !this.whereClause.equals("EMPTY") && this.whereClause.length() > 0 && !this.whereClause.equalsIgnoreCase("null")) {
            SQLstring = SQLstring + " WHERE " + this.whereClause;
        }
        this.doQuery(SQLstring);
    }

    protected static String nullEmpty(String theParameter) {
        if (theParameter == null) {
            return "null";
        }
        String newParameter = theParameter.trim();
        if (newParameter.equals("")) {
            return "null";
        }
        return newParameter;
    }

    protected String fixSQLString(String aStringParam) {
        int aposPlace = aStringParam.indexOf("'");
        while (aposPlace != -1) {
            aStringParam = aStringParam.substring(0, aposPlace) + "''" + aStringParam.substring(aposPlace + 1);
            aposPlace = aStringParam.indexOf("'", aposPlace + 2);
        }
        return aStringParam;
    }

    public static final String fixSQLString2(String aStringParam) {
        String newSQL = "";
        if (aStringParam == null) {
            return aStringParam;
        }
        int i = 0;
        while (i < aStringParam.length()) {
            String character = aStringParam.substring(i, i + 1);
            if (character.equals("\\")) {
                character = "\\\\";
            } else if (character.equals("'")) {
                character = "\\'";
            } else if (character.equals("\"")) {
                character = "\\\"";
            }
            newSQL = newSQL + character;
            ++i;
        }
        return aStringParam;
    }

    public String assembleDate(String theMonth, String theDay, String theYear) {
        if ((theMonth = this.theRequest.getParameter(theMonth)) == null || theMonth.length() < 1) {
            return null;
        }
        if (theMonth.endsWith("\n")) {
            theMonth = theMonth.substring(0, theMonth.length() - 1);
        }
        return theMonth + "/" + this.theRequest.getParameter(theDay) + "/" + this.theRequest.getParameter(theYear);
    }

    public String assembleDateSQL(String theMonth, String theDay, String theYear) {
        return this.theRequest.getParameter(theYear) + "-" + this.theRequest.getParameter(theMonth) + "-" + this.theRequest.getParameter(theDay);
    }

    public void reinit() {
        super.reinit();
        this.whereClause = null;
        this.dbTable = null;
        this.formFields = null;
        this.currentMode = 0;
    }

    static {
        dbInsert = 1;
        dbUpdate = 2;
        dbDelete = 3;
        monthArray = new String[]{null, "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        weekdayArray = new String[]{null, "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    }
}

