/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.ui.about;

import com.jrefinery.ui.about.Contributor;
import com.jrefinery.ui.about.Library;
import java.awt.Image;
import java.util.Iterator;
import java.util.List;

public class ProjectInfo {
    protected String name;
    protected String version;
    protected String copyright;
    protected String info;
    protected Image logo;
    protected String licenceName;
    protected String licenceText;
    protected List contributors;
    protected List libraries;

    public ProjectInfo() {
    }

    public ProjectInfo(String name, String version, String info, Image logo, String copyright, String licenceName, String licenceText) {
        this.name = name;
        this.version = version;
        this.info = info;
        this.logo = logo;
        this.copyright = copyright;
        this.licenceName = licenceName;
        this.licenceText = licenceText;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getInfo() {
        return this.info;
    }

    public Image getLogo() {
        return this.logo;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public String getLicenceName() {
        return this.licenceName;
    }

    public String getLicenceText() {
        return this.licenceText;
    }

    public List getContributors() {
        return this.contributors;
    }

    public List getLibraries() {
        return this.libraries;
    }

    public String toString() {
        String result = this.getName() + " version " + this.getVersion() + ".\n";
        result = result + this.getCopyright() + ".\n";
        result = result + "\n";
        result = result + "For terms of use, see the licence below.\n";
        result = result + "\n";
        result = result + "FURTHER INFORMATION:";
        result = result + this.getInfo();
        result = result + "\n";
        result = result + "CONTRIBUTORS:";
        List contributors = this.getContributors();
        if (contributors != null) {
            Iterator iterator = this.getContributors().iterator();
            while (iterator.hasNext()) {
                Contributor contributor = (Contributor)iterator.next();
                result = result + contributor.getName() + " (" + contributor.getEmail() + ").";
            }
        } else {
            result = result + "None";
        }
        result = result + "\n";
        result = result + "OTHER LIBRARIES USED BY JCOMMON:";
        List libraries = this.getLibraries();
        if (libraries != null) {
            Iterator iterator = this.getLibraries().iterator();
            while (iterator.hasNext()) {
                Library lib = (Library)iterator.next();
                result = result + lib.getName() + " " + lib.getVersion() + " (" + lib.getInfo() + ").";
            }
        } else {
            result = result + "None";
        }
        result = result + "\n";
        result = result + "JCOMMON LICENCE TERMS:";
        result = result + "\n";
        result = result + this.getLicenceText();
        return result;
    }
}

