/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.ui.about;

import com.jrefinery.ui.about.Contributor;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;

public class ContributorsTableModel
extends AbstractTableModel {
    protected List contributors;
    protected String nameColumnLabel;
    protected String contactColumnLabel;

    public ContributorsTableModel(List contributors) {
        this.contributors = contributors;
        String baseName = "com.jrefinery.ui.about.resources.AboutResources";
        ResourceBundle resources = ResourceBundle.getBundle(baseName);
        this.nameColumnLabel = resources.getString("contributors-table.column.name");
        this.contactColumnLabel = resources.getString("contributors-table.column.contact");
    }

    public int getRowCount() {
        return this.contributors.size();
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int column) {
        String result = null;
        switch (column) {
            case 0: {
                result = this.nameColumnLabel;
                break;
            }
            case 1: {
                result = this.contactColumnLabel;
            }
        }
        return result;
    }

    public Object getValueAt(int row, int column) {
        String result = null;
        Contributor contributor = (Contributor)this.contributors.get(row);
        if (column == 0) {
            result = contributor.getName();
        } else if (column == 1) {
            result = contributor.getEmail();
        }
        return result;
    }
}

