/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.date.junit;

import com.jrefinery.date.SerialDate;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class SerialDateTests
extends TestCase {
    protected SerialDate Nov_9_2001;
    static /* synthetic */ Class class$com$jrefinery$date$junit$SerialDateTests;

    public SerialDateTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(class$com$jrefinery$date$junit$SerialDateTests == null ? (class$com$jrefinery$date$junit$SerialDateTests = SerialDateTests.class$("com.jrefinery.date.junit.SerialDateTests")) : class$com$jrefinery$date$junit$SerialDateTests);
    }

    protected void setUp() {
        this.Nov_9_2001 = SerialDate.createInstance(9, 11, 2001);
    }

    public void testMondayPrecedingFriday9Nov2001() {
        SerialDate mondayBefore = SerialDate.getPreviousDayOfWeek(2, this.Nov_9_2001);
        SerialDateTests.assertEquals((int)5, (int)mondayBefore.getDayOfMonth());
    }

    public void testMondayFollowingFriday9Nov2001() {
        SerialDate mondayAfter = SerialDate.getFollowingDayOfWeek(2, this.Nov_9_2001);
        SerialDateTests.assertEquals((int)12, (int)mondayAfter.getDayOfMonth());
    }

    public void testMondayNearestFriday9Nov2001() {
        SerialDate mondayNearest = SerialDate.getNearestDayOfWeek(2, this.Nov_9_2001);
        SerialDateTests.assertEquals((int)12, (int)mondayNearest.getDayOfMonth());
    }

    public void testMondayNearest22Jan1970() {
        SerialDate Jan_22_1970 = SerialDate.createInstance(22, 1, 1970);
        SerialDate mondayNearest = SerialDate.getNearestDayOfWeek(2, Jan_22_1970);
        SerialDateTests.assertEquals((int)19, (int)mondayNearest.getDayOfMonth());
    }

    public void testWeekdayCodeToString() {
        String test = SerialDate.weekdayCodeToString(7);
        Assert.assertEquals((Object)"Saturday", (Object)test);
    }

    public void testStringToWeekday() {
        int weekday = SerialDate.stringToWeekdayCode("Wednesday");
        Assert.assertEquals((int)4, (int)weekday);
        weekday = SerialDate.stringToWeekdayCode(" Wednesday ");
        Assert.assertEquals((int)4, (int)weekday);
        weekday = SerialDate.stringToWeekdayCode("Wed");
        Assert.assertEquals((int)4, (int)weekday);
    }

    public void testStringToMonthCode() {
        int m = SerialDate.stringToMonthCode("January");
        Assert.assertEquals((int)1, (int)m);
        m = SerialDate.stringToMonthCode(" January ");
        Assert.assertEquals((int)1, (int)m);
        m = SerialDate.stringToMonthCode("Jan");
        Assert.assertEquals((int)1, (int)m);
    }

    public void testMonthCodeToStringCode() {
        String test = SerialDate.monthCodeToString(12);
        Assert.assertEquals((Object)"December", (Object)test);
    }

    public void testIsNotLeapYear1900() {
        Assert.assertTrue((!SerialDate.isLeapYear(1900) ? 1 : 0) != 0);
    }

    public void testIsLeapYear2000() {
        Assert.assertTrue((boolean)SerialDate.isLeapYear(2000));
    }

    public void testLeapYearCount1899() {
        Assert.assertEquals((int)SerialDate.leapYearCount(1899), (int)0);
    }

    public void testLeapYearCount1903() {
        Assert.assertEquals((int)SerialDate.leapYearCount(1903), (int)0);
    }

    public void testLeapYearCount1904() {
        Assert.assertEquals((int)SerialDate.leapYearCount(1904), (int)1);
    }

    public void testLeapYearCount1999() {
        Assert.assertEquals((int)SerialDate.leapYearCount(1999), (int)24);
    }

    public void testLeapYearCount2000() {
        Assert.assertEquals((int)SerialDate.leapYearCount(2000), (int)25);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

