/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.date;

import com.jrefinery.date.SerialDate;
import java.util.Calendar;
import java.util.Date;

public class SpreadsheetDate
extends SerialDate {
    protected int serial;
    protected int day;
    protected int month;
    protected int year;
    protected String description;

    public SpreadsheetDate(int day, int month, int year) {
        if (year < 1900 || year > 9999) {
            throw new IllegalArgumentException("SpreadsheetDate: Year must be in range 1900 to 9999.");
        }
        this.year = year;
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("SpreadsheetDate: Invalid month.");
        }
        this.month = month;
        if (day < 1 || day > SerialDate.lastDayOfMonth(month, year)) {
            throw new IllegalArgumentException("SpreadsheetDate: Invalid day.");
        }
        this.day = day;
        this.serial = this.calcSerial(day, month, year);
        this.description = null;
    }

    public SpreadsheetDate(int serial) {
        if (serial < SerialDate.SERIAL_LOWER_BOUND || serial > SerialDate.SERIAL_UPPER_BOUND) {
            throw new IllegalArgumentException("SpreadsheetDate: Serial must be in range 2 to 2958465.");
        }
        this.serial = serial;
        this.calcDayMonthYear();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int toSerial() {
        return this.serial;
    }

    public Date toDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.getYYYY(), this.getMonth() - 1, this.getDayOfMonth(), 0, 0, 0);
        return calendar.getTime();
    }

    public int getYYYY() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.day;
    }

    public int getDayOfWeek() {
        return (this.serial + 6) % 7 + 1;
    }

    public boolean equals(Object object) {
        if (object instanceof SerialDate) {
            SerialDate s = (SerialDate)object;
            return s.toSerial() == this.toSerial();
        }
        return false;
    }

    public int compare(SerialDate other) {
        return this.serial - other.toSerial();
    }

    public boolean isOn(SerialDate other) {
        return this.serial == other.toSerial();
    }

    public boolean isBefore(SerialDate other) {
        return this.serial < other.toSerial();
    }

    public boolean isOnOrBefore(SerialDate other) {
        return this.serial <= other.toSerial();
    }

    public boolean isAfter(SerialDate other) {
        return this.serial > other.toSerial();
    }

    public boolean isOnOrAfter(SerialDate other) {
        return this.serial >= other.toSerial();
    }

    public boolean isInRange(SerialDate d1, SerialDate d2) {
        return false;
    }

    public boolean isInRange(SerialDate d1, SerialDate d2, int include) {
        return false;
    }

    private int calcSerial(int day, int month, int year) {
        int y = (year - 1900) * 365 + SerialDate.leapYearCount(year - 1);
        int m = SerialDate.AGGREGATE_DAYS_TO_END_OF_PRECEDING_MONTH[month];
        if (month > 2 && SerialDate.isLeapYear(year)) {
            ++m;
        }
        int d = day;
        return y + m + d + 1;
    }

    private void calcDayMonthYear() {
        int days = this.serial - SerialDate.SERIAL_LOWER_BOUND;
        int overestimatedYYYY = 1900 + days / 365;
        int leaps = SerialDate.leapYearCount(overestimatedYYYY);
        int nonleapdays = days - leaps;
        int underestimatedYYYY = 1900 + nonleapdays / 365;
        if (underestimatedYYYY == overestimatedYYYY) {
            this.year = underestimatedYYYY;
        } else {
            int ss1 = this.calcSerial(1, 1, underestimatedYYYY);
            while (ss1 <= this.serial) {
                ss1 = this.calcSerial(1, 1, ++underestimatedYYYY);
            }
            this.year = underestimatedYYYY - 1;
        }
        int ss2 = this.calcSerial(1, 1, this.year);
        int[] daysToEndOfPrecedingMonth = SerialDate.AGGREGATE_DAYS_TO_END_OF_PRECEDING_MONTH;
        if (SerialDate.isLeapYear(this.year)) {
            daysToEndOfPrecedingMonth = SerialDate.LEAP_YEAR_AGGREGATE_DAYS_TO_END_OF_PRECEDING_MONTH;
        }
        int mm = 1;
        int sss = ss2 + daysToEndOfPrecedingMonth[mm] - 1;
        while (sss < this.serial) {
            sss = ss2 + daysToEndOfPrecedingMonth[++mm] - 1;
        }
        this.month = mm - 1;
        this.day = this.serial - ss2 - daysToEndOfPrecedingMonth[this.month] + 1;
    }

    public static void main(String[] args) {
        SerialDate date = SerialDate.createInstance(1, 2, 2000);
        while (true) {
            System.out.println("Date = " + date.toString());
            date = SerialDate.addDays(1, date);
        }
    }
}

