/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data.junit;

import com.jrefinery.data.Quarter;
import com.jrefinery.data.TimePeriodFormatException;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class QuarterTests
extends TestCase {
    protected Quarter q1_1900;
    protected Quarter q2_1900;
    protected Quarter q3_9999;
    protected Quarter q4_9999;
    static /* synthetic */ Class class$com$jrefinery$data$junit$QuarterTests;

    public static Test suite() {
        return new TestSuite(class$com$jrefinery$data$junit$QuarterTests == null ? (class$com$jrefinery$data$junit$QuarterTests = QuarterTests.class$("com.jrefinery.data.junit.QuarterTests")) : class$com$jrefinery$data$junit$QuarterTests);
    }

    public QuarterTests(String name) {
        super(name);
    }

    protected void setUp() {
        this.q1_1900 = new Quarter(1, 1900);
        this.q2_1900 = new Quarter(2, 1900);
        this.q3_9999 = new Quarter(3, 9999);
        this.q4_9999 = new Quarter(4, 9999);
    }

    public void testEqualsSelf() {
        Quarter quarter = new Quarter();
        QuarterTests.assertTrue((boolean)quarter.equals(quarter));
    }

    public void testEquals() {
        Quarter q1 = new Quarter(2, 2002);
        Quarter q2 = new Quarter(2, 2002);
        QuarterTests.assertTrue((boolean)q1.equals(q2));
    }

    public void testDateConstructor1() {
        TimeZone zone = TimeZone.getTimeZone("GMT");
        Quarter q1 = new Quarter(new Date(1017619199999L), zone);
        Quarter q2 = new Quarter(new Date(1017619200000L), zone);
        QuarterTests.assertEquals((int)1, (int)q1.getQuarter());
        QuarterTests.assertEquals((long)1017619199999L, (long)q1.getEnd(zone));
        QuarterTests.assertEquals((int)2, (int)q2.getQuarter());
        QuarterTests.assertEquals((long)1017619200000L, (long)q2.getStart(zone));
    }

    public void testDateConstructor2() {
        TimeZone zone = TimeZone.getTimeZone("Europe/Istanbul");
        Quarter q1 = new Quarter(new Date(1017608399999L), zone);
        Quarter q2 = new Quarter(new Date(1017608400000L), zone);
        QuarterTests.assertEquals((int)1, (int)q1.getQuarter());
        QuarterTests.assertEquals((long)1017608399999L, (long)q1.getEnd(zone));
        QuarterTests.assertEquals((int)2, (int)q2.getQuarter());
        QuarterTests.assertEquals((long)1017608400000L, (long)q2.getStart(zone));
    }

    public void testQ1_1900_previous() {
        Quarter previous = (Quarter)this.q1_1900.previous();
        QuarterTests.assertNull((Object)previous);
    }

    public void testQ1_1900_next() {
        Quarter next = (Quarter)this.q1_1900.next();
        QuarterTests.assertEquals((Object)this.q2_1900, (Object)next);
    }

    public void testQ4_9999_previous() {
        Quarter previous = (Quarter)this.q4_9999.previous();
        QuarterTests.assertEquals((Object)this.q3_9999, (Object)previous);
    }

    public void testQ4_9999_next() {
        Quarter next = (Quarter)this.q4_9999.next();
        QuarterTests.assertNull((Object)next);
    }

    public void testParseQuarter() {
        Quarter quarter = null;
        try {
            quarter = Quarter.parseQuarter("Q1-2000");
        }
        catch (TimePeriodFormatException e) {
            quarter = new Quarter(1, 1900);
        }
        QuarterTests.assertEquals((int)1, (int)quarter.getQuarter());
        QuarterTests.assertEquals((int)2000, (int)quarter.getYear().getYear());
        try {
            quarter = Quarter.parseQuarter("2001-Q2");
        }
        catch (TimePeriodFormatException e) {
            quarter = new Quarter(1, 1900);
        }
        QuarterTests.assertEquals((int)2, (int)quarter.getQuarter());
        QuarterTests.assertEquals((int)2001, (int)quarter.getYear().getYear());
        try {
            quarter = Quarter.parseQuarter("Q3, 2002");
        }
        catch (TimePeriodFormatException e) {
            quarter = new Quarter(1, 1900);
        }
        QuarterTests.assertEquals((int)3, (int)quarter.getQuarter());
        QuarterTests.assertEquals((int)2002, (int)quarter.getYear().getYear());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

