/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data.junit;

import com.jrefinery.data.Month;
import com.jrefinery.data.TimePeriodFormatException;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class MonthTests
extends TestCase {
    protected Month jan_1900;
    protected Month feb_1900;
    protected Month nov_9999;
    protected Month dec_9999;
    static /* synthetic */ Class class$com$jrefinery$data$junit$MonthTests;

    public static Test suite() {
        return new TestSuite(class$com$jrefinery$data$junit$MonthTests == null ? (class$com$jrefinery$data$junit$MonthTests = MonthTests.class$("com.jrefinery.data.junit.MonthTests")) : class$com$jrefinery$data$junit$MonthTests);
    }

    public MonthTests(String name) {
        super(name);
    }

    protected void setUp() {
        this.jan_1900 = new Month(1, 1900);
        this.feb_1900 = new Month(2, 1900);
        this.nov_9999 = new Month(11, 9999);
        this.dec_9999 = new Month(12, 9999);
    }

    public void testEqualsSelf() {
        Month month = new Month();
        MonthTests.assertTrue((boolean)month.equals(month));
    }

    public void testEquals() {
        Month m1 = new Month(5, 2002);
        Month m2 = new Month(5, 2002);
        MonthTests.assertTrue((boolean)m1.equals(m2));
    }

    public void testDateConstructor1() {
        TimeZone zone = TimeZone.getTimeZone("GMT");
        Month m1 = new Month(new Date(951868799999L), zone);
        Month m2 = new Month(new Date(951868800000L), zone);
        MonthTests.assertEquals((int)2, (int)m1.getMonth());
        MonthTests.assertEquals((long)951868799999L, (long)m1.getEnd(zone));
        MonthTests.assertEquals((int)3, (int)m2.getMonth());
        MonthTests.assertEquals((long)951868800000L, (long)m2.getStart(zone));
    }

    public void testDateConstructor2() {
        TimeZone zone = TimeZone.getTimeZone("Pacific/Auckland");
        Month m1 = new Month(new Date(951821999999L), zone);
        Month m2 = new Month(new Date(951822000000L), zone);
        MonthTests.assertEquals((int)2, (int)m1.getMonth());
        MonthTests.assertEquals((long)951821999999L, (long)m1.getEnd(zone));
        MonthTests.assertEquals((int)3, (int)m2.getMonth());
        MonthTests.assertEquals((long)951822000000L, (long)m2.getStart(zone));
    }

    public void testJan_1900_previous() {
        Month previous = (Month)this.jan_1900.previous();
        MonthTests.assertNull((Object)previous);
    }

    public void testJan_1900_next() {
        Month next = (Month)this.jan_1900.next();
        MonthTests.assertEquals((Object)this.feb_1900, (Object)next);
    }

    public void testDec_9999_previous() {
        Month previous = (Month)this.dec_9999.previous();
        MonthTests.assertEquals((Object)this.nov_9999, (Object)previous);
    }

    public void testDec_9999_next() {
        Month next = (Month)this.dec_9999.next();
        MonthTests.assertNull((Object)next);
    }

    public void testParseMonth() {
        Month month = null;
        try {
            month = Month.parseMonth("1990-01");
        }
        catch (TimePeriodFormatException e) {
            month = new Month(1, 1900);
        }
        MonthTests.assertEquals((int)1, (int)month.getMonth());
        MonthTests.assertEquals((int)1990, (int)month.getYear().getYear());
        try {
            month = Month.parseMonth("02-1991");
        }
        catch (TimePeriodFormatException e) {
            month = new Month(1, 1900);
        }
        MonthTests.assertEquals((int)2, (int)month.getMonth());
        MonthTests.assertEquals((int)1991, (int)month.getYear().getYear());
        try {
            month = Month.parseMonth("March 1993");
        }
        catch (TimePeriodFormatException e) {
            month = new Month(1, 1900);
        }
        MonthTests.assertEquals((int)3, (int)month.getMonth());
        MonthTests.assertEquals((int)1993, (int)month.getYear().getYear());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

