/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.AbstractSeriesDataset;
import com.jrefinery.data.BasicTimeSeries;
import com.jrefinery.data.IntervalXYDataset;
import com.jrefinery.data.TimePeriod;
import com.jrefinery.data.TimeSeriesDataPair;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;

public class TimeSeriesCollection
extends AbstractSeriesDataset
implements IntervalXYDataset {
    public static final int START = 0;
    public static final int MIDDLE = 1;
    public static final int END = 2;
    protected List data = new ArrayList();
    protected Calendar workingCalendar;
    protected int position;

    public TimeSeriesCollection() {
        this(null, TimeZone.getDefault());
    }

    public TimeSeriesCollection(TimeZone zone) {
        this(null, zone);
    }

    public TimeSeriesCollection(BasicTimeSeries series) {
        this(series, TimeZone.getDefault());
    }

    public TimeSeriesCollection(BasicTimeSeries series, TimeZone zone) {
        if (series != null) {
            this.data.add(series);
            series.addChangeListener(this);
        }
        this.workingCalendar = Calendar.getInstance(zone);
        this.position = 0;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public BasicTimeSeries getSeries(int series) {
        if (series < 0 || series > this.getSeriesCount()) {
            throw new IllegalArgumentException("TimeSeriesDataset.getSeries(...): index outside valid range.");
        }
        BasicTimeSeries ts = (BasicTimeSeries)this.data.get(series);
        return ts;
    }

    public String getSeriesName(int series) {
        return this.getSeries(series).getName();
    }

    public void addSeries(BasicTimeSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("TimeSeriesDataset.addSeries(...): cannot add null series.");
        }
        this.data.add(series);
        series.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public int getItemCount(int series) {
        return this.getSeries(series).getItemCount();
    }

    public Number getXValue(int series, int item) {
        BasicTimeSeries ts = (BasicTimeSeries)this.data.get(series);
        TimeSeriesDataPair dp = ts.getDataPair(item);
        TimePeriod period = dp.getPeriod();
        long result = 0L;
        switch (this.position) {
            case 0: {
                result = period.getStart(this.workingCalendar);
                break;
            }
            case 1: {
                result = period.getMiddle(this.workingCalendar);
                break;
            }
            case 2: {
                result = period.getEnd(this.workingCalendar);
                break;
            }
            default: {
                result = period.getMiddle(this.workingCalendar);
            }
        }
        return new Long(result);
    }

    public Number getStartXValue(int series, int item) {
        BasicTimeSeries ts = (BasicTimeSeries)this.data.get(series);
        TimeSeriesDataPair dp = ts.getDataPair(item);
        return new Long(dp.getPeriod().getStart(this.workingCalendar));
    }

    public Number getEndXValue(int series, int item) {
        BasicTimeSeries ts = (BasicTimeSeries)this.data.get(series);
        TimeSeriesDataPair dp = ts.getDataPair(item);
        return new Long(dp.getPeriod().getEnd(this.workingCalendar));
    }

    public Number getYValue(int series, int item) {
        BasicTimeSeries ts = (BasicTimeSeries)this.data.get(series);
        TimeSeriesDataPair dp = ts.getDataPair(item);
        return dp.getValue();
    }

    public Number getStartYValue(int series, int item) {
        return this.getYValue(series, item);
    }

    public Number getEndYValue(int series, int item) {
        return this.getYValue(series, item);
    }

    static {
        START = 0;
        MIDDLE = 1;
        END = 2;
    }
}

