/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

public class Statistics {
    public static double getAverage(Number[] data) {
        double sum = 0.0;
        int counter = 0;
        while (counter < data.length) {
            sum += data[counter].doubleValue();
            ++counter;
        }
        return sum / (double)counter;
    }

    public static double getStdDev(Number[] data) {
        double avg = Statistics.getAverage(data);
        double sum = 0.0;
        int counter = 0;
        double diff = 0.0;
        while (counter < data.length) {
            diff = data[counter].doubleValue() - avg;
            sum += diff * diff;
            ++counter;
        }
        return Math.sqrt(sum / (double)(counter - 1));
    }

    public static double[] getLinearFit(Number[] x_data, Number[] y_data) {
        if (x_data.length != y_data.length) {
            throw new IllegalArgumentException("Statistics.getLinearFit(...): array lengths must be equal.");
        }
        double[] result = new double[2];
        result[1] = Statistics.getSlope(x_data, y_data);
        result[0] = Statistics.getAverage(y_data) - result[1] * Statistics.getAverage(x_data);
        return result;
    }

    public static double getSlope(Number[] x_data, Number[] y_data) {
        if (x_data.length != y_data.length) {
            throw new IllegalArgumentException("Statistics.getSlope(...): array lengths must be equal.");
        }
        double sx = 0.0;
        double sxx = 0.0;
        double sxy = 0.0;
        double sy = 0.0;
        int counter = 0;
        while (counter < x_data.length) {
            sx += x_data[counter].doubleValue();
            sxx += Math.pow(x_data[counter].doubleValue(), 2.0);
            sxy += y_data[counter].doubleValue() * x_data[counter].doubleValue();
            sy += y_data[counter].doubleValue();
            ++counter;
        }
        return (sxy - sx * sy / (double)counter) / (sxx - sx * sx / (double)counter);
    }

    public static double getCorrelation(Number[] data1, Number[] data2) {
        if (data1.length != data2.length) {
            throw new IllegalArgumentException("Statistics.getCorrelation(...): array lengths must be equal.");
        }
        double xavg = 0.0;
        double yavg = 0.0;
        double xstd = 0.0;
        double ystd = 0.0;
        int counter = 0;
        Number[] x_data = new Double[data1.length];
        Number[] y_data = new Double[data2.length];
        int i = 0;
        while (i < data1.length) {
            x_data[i] = new Double(data1[i].doubleValue());
            ++i;
        }
        int i2 = 0;
        while (i2 < data2.length) {
            y_data[i2] = new Double(data2[i2].doubleValue());
            ++i2;
        }
        xavg = Statistics.getAverage(x_data);
        yavg = Statistics.getAverage(y_data);
        xstd = Statistics.getStdDev(x_data);
        ystd = Statistics.getStdDev(y_data);
        while (counter < x_data.length) {
            x_data[counter] = new Double((x_data[counter].doubleValue() - xavg) / xstd);
            y_data[counter] = new Double((y_data[counter].doubleValue() - yavg) / ystd);
            ++counter;
        }
        counter = 0;
        while (counter < x_data.length) {
            x_data[counter] = new Double(x_data[counter].doubleValue() * y_data[counter].doubleValue());
            ++counter;
        }
        return Statistics.getAverage(x_data);
    }

    public static double[][] getMovingAverage(Number[] x_data, Number[] y_data, int period) {
        if (x_data.length != y_data.length) {
            throw new IllegalArgumentException("Statistics.getMovingAverage(...): array lengths must be equal.");
        }
        if (period > x_data.length) {
            throw new IllegalArgumentException("Statistics.getMovingAverage(...): period can't be longer than dataset.");
        }
        double[][] result = new double[x_data.length - period][2];
        int i = 0;
        while (i < result.length) {
            result[i][0] = x_data[i + period].doubleValue();
            double sum = 0.0;
            int j = 0;
            while (j < period) {
                sum += y_data[i + j].doubleValue();
                ++j;
            }
            result[i][1] = sum /= (double)period;
            ++i;
        }
        return result;
    }
}

