/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.Day;
import com.jrefinery.data.Hour;
import com.jrefinery.data.Minute;
import com.jrefinery.data.TimePeriod;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Second
extends TimePeriod {
    private static int FIRST_SECOND_IN_MINUTE = 0;
    private static int LAST_SECOND_IN_MINUTE = 59;
    protected Minute minute;
    protected int second;

    public Second() {
        this(new Date());
    }

    public Second(int second, Minute minute) {
        this.minute = minute;
        this.second = second;
    }

    public Second(Date time) {
        this(time, TimePeriod.DEFAULT_TIME_ZONE);
    }

    public Second(Date time, TimeZone zone) {
        this.minute = new Minute(time, zone);
        Calendar calendar = Calendar.getInstance(zone);
        calendar.setTime(time);
        this.second = calendar.get(13);
    }

    public int getSecond() {
        return this.second;
    }

    public Minute getMinute() {
        return this.minute;
    }

    public TimePeriod previous() {
        Second result = null;
        if (this.second != FIRST_SECOND_IN_MINUTE) {
            result = new Second(this.second - 1, this.minute);
        } else {
            Minute previous = (Minute)this.minute.previous();
            if (previous != null) {
                result = new Second(LAST_SECOND_IN_MINUTE, previous);
            }
        }
        return result;
    }

    public TimePeriod next() {
        Second result = null;
        if (this.second != LAST_SECOND_IN_MINUTE) {
            result = new Second(this.second + 1, this.minute);
        } else {
            Minute next = (Minute)this.minute.next();
            if (next != null) {
                result = new Second(FIRST_SECOND_IN_MINUTE, next);
            }
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object instanceof Second) {
            Second s = (Second)object;
            return this.second == s.getSecond() && this.minute.equals(s.getMinute());
        }
        return false;
    }

    public int compareTo(Object o1) {
        int result;
        if (o1 instanceof Second) {
            Second s = (Second)o1;
            result = this.minute.compareTo(s.minute);
            if (result == 0) {
                result = this.second - s.second;
            }
        } else {
            result = o1 instanceof TimePeriod ? 0 : 1;
        }
        return result;
    }

    public long getStart(Calendar calendar) {
        return this.minute.getStart(calendar) + (long)this.second * 1000L;
    }

    public long getEnd(Calendar calendar) {
        return this.minute.getStart(calendar) + (long)this.second * 1000L + 999L;
    }

    public static Second parseSecond(String s) {
        Second result = null;
        String daystr = (s = s.trim()).substring(0, Math.min(10, s.length()));
        Day day = Day.parseDay(daystr);
        if (day != null) {
            int minute;
            String hmsstr = s.substring(Math.min(daystr.length() + 1, s.length()), s.length());
            hmsstr = hmsstr.trim();
            int l = hmsstr.length();
            String hourstr = hmsstr.substring(0, Math.min(2, l));
            String minstr = hmsstr.substring(Math.min(3, l), Math.min(5, l));
            String secstr = hmsstr.substring(Math.min(6, l), Math.min(8, l));
            int hour = Integer.parseInt(hourstr);
            if (hour >= 0 && hour <= 23 && (minute = Integer.parseInt(minstr)) >= 0 && minute <= 59) {
                Minute m = new Minute(minute, new Hour(hour, day));
                int second = Integer.parseInt(secstr);
                if (second >= 0 && second <= 59) {
                    result = new Second(second, m);
                }
            }
        }
        return result;
    }

    public static void main(String[] args) {
        String[] ids = TimeZone.getAvailableIDs();
        int i = 0;
        while (i < ids.length) {
            System.out.println(ids[i]);
            ++i;
        }
        TimeZone zone = TimeZone.getTimeZone("America/Chicago");
        GregorianCalendar calendar = new GregorianCalendar(zone);
        calendar.clear();
        calendar.set(2002, 2, 21, 16, 55, 59);
        System.out.println("4.55:59pm on 21-Mar-2002 in Chicago: " + calendar.getTime().getTime());
        Date time = new Date(1014307200000L);
        calendar.setTime(time);
        Hour hour = new Hour(time);
        System.out.println("Hour = " + hour.toString());
        System.out.println("Start = " + hour.getStart(zone));
        System.out.println("End = " + hour.getEnd(zone));
        System.out.println("Offset = " + zone.getRawOffset());
    }
}

