/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

public class Range {
    protected double lower;
    protected double upper;

    public Range(double lower, double upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("Range(double, double): require lower<=upper.");
        }
        this.lower = lower;
        this.upper = upper;
    }

    public double getLowerBound() {
        return this.lower;
    }

    public double getUpperBound() {
        return this.upper;
    }

    public double getLength() {
        return this.upper - this.lower;
    }

    public double getCentralValue() {
        return this.lower / 2.0 + this.upper / 2.0;
    }

    public boolean contains(double value) {
        return value >= this.lower && value <= this.upper;
    }

    public static Range combine(Range range1, Range range2) {
        Range result = null;
        if (range1 != null && range2 == null) {
            result = range1;
        } else if (range1 == null && range2 != null) {
            result = range2;
        } else {
            double l = Math.min(range1.getLowerBound(), range2.getLowerBound());
            double u = Math.max(range1.getUpperBound(), range2.getUpperBound());
            result = new Range(l, u);
        }
        return result;
    }
}

