/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.Day;
import com.jrefinery.data.Hour;
import com.jrefinery.data.TimePeriod;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Minute
extends TimePeriod {
    private static int FIRST_MINUTE_IN_HOUR = 0;
    private static int LAST_MINUTE_IN_HOUR = 59;
    private static long MILLISECONDS_PER_MINUTE = 60000L;
    protected Hour hour;
    int minute;

    public Minute() {
        this(new Date());
    }

    public Minute(int minute, Hour hour) {
        this.minute = minute;
        this.hour = hour;
    }

    public Minute(Date time) {
        this(time, TimePeriod.DEFAULT_TIME_ZONE);
    }

    public Minute(Date time, TimeZone zone) {
        int min;
        Calendar calendar = Calendar.getInstance(zone);
        calendar.setTime(time);
        this.minute = min = calendar.get(12);
        this.hour = new Hour(time, zone);
    }

    public Hour getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public TimePeriod previous() {
        Hour prevHour;
        Minute result = this.minute != FIRST_MINUTE_IN_HOUR ? new Minute(this.minute - 1, this.hour) : ((prevHour = (Hour)this.hour.previous()) != null ? new Minute(LAST_MINUTE_IN_HOUR, prevHour) : null);
        return result;
    }

    public TimePeriod next() {
        Hour nextHour;
        Minute result = this.minute != LAST_MINUTE_IN_HOUR ? new Minute(this.minute + 1, this.hour) : ((nextHour = (Hour)this.hour.next()) != null ? new Minute(FIRST_MINUTE_IN_HOUR, nextHour) : null);
        return result;
    }

    public boolean equals(Object object) {
        if (object instanceof Minute) {
            Minute m = (Minute)object;
            return this.minute == m.getMinute() && this.hour.equals(m.getHour());
        }
        return false;
    }

    public int compareTo(Object o1) {
        int result;
        if (o1 instanceof Minute) {
            Minute m = (Minute)o1;
            result = this.getHour().compareTo(m.getHour());
            if (result == 0) {
                result = this.minute - m.getMinute();
            }
        } else {
            result = o1 instanceof TimePeriod ? 0 : 1;
        }
        return result;
    }

    public long getStart(Calendar calendar) {
        int year = this.hour.day.getYear();
        int month = this.hour.day.getMonth() - 1;
        int day = this.hour.day.getDayOfMonth();
        calendar.clear();
        calendar.set(year, month, day, this.hour.getHour(), this.minute, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    public long getEnd(Calendar calendar) {
        int year = this.hour.day.getYear();
        int month = this.hour.day.getMonth() - 1;
        int day = this.hour.day.getDayOfMonth();
        calendar.clear();
        calendar.set(year, month, day, this.hour.getHour(), this.minute, 59);
        calendar.set(14, 999);
        return calendar.getTime().getTime();
    }

    public static Minute parseMinute(String s) {
        Minute result = null;
        String daystr = (s = s.trim()).substring(0, Math.min(10, s.length()));
        Day day = Day.parseDay(daystr);
        if (day != null) {
            String minstr;
            int minute;
            String hmstr = s.substring(Math.min(daystr.length() + 1, s.length()), s.length());
            String hourstr = (hmstr = hmstr.trim()).substring(0, Math.min(2, hmstr.length()));
            int hour = Integer.parseInt(hourstr);
            if (hour >= 0 && hour <= 23 && (minute = Integer.parseInt(minstr = hmstr.substring(Math.min(hourstr.length() + 1, hmstr.length()), hmstr.length()))) >= 0 && minute <= 59) {
                result = new Minute(minute, new Hour(hour, day));
            }
        }
        return result;
    }

    public static void main(String[] args) {
        String[] ids = TimeZone.getAvailableIDs();
        int i = 0;
        while (i < ids.length) {
            System.out.println(ids[i]);
            ++i;
        }
        TimeZone zone = TimeZone.getTimeZone("GMT");
        GregorianCalendar calendar = new GregorianCalendar(zone);
        calendar.clear();
        calendar.set(2002, 2, 21, 16, 55, 0);
        System.out.println("4.55pm on 21-Mar-2002 in GMT: " + calendar.getTime().getTime());
        Date time = new Date(1014307200000L);
        calendar.setTime(time);
        Hour hour = new Hour(time);
        System.out.println("Hour = " + hour.toString());
        System.out.println("Start = " + hour.getStart(zone));
        System.out.println("End = " + hour.getEnd(zone));
        System.out.println("Offset = " + zone.getRawOffset());
    }
}

