/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.Hour;
import com.jrefinery.data.Second;
import com.jrefinery.data.TimePeriod;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Millisecond
extends TimePeriod {
    public static final int FIRST_MILLISECOND_IN_SECOND = 0;
    public static final int LAST_MILLISECOND_IN_SECOND = 999;
    protected int millisecond;
    protected Second second;

    public Millisecond() {
        this(new Date());
    }

    public Millisecond(int millisecond, Second second) {
        this.millisecond = millisecond;
        this.second = second;
    }

    public Millisecond(Date time) {
        this(time, TimePeriod.DEFAULT_TIME_ZONE);
    }

    public Millisecond(Date time, TimeZone zone) {
        this.second = new Second(time, zone);
        Calendar calendar = Calendar.getInstance(zone);
        calendar.setTime(time);
        this.millisecond = calendar.get(14);
    }

    public Second getSecond() {
        return this.second;
    }

    public long getMillisecond() {
        return this.millisecond;
    }

    public TimePeriod previous() {
        Millisecond result = null;
        if (this.millisecond != 0) {
            result = new Millisecond(this.millisecond - 1, this.second);
        } else {
            Second previous = (Second)this.second.previous();
            if (previous != null) {
                result = new Millisecond(999, previous);
            }
        }
        return result;
    }

    public TimePeriod next() {
        Millisecond result = null;
        if (this.millisecond != 999) {
            result = new Millisecond(this.millisecond + 1, this.second);
        } else {
            Second next = (Second)this.second.next();
            if (next != null) {
                result = new Millisecond(0, next);
            }
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object instanceof Millisecond) {
            Millisecond m = (Millisecond)object;
            return (long)this.millisecond == m.getMillisecond() && this.second.equals(m.getSecond());
        }
        return false;
    }

    public int compareTo(Object o1) {
        int result;
        if (o1 instanceof Millisecond) {
            Millisecond ms = (Millisecond)o1;
            long difference = this.getStart() - ms.getStart();
            result = difference > 0L ? 1 : (difference < 0L ? -1 : 0);
        } else {
            result = o1 instanceof TimePeriod ? 0 : 1;
        }
        return result;
    }

    public long getStart() {
        return this.second.getStart() + (long)this.millisecond;
    }

    public long getStart(Calendar calendar) {
        return this.second.getStart(calendar) + (long)this.millisecond;
    }

    public long getEnd() {
        return this.second.getStart() + (long)this.millisecond;
    }

    public long getEnd(Calendar calendar) {
        return this.second.getStart(calendar) + (long)this.millisecond;
    }

    public String toString() {
        return String.valueOf(this.getStart());
    }

    public static void main(String[] args) {
        String[] ids = TimeZone.getAvailableIDs();
        int i = 0;
        while (i < ids.length) {
            System.out.println(ids[i]);
            ++i;
        }
        TimeZone zone = TimeZone.getTimeZone("Europe/Tallinn");
        GregorianCalendar calendar = new GregorianCalendar(zone);
        calendar.clear();
        calendar.set(2002, 2, 21, 16, 55, 59);
        calendar.set(14, 123);
        System.out.println("4.55:59.123pm on 21-Mar-2002 in GMT: " + calendar.getTime().getTime());
        Date time = new Date(1014307200000L);
        calendar.setTime(time);
        Hour hour = new Hour(time);
        System.out.println("Hour = " + hour.toString());
        System.out.println("Start = " + hour.getStart(zone));
        System.out.println("End = " + hour.getEnd(zone));
        System.out.println("Offset = " + zone.getRawOffset());
    }

    static {
        FIRST_MILLISECOND_IN_SECOND = 0;
        LAST_MILLISECOND_IN_SECOND = 999;
    }
}

