/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.Day;
import com.jrefinery.data.TimePeriod;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Hour
extends TimePeriod {
    private static int FIRST_HOUR_IN_DAY = 0;
    private static int LAST_HOUR_IN_DAY = 23;
    protected Day day;
    protected int hour;

    public Hour() {
        this(new Date());
    }

    public Hour(int hour, Day day) {
        this.hour = hour;
        this.day = day;
    }

    public Hour(Date time) {
        this(time, TimePeriod.DEFAULT_TIME_ZONE);
    }

    public Hour(Date time, TimeZone zone) {
        int hour;
        Calendar calendar = Calendar.getInstance(zone);
        calendar.setTime(time);
        this.hour = hour = calendar.get(11);
        this.day = new Day(time, zone);
    }

    public int getHour() {
        return this.hour;
    }

    public Day getDay() {
        return this.day;
    }

    public int getYear() {
        return this.day.getYear();
    }

    public int getMonth() {
        return this.day.getMonth();
    }

    public int getDayOfMonth() {
        return this.day.getDayOfMonth();
    }

    public TimePeriod previous() {
        Day prevDay;
        Hour result = this.hour != FIRST_HOUR_IN_DAY ? new Hour(this.hour - 1, this.day) : ((prevDay = (Day)this.day.previous()) != null ? new Hour(LAST_HOUR_IN_DAY, prevDay) : null);
        return result;
    }

    public TimePeriod next() {
        Day nextDay;
        Hour result = this.hour != LAST_HOUR_IN_DAY ? new Hour(this.hour + 1, this.day) : ((nextDay = (Day)this.day.next()) != null ? new Hour(FIRST_HOUR_IN_DAY, nextDay) : null);
        return result;
    }

    public boolean equals(Object object) {
        if (object instanceof Hour) {
            Hour h = (Hour)object;
            return this.hour == h.getHour() && this.day.equals(h.getDay());
        }
        return false;
    }

    public int compareTo(Object o1) {
        int result;
        if (o1 instanceof Hour) {
            Hour h = (Hour)o1;
            result = this.getDay().compareTo(h.getDay());
            if (result == 0) {
                result = this.hour - h.getHour();
            }
        } else {
            result = o1 instanceof TimePeriod ? 0 : 1;
        }
        return result;
    }

    public long getStart(Calendar calendar) {
        int year = this.day.getYear();
        int month = this.day.getMonth() - 1;
        int day = this.day.getDayOfMonth();
        calendar.set(year, month, day, this.hour, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    public long getEnd(Calendar calendar) {
        int year = this.day.getYear();
        int month = this.day.getMonth() - 1;
        int day = this.day.getDayOfMonth();
        calendar.set(year, month, day, this.hour, 59, 59);
        calendar.set(14, 999);
        return calendar.getTime().getTime();
    }

    public static Hour parseHour(String s) {
        Hour result = null;
        String daystr = (s = s.trim()).substring(0, Math.min(10, s.length()));
        Day day = Day.parseDay(daystr);
        if (day != null) {
            String hourstr = s.substring(Math.min(daystr.length() + 1, s.length()), s.length());
            int hour = Integer.parseInt(hourstr = hourstr.trim());
            if (hour >= FIRST_HOUR_IN_DAY && hour <= LAST_HOUR_IN_DAY) {
                result = new Hour(hour, day);
            }
        }
        return result;
    }

    public static void main(String[] args) {
        String[] ids = TimeZone.getAvailableIDs();
        int i = 0;
        while (i < ids.length) {
            System.out.println(ids[i]);
            ++i;
        }
        TimeZone zone = TimeZone.getTimeZone("Australia/Sydney");
        GregorianCalendar calendar = new GregorianCalendar(zone);
        calendar.clear();
        calendar.set(2002, 1, 21, 16, 0, 0);
        System.out.println("4pm on 21-Mar-2002 in Australia/Sydney: " + calendar.getTime().getTime());
        Date time = new Date(1014307200000L);
        calendar.setTime(time);
        Hour hour = new Hour(time);
        System.out.println("Hour = " + hour.toString());
        System.out.println("Start = " + hour.getStart(zone));
        System.out.println("End = " + hour.getEnd(zone));
        System.out.println("Offset = " + zone.getRawOffset());
    }
}

