/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.AbstractSeriesDataset;
import com.jrefinery.data.GanttSeries;
import com.jrefinery.data.IntervalCategoryDataset;
import com.jrefinery.data.TimeAllocation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GanttSeriesCollection
extends AbstractSeriesDataset
implements IntervalCategoryDataset {
    protected List tasks = new ArrayList();
    protected List data = new ArrayList();

    public String getSeriesName(int series) {
        GanttSeries gs = (GanttSeries)this.data.get(series);
        return gs.getName();
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public int getCategoryCount() {
        return this.tasks.size();
    }

    public List getCategories() {
        return this.tasks;
    }

    public void add(GanttSeries series) {
        this.data.add(series);
        Iterator iterator = series.tasks.iterator();
        while (iterator.hasNext()) {
            Object category = iterator.next();
            int index = this.tasks.indexOf(category);
            if (index >= 0) continue;
            this.tasks.add(category);
        }
    }

    public Number getValue(int series, Object category) {
        GanttSeries gs = (GanttSeries)this.data.get(series);
        TimeAllocation ta = gs.getTimeAllocation(category);
        return new Long(ta.getStart().getTime());
    }

    public Number getStartValue(int series, Object category) {
        GanttSeries gs = (GanttSeries)this.data.get(series);
        TimeAllocation ta = gs.getTimeAllocation(category);
        return new Long(ta.getStart().getTime());
    }

    public Number getEndValue(int series, Object category) {
        GanttSeries gs = (GanttSeries)this.data.get(series);
        TimeAllocation ta = gs.getTimeAllocation(category);
        return new Long(ta.getEnd().getTime());
    }
}

