/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.AbstractSeriesDataset;
import com.jrefinery.data.DatasetUtilities;
import com.jrefinery.data.IntervalCategoryDataset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;

public class DefaultIntervalCategoryDataset
extends AbstractSeriesDataset
implements IntervalCategoryDataset {
    protected String[] seriesNames;
    protected Object[] categories;
    protected Number[][] startData;
    protected Number[][] endData;

    public DefaultIntervalCategoryDataset(double[][] starts, double[][] ends) {
        this(DatasetUtilities.createNumberArray2D(starts), DatasetUtilities.createNumberArray2D(ends));
    }

    public DefaultIntervalCategoryDataset(Number[][] starts, Number[][] ends) {
        this(null, null, starts, ends);
    }

    public DefaultIntervalCategoryDataset(String[] seriesNames, Number[][] starts, Number[][] ends) {
        this(seriesNames, null, starts, ends);
    }

    public DefaultIntervalCategoryDataset(String[] seriesNames, Object[] categories, Number[][] starts, Number[][] ends) {
        this.startData = starts;
        this.endData = ends;
        if (starts != null && ends != null) {
            String baseName = "com.jrefinery.data.resources.DataPackageResources";
            ResourceBundle resources = ResourceBundle.getBundle(baseName);
            int series_count = starts.length;
            if (series_count != ends.length) {
                String errMsg = "DefaultIntervalCategoryDataset: the number of series in the start value dataset does not match the number of series in the end value dataset.";
                throw new IllegalArgumentException(errMsg);
            }
            if (series_count > 0) {
                if (seriesNames != null) {
                    if (seriesNames.length != series_count) {
                        throw new IllegalArgumentException("DefaultIntervalCategoryDataset: the number of series names does not match the number of series in the data.");
                    }
                    this.seriesNames = seriesNames;
                } else {
                    String prefix = resources.getString("series.default-prefix") + " ";
                    this.seriesNames = this.generateNames(series_count, prefix);
                }
                int category_count = starts[0].length;
                if (category_count != ends[0].length) {
                    String errMsg = "DefaultIntervalCategoryDataset: the number of categories in the start value dataset does not match the number of categories in the end value dataset.";
                    throw new IllegalArgumentException(errMsg);
                }
                if (categories != null) {
                    if (categories.length != category_count) {
                        throw new IllegalArgumentException("DefaultIntervalCategoryDataset: the number of categories does not match the number of categories in the data.");
                    }
                    this.categories = categories;
                } else {
                    String prefix = resources.getString("categories.default-prefix") + " ";
                    this.categories = this.generateNames(category_count, prefix);
                }
            } else {
                this.seriesNames = null;
                this.categories = null;
            }
        }
    }

    public int getSeriesCount() {
        int result = 0;
        if (this.startData != null) {
            result = this.startData.length;
        }
        return result;
    }

    public String getSeriesName(int series) {
        if (series >= this.getSeriesCount() || series < 0) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.getSeriesName(int): no such series.");
        }
        return this.seriesNames[series];
    }

    public void setSeriesNames(String[] seriesNames) {
        if (seriesNames == null) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setSeriesNames(): null not permitted.");
        }
        if (seriesNames.length != this.getSeriesCount()) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setSeriesNames(): the number of series names does not match the data.");
        }
        this.seriesNames = seriesNames;
        this.fireDatasetChanged();
    }

    public int getCategoryCount() {
        int result = 0;
        if (this.startData != null && this.getSeriesCount() > 0) {
            result = this.startData[0].length;
        }
        return result;
    }

    public List getCategories() {
        if (this.categories == null) {
            return new ArrayList();
        }
        return Collections.unmodifiableList(Arrays.asList(this.categories));
    }

    public void setCategories(Object[] categories) {
        if (categories == null) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setCategories(...): null not permitted.");
        }
        if (categories.length != this.startData[0].length) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setCategories(...): the number of categories does not match the data.");
        }
        int i = 0;
        while (i < categories.length) {
            if (categories[i] == null) {
                throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setCategories(...): null category not permitted.");
            }
            ++i;
        }
        this.categories = categories;
        this.fireDatasetChanged();
    }

    public Number getValue(int series, Object category) {
        return this.getEndValue(series, category);
    }

    public Number getStartValue(int series, Object category) {
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.getValue(...): series index out of range.");
        }
        if (category == null) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.getValue(...): null category not allowed.");
        }
        int categoryIndex = this.getCategoryIndex(category);
        if (categoryIndex < 0) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.getValue(...): unknown category.");
        }
        return this.startData[series][categoryIndex];
    }

    public Number getEndValue(int series, Object category) {
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.getValue(...): series index out of range.");
        }
        if (category == null) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.getValue(...): null category not allowed.");
        }
        int categoryIndex = this.getCategoryIndex(category);
        if (categoryIndex < 0) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.getValue(...): unknown category.");
        }
        return this.endData[series][categoryIndex];
    }

    public void setStartValue(int series, Object category, Number value) {
        if (series < 0 || series > this.getSeriesCount()) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setValue: series outside valid range.");
        }
        int categoryIndex = this.getCategoryIndex(category);
        if (categoryIndex < 0) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setValue: unrecognised category.");
        }
        this.startData[series][categoryIndex] = value;
        this.fireDatasetChanged();
    }

    public void setEndValue(int series, Object category, Number value) {
        if (series < 0 || series > this.getSeriesCount()) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setValue: series outside valid range.");
        }
        int categoryIndex = this.getCategoryIndex(category);
        if (categoryIndex < 0) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setValue: unrecognised category.");
        }
        this.endData[series][categoryIndex] = value;
        this.fireDatasetChanged();
    }

    private int getCategoryIndex(Object category) {
        int result = -1;
        int i = 0;
        while (i < this.categories.length) {
            if (category.equals(this.categories[i])) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    private String[] generateNames(int count, String prefix) {
        String[] result = new String[count];
        int i = 0;
        while (i < count) {
            String name;
            result[i] = name = prefix + (i + 1);
            ++i;
        }
        return result;
    }
}

