/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.TimePeriod;
import com.jrefinery.date.SerialDate;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class Day
extends TimePeriod {
    protected static final DateFormat standardDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected static final DateFormat dateFormatShort = DateFormat.getDateInstance(3);
    protected static final DateFormat dateFormatMedium = DateFormat.getDateInstance(2);
    protected static final DateFormat dateFormatLong = DateFormat.getDateInstance(1);
    protected SerialDate serialDate;

    public Day() {
        this(new Date());
    }

    public Day(int day, int month, int year) {
        this.serialDate = SerialDate.createInstance(day, month, year);
    }

    public Day(SerialDate serialDate) {
        this.serialDate = serialDate;
    }

    public Day(Date time) {
        this(time, TimePeriod.DEFAULT_TIME_ZONE);
    }

    public Day(Date time, TimeZone zone) {
        Calendar calendar = Calendar.getInstance(zone);
        calendar.setTime(time);
        int d = calendar.get(5);
        int m = calendar.get(2) + 1;
        int y = calendar.get(1);
        this.serialDate = SerialDate.createInstance(d, m, y);
    }

    public SerialDate getSerialDate() {
        return this.serialDate;
    }

    public int getYear() {
        return this.serialDate.getYYYY();
    }

    public int getMonth() {
        return this.serialDate.getMonth();
    }

    public int getDayOfMonth() {
        return this.serialDate.getDayOfMonth();
    }

    public boolean equals(Object object) {
        if (object != null) {
            if (object instanceof Day) {
                Day d = (Day)object;
                return this.serialDate.equals(d.getSerialDate());
            }
            return this.serialDate.equals(object);
        }
        return false;
    }

    public TimePeriod previous() {
        int serial = this.serialDate.toSerial();
        if (serial > SerialDate.SERIAL_LOWER_BOUND) {
            SerialDate yesterday = SerialDate.createInstance(serial - 1);
            return new Day(yesterday);
        }
        TimePeriod result = null;
        return result;
    }

    public TimePeriod next() {
        int serial = this.serialDate.toSerial();
        if (serial < SerialDate.SERIAL_UPPER_BOUND) {
            SerialDate tomorrow = SerialDate.createInstance(serial + 1);
            return new Day(tomorrow);
        }
        TimePeriod result = null;
        return result;
    }

    public int compareTo(Object o1) {
        int result;
        if (o1 instanceof Day) {
            Day d = (Day)o1;
            result = -d.getSerialDate().compare(this.serialDate);
        } else {
            result = o1 instanceof TimePeriod ? 0 : 1;
        }
        return result;
    }

    public String toString() {
        return this.serialDate.toString();
    }

    public static Day parseDay(String s) {
        Day result = null;
        Date date = null;
        try {
            date = standardDateFormat.parse(s);
        }
        catch (ParseException e1) {
            try {
                date = dateFormatShort.parse(s);
            }
            catch (ParseException e2) {
                // empty catch block
            }
        }
        if (date != null) {
            result = new Day(date);
        }
        return result;
    }

    public long getStart(Calendar calendar) {
        int year = this.serialDate.getYYYY();
        int month = this.serialDate.getMonth();
        int day = this.serialDate.getDayOfMonth();
        calendar.clear();
        calendar.set(year, month - 1, day, 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    public long getEnd(Calendar calendar) {
        int year = this.serialDate.getYYYY();
        int month = this.serialDate.getMonth();
        int day = this.serialDate.getDayOfMonth();
        calendar.clear();
        calendar.set(year, month - 1, day, 23, 59, 59);
        calendar.set(14, 999);
        return calendar.getTime().getTime();
    }

    public static void main(String[] args) {
        Day day = new Day();
        System.out.println(day.equals(day));
    }
}

