/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.Dataset;
import com.jrefinery.data.DefaultPieDataset;
import com.jrefinery.data.DomainInfo;
import com.jrefinery.data.HighLowDataset;
import com.jrefinery.data.IntervalCategoryDataset;
import com.jrefinery.data.IntervalXYDataset;
import com.jrefinery.data.PieDataset;
import com.jrefinery.data.Range;
import com.jrefinery.data.RangeInfo;
import com.jrefinery.data.XYDataset;
import java.util.Iterator;
import java.util.List;

public class DatasetUtilities {
    public static Number[] createNumberArray(double[] data) {
        Number[] result = new Number[data.length];
        int i = 0;
        while (i < data.length) {
            result[i] = new Double(data[i]);
            ++i;
        }
        return result;
    }

    public static Number[][] createNumberArray2D(double[][] data) {
        int l1 = data.length;
        int l2 = data[0].length;
        Number[][] result = new Number[l1][l2];
        int i = 0;
        while (i < l1) {
            result[i] = DatasetUtilities.createNumberArray(data[i]);
            ++i;
        }
        return result;
    }

    public static Range getDomainExtent(Dataset data) {
        if (data == null) {
            throw new IllegalArgumentException("Datasets.getMinimumDomainValue: null dataset not allowed.");
        }
        if (data instanceof CategoryDataset && !(data instanceof XYDataset)) {
            throw new IllegalArgumentException("Datasets.getMinimumDomainValue(...): CategoryDataset does not have numerical domain.");
        }
        if (data instanceof DomainInfo) {
            DomainInfo info = (DomainInfo)((Object)data);
            return info.getValueRange();
        }
        if (data instanceof XYDataset) {
            double minimum = Double.POSITIVE_INFINITY;
            double maximum = Double.NEGATIVE_INFINITY;
            XYDataset xyData = (XYDataset)data;
            int seriesCount = xyData.getSeriesCount();
            int series = 0;
            while (series < seriesCount) {
                int itemCount = xyData.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    Number lvalue = null;
                    Number uvalue = null;
                    if (data instanceof IntervalXYDataset) {
                        IntervalXYDataset intervalXYData = (IntervalXYDataset)data;
                        lvalue = intervalXYData.getStartXValue(series, item);
                        uvalue = intervalXYData.getEndXValue(series, item);
                    } else {
                        uvalue = lvalue = xyData.getXValue(series, item);
                    }
                    if (lvalue != null) {
                        minimum = Math.min(minimum, lvalue.doubleValue());
                    }
                    if (uvalue != null) {
                        maximum = Math.max(maximum, uvalue.doubleValue());
                    }
                    ++item;
                }
                ++series;
            }
            if (minimum == Double.POSITIVE_INFINITY) {
                return null;
            }
            return new Range(minimum, maximum);
        }
        return null;
    }

    public static Range getRangeExtent(Dataset data) {
        if (data == null) {
            throw new IllegalArgumentException("Datasets.getMinimumRangeValue: null dataset not allowed.");
        }
        if (data instanceof RangeInfo) {
            RangeInfo info = (RangeInfo)((Object)data);
            return info.getValueRange();
        }
        if (data instanceof CategoryDataset) {
            CategoryDataset categoryData = (CategoryDataset)data;
            double minimum = Double.POSITIVE_INFINITY;
            double maximum = Double.NEGATIVE_INFINITY;
            int seriesCount = categoryData.getSeriesCount();
            int series = 0;
            while (series < seriesCount) {
                Iterator iterator = categoryData.getCategories().iterator();
                while (iterator.hasNext()) {
                    Object category = iterator.next();
                    Number lvalue = null;
                    Number uvalue = null;
                    if (data instanceof IntervalCategoryDataset) {
                        IntervalCategoryDataset icd = (IntervalCategoryDataset)data;
                        lvalue = icd.getStartValue(series, category);
                        uvalue = icd.getEndValue(series, category);
                    } else {
                        uvalue = lvalue = categoryData.getValue(series, category);
                    }
                    if (lvalue != null) {
                        minimum = Math.min(minimum, lvalue.doubleValue());
                    }
                    if (uvalue == null) continue;
                    maximum = Math.max(maximum, uvalue.doubleValue());
                }
                ++series;
            }
            if (minimum == Double.POSITIVE_INFINITY) {
                return null;
            }
            return new Range(minimum, maximum);
        }
        if (data instanceof XYDataset) {
            XYDataset xyData = (XYDataset)data;
            double minimum = Double.POSITIVE_INFINITY;
            double maximum = Double.NEGATIVE_INFINITY;
            int seriesCount = xyData.getSeriesCount();
            int series = 0;
            while (series < seriesCount) {
                int itemCount = xyData.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    Number lvalue = null;
                    Number uvalue = null;
                    if (data instanceof IntervalXYDataset) {
                        IntervalXYDataset intervalXYData = (IntervalXYDataset)data;
                        lvalue = intervalXYData.getStartYValue(series, item);
                        uvalue = intervalXYData.getEndYValue(series, item);
                    } else if (data instanceof HighLowDataset) {
                        HighLowDataset highLowData = (HighLowDataset)data;
                        lvalue = highLowData.getLowValue(series, item);
                        uvalue = highLowData.getHighValue(series, item);
                    } else {
                        uvalue = lvalue = xyData.getYValue(series, item);
                    }
                    if (lvalue != null) {
                        minimum = Math.min(minimum, lvalue.doubleValue());
                    }
                    if (uvalue != null) {
                        maximum = Math.max(maximum, uvalue.doubleValue());
                    }
                    ++item;
                }
                ++series;
            }
            if (minimum == Double.POSITIVE_INFINITY) {
                return null;
            }
            return new Range(minimum, maximum);
        }
        return null;
    }

    public static Number getMinimumDomainValue(Dataset data) {
        if (data == null) {
            throw new IllegalArgumentException("Datasets.getMinimumDomainValue: null dataset not allowed.");
        }
        if (data instanceof CategoryDataset && !(data instanceof XYDataset)) {
            throw new IllegalArgumentException("Datasets.getMinimumDomainValue(...): CategoryDataset does not have numerical domain.");
        }
        if (data instanceof DomainInfo) {
            DomainInfo info = (DomainInfo)((Object)data);
            return info.getMinimumDomainValue();
        }
        if (data instanceof XYDataset) {
            double minimum = Double.POSITIVE_INFINITY;
            XYDataset xyData = (XYDataset)data;
            int seriesCount = xyData.getSeriesCount();
            int series = 0;
            while (series < seriesCount) {
                int itemCount = xyData.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    Number value = null;
                    if (data instanceof IntervalXYDataset) {
                        IntervalXYDataset intervalXYData = (IntervalXYDataset)data;
                        value = intervalXYData.getStartXValue(series, item);
                    } else {
                        value = xyData.getXValue(series, item);
                    }
                    if (value != null) {
                        minimum = Math.min(minimum, value.doubleValue());
                    }
                    ++item;
                }
                ++series;
            }
            if (minimum == Double.POSITIVE_INFINITY) {
                return null;
            }
            return new Double(minimum);
        }
        return null;
    }

    public static Number getMaximumDomainValue(Dataset data) {
        if (data == null) {
            throw new IllegalArgumentException("Datasets.getMaximumDomainValue: null dataset not allowed.");
        }
        if (data instanceof CategoryDataset && !(data instanceof XYDataset)) {
            throw new IllegalArgumentException("Datasets.getMaximumDomainValue(...): CategoryDataset does not have numerical domain.");
        }
        if (data instanceof DomainInfo) {
            DomainInfo info = (DomainInfo)((Object)data);
            return info.getMaximumDomainValue();
        }
        if (data instanceof XYDataset) {
            XYDataset xyData = (XYDataset)data;
            double maximum = Double.NEGATIVE_INFINITY;
            int seriesCount = xyData.getSeriesCount();
            int series = 0;
            while (series < seriesCount) {
                int itemCount = xyData.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    Number value = null;
                    if (data instanceof IntervalXYDataset) {
                        IntervalXYDataset intervalXYData = (IntervalXYDataset)data;
                        value = intervalXYData.getEndXValue(series, item);
                    } else {
                        value = xyData.getXValue(series, item);
                    }
                    if (value != null) {
                        maximum = Math.max(maximum, value.doubleValue());
                    }
                    ++item;
                }
                ++series;
            }
            if (maximum == Double.NEGATIVE_INFINITY) {
                return null;
            }
            return new Double(maximum);
        }
        return null;
    }

    public static Number getMinimumRangeValue(Dataset data) {
        if (data == null) {
            throw new IllegalArgumentException("Datasets.getMinimumRangeValue: null dataset not allowed.");
        }
        if (data instanceof RangeInfo) {
            RangeInfo info = (RangeInfo)((Object)data);
            return info.getMinimumRangeValue();
        }
        if (data instanceof CategoryDataset) {
            CategoryDataset categoryData = (CategoryDataset)data;
            double minimum = Double.POSITIVE_INFINITY;
            int seriesCount = categoryData.getSeriesCount();
            int series = 0;
            while (series < seriesCount) {
                Iterator iterator = categoryData.getCategories().iterator();
                while (iterator.hasNext()) {
                    Object category = iterator.next();
                    Number value = null;
                    if (data instanceof IntervalCategoryDataset) {
                        IntervalCategoryDataset icd = (IntervalCategoryDataset)data;
                        value = icd.getStartValue(series, category);
                    } else {
                        value = categoryData.getValue(series, category);
                    }
                    if (value == null) continue;
                    minimum = Math.min(minimum, value.doubleValue());
                }
                ++series;
            }
            if (minimum == Double.POSITIVE_INFINITY) {
                return null;
            }
            return new Double(minimum);
        }
        if (data instanceof XYDataset) {
            XYDataset xyData = (XYDataset)data;
            double minimum = Double.POSITIVE_INFINITY;
            int seriesCount = xyData.getSeriesCount();
            int series = 0;
            while (series < seriesCount) {
                int itemCount = xyData.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    Number value = null;
                    if (data instanceof IntervalXYDataset) {
                        IntervalXYDataset intervalXYData = (IntervalXYDataset)data;
                        value = intervalXYData.getStartYValue(series, item);
                    } else if (data instanceof HighLowDataset) {
                        HighLowDataset highLowData = (HighLowDataset)data;
                        value = highLowData.getLowValue(series, item);
                    } else {
                        value = xyData.getYValue(series, item);
                    }
                    if (value != null) {
                        minimum = Math.min(minimum, value.doubleValue());
                    }
                    ++item;
                }
                ++series;
            }
            if (minimum == Double.POSITIVE_INFINITY) {
                return null;
            }
            return new Double(minimum);
        }
        return null;
    }

    public static Number getMaximumRangeValue(Dataset data) {
        if (data == null) {
            throw new IllegalArgumentException("Datasets.getMinimumRangeValue: null dataset not allowed.");
        }
        if (data instanceof RangeInfo) {
            RangeInfo info = (RangeInfo)((Object)data);
            return info.getMaximumRangeValue();
        }
        if (data instanceof CategoryDataset) {
            CategoryDataset categoryData = (CategoryDataset)data;
            double maximum = Double.NEGATIVE_INFINITY;
            int seriesCount = categoryData.getSeriesCount();
            int series = 0;
            while (series < seriesCount) {
                Iterator iterator = categoryData.getCategories().iterator();
                while (iterator.hasNext()) {
                    Object category = iterator.next();
                    Number value = null;
                    if (data instanceof IntervalCategoryDataset) {
                        IntervalCategoryDataset icd = (IntervalCategoryDataset)data;
                        value = icd.getEndValue(series, category);
                    } else {
                        value = categoryData.getValue(series, category);
                    }
                    if (value == null) continue;
                    maximum = Math.max(maximum, value.doubleValue());
                }
                ++series;
            }
            if (maximum == Double.NEGATIVE_INFINITY) {
                return null;
            }
            return new Double(maximum);
        }
        if (data instanceof XYDataset) {
            XYDataset xyData = (XYDataset)data;
            double maximum = Double.NEGATIVE_INFINITY;
            int seriesCount = xyData.getSeriesCount();
            int series = 0;
            while (series < seriesCount) {
                int itemCount = xyData.getItemCount(series);
                int item = 0;
                while (item < itemCount) {
                    Number value = null;
                    if (data instanceof IntervalXYDataset) {
                        IntervalXYDataset intervalXYData = (IntervalXYDataset)data;
                        value = intervalXYData.getEndYValue(series, item);
                    } else if (data instanceof HighLowDataset) {
                        HighLowDataset highLowData = (HighLowDataset)data;
                        value = highLowData.getHighValue(series, item);
                    } else {
                        value = xyData.getYValue(series, item);
                    }
                    if (value != null) {
                        maximum = Math.max(maximum, value.doubleValue());
                    }
                    ++item;
                }
                ++series;
            }
            if (maximum == Double.NEGATIVE_INFINITY) {
                return null;
            }
            return new Double(maximum);
        }
        return null;
    }

    public static PieDataset createPieDataset(CategoryDataset data, Object category) {
        DefaultPieDataset result = new DefaultPieDataset();
        int seriesCount = data.getSeriesCount();
        int i = 0;
        while (i < seriesCount) {
            String seriesName = data.getSeriesName(i);
            result.setValue(seriesName, data.getValue(i, category));
            ++i;
        }
        return result;
    }

    public static PieDataset createPieDataset(CategoryDataset data, int series) {
        DefaultPieDataset result = new DefaultPieDataset();
        List categories = data.getCategories();
        Iterator iterator = categories.iterator();
        while (iterator.hasNext()) {
            Object current = iterator.next();
            result.setValue(current, data.getValue(series, current));
        }
        return result;
    }

    public static Range getStackedRangeExtent(CategoryDataset data) {
        Range result = null;
        if (data != null) {
            double minimum = 0.0;
            double maximum = 0.0;
            Iterator iterator = data.getCategories().iterator();
            while (iterator.hasNext()) {
                Object category = iterator.next();
                double positive = 0.0;
                double negative = 0.0;
                int seriesCount = data.getSeriesCount();
                int series = 0;
                while (series < seriesCount) {
                    Number number = data.getValue(series, category);
                    if (number != null) {
                        double value = number.doubleValue();
                        if (value > 0.0) {
                            positive += value;
                        }
                        if (value < 0.0) {
                            negative += value;
                        }
                    }
                    ++series;
                }
                minimum = Math.min(minimum, negative);
                maximum = Math.max(maximum, positive);
            }
            result = new Range(minimum, maximum);
        }
        return result;
    }

    public static Number getMinimumStackedRangeValue(CategoryDataset data) {
        Double result = null;
        if (data != null) {
            double minimum = 0.0;
            Iterator iterator = data.getCategories().iterator();
            while (iterator.hasNext()) {
                Object category = iterator.next();
                double total = 0.0;
                int seriesCount = data.getSeriesCount();
                int series = 0;
                while (series < seriesCount) {
                    double value;
                    Number number = data.getValue(series, category);
                    if (number != null && (value = number.doubleValue()) < 0.0) {
                        total += value;
                    }
                    ++series;
                }
                minimum = Math.min(minimum, total);
            }
            result = new Double(minimum);
        }
        return result;
    }

    public static Number getMaximumStackedRangeValue(CategoryDataset data) {
        Double result = null;
        if (data != null) {
            double maximum = 0.0;
            Iterator iterator = data.getCategories().iterator();
            while (iterator.hasNext()) {
                Object category = iterator.next();
                double total = 0.0;
                int seriesCount = data.getSeriesCount();
                int series = 0;
                while (series < seriesCount) {
                    double value;
                    Number number = data.getValue(series, category);
                    if (number != null && (value = number.doubleValue()) > 0.0) {
                        total += value;
                    }
                    ++series;
                }
                maximum = Math.max(maximum, total);
            }
            result = new Double(maximum);
        }
        return result;
    }
}

