/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.Day;
import com.jrefinery.data.Series;
import com.jrefinery.data.SeriesException;
import com.jrefinery.data.TimePeriod;
import com.jrefinery.data.TimeSeriesDataPair;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class BasicTimeSeries
extends Series {
    protected static final String DEFAULT_DOMAIN_DESCRIPTION = "Time";
    protected static final String DEFAULT_RANGE_DESCRIPTION = "Value";
    protected String domain;
    protected String range;
    protected Class timePeriodClass;
    protected List data;
    static /* synthetic */ Class class$com$jrefinery$data$Day;
    static /* synthetic */ Class class$com$jrefinery$data$Minute;

    public BasicTimeSeries(String name) {
        this(name, DEFAULT_DOMAIN_DESCRIPTION, DEFAULT_RANGE_DESCRIPTION, class$com$jrefinery$data$Day == null ? (class$com$jrefinery$data$Day = BasicTimeSeries.class$("com.jrefinery.data.Day")) : class$com$jrefinery$data$Day);
    }

    public BasicTimeSeries(String name, Class timePeriodClass) {
        this(name, DEFAULT_DOMAIN_DESCRIPTION, DEFAULT_RANGE_DESCRIPTION, timePeriodClass);
    }

    public BasicTimeSeries(String name, String domain, String range, Class timePeriodClass) {
        super(name);
        this.domain = domain;
        this.range = range;
        this.timePeriodClass = timePeriodClass;
        this.data = new ArrayList();
    }

    public String getDomainDescription() {
        return this.domain;
    }

    public void setDomainDescription(String description) {
        String old = this.domain;
        this.domain = description;
        this.propertyChangeSupport.firePropertyChange("Domain", old, description);
    }

    public String getRangeDescription() {
        return this.range;
    }

    public void setRangeDescription(String description) {
        String old = this.range;
        this.range = description;
        this.propertyChangeSupport.firePropertyChange("Range", old, description);
    }

    public int getItemCount() {
        return this.data.size();
    }

    public Class getTimePeriodClass() {
        return this.timePeriodClass;
    }

    public TimeSeriesDataPair getDataPair(int index) {
        return (TimeSeriesDataPair)this.data.get(index);
    }

    public TimeSeriesDataPair getDataPair(TimePeriod period) {
        if (period == null) {
            throw new IllegalArgumentException("TimeSeries.getDataPair(...): null time period not allowed.");
        }
        TimeSeriesDataPair dummy = new TimeSeriesDataPair(period, new Integer(0));
        int index = Collections.binarySearch(this.data, dummy);
        if (index >= 0) {
            return (TimeSeriesDataPair)this.data.get(index);
        }
        return null;
    }

    public TimePeriod getTimePeriod(int index) {
        return this.getDataPair(index).getPeriod();
    }

    public TimePeriod getNextTimePeriod() {
        TimePeriod last = this.getTimePeriod(this.getItemCount() - 1);
        return last.next();
    }

    public Collection getTimePeriods() {
        ArrayList<TimePeriod> result = new ArrayList<TimePeriod>();
        int i = 0;
        while (i < this.getItemCount()) {
            result.add(this.getTimePeriod(i));
            ++i;
        }
        return result;
    }

    public Collection getTimePeriodsUniqueToOtherSeries(BasicTimeSeries series) {
        ArrayList<TimePeriod> result = new ArrayList<TimePeriod>();
        int i = 0;
        while (i < series.getItemCount()) {
            TimePeriod period = series.getTimePeriod(i);
            int index = this.getIndex(period);
            if (index < 0) {
                result.add(period);
            }
            ++i;
        }
        return result;
    }

    public int getIndex(TimePeriod period) {
        if (period != null) {
            TimeSeriesDataPair dummy = new TimeSeriesDataPair(period, new Integer(0));
            int index = Collections.binarySearch(this.data, dummy);
            return index;
        }
        return -1;
    }

    public Number getValue(int index) {
        return this.getDataPair(index).getValue();
    }

    public Number getValue(TimePeriod period) {
        int index = this.getIndex(period);
        if (index >= 0) {
            return this.getValue(index);
        }
        return null;
    }

    public void add(TimeSeriesDataPair pair) throws SeriesException {
        if (pair == null) {
            throw new IllegalArgumentException("TimeSeries.add(...): null item not allowed.");
        }
        if (!pair.getPeriod().getClass().equals(this.timePeriodClass)) {
            String message = "BasicTimeSeries.add(...): you are trying to add data where the time ";
            message = message + "period class is " + pair.getPeriod().getClass().getName() + ", ";
            message = message + "but the BasicTimeSeries is expecting an instance of " + this.timePeriodClass.getName() + ".";
            throw new SeriesException(message);
        }
        int index = Collections.binarySearch(this.data, pair);
        if (index >= 0) {
            throw new SeriesException("TimeSeries.add(...): time period already exists.");
        }
        this.data.add(-index - 1, pair);
        this.fireSeriesChanged();
    }

    public void add(TimePeriod period, double value) throws SeriesException {
        TimeSeriesDataPair pair = new TimeSeriesDataPair(period, value);
        this.add(pair);
    }

    public void add(TimePeriod period, Number value) throws SeriesException {
        TimeSeriesDataPair pair = new TimeSeriesDataPair(period, value);
        this.add(pair);
    }

    public void update(TimePeriod period, Number value) throws SeriesException {
        TimeSeriesDataPair temp = new TimeSeriesDataPair(period, value);
        int index = Collections.binarySearch(this.data, temp);
        if (index < 0) {
            throw new SeriesException("TimeSeries.update(TimePeriod, Number): period does not exist.");
        }
        TimeSeriesDataPair pair = (TimeSeriesDataPair)this.data.get(index);
        pair.setValue(value);
        this.fireSeriesChanged();
    }

    public void update(int index, Number value) {
        TimeSeriesDataPair pair = this.getDataPair(index);
        pair.setValue(value);
        this.fireSeriesChanged();
    }

    public BasicTimeSeries addAndOrUpdate(BasicTimeSeries series) {
        BasicTimeSeries overwritten = new BasicTimeSeries("Overwritten values from: " + this.getName());
        int i = 0;
        while (i < series.getItemCount()) {
            TimeSeriesDataPair pair = series.getDataPair(i);
            TimeSeriesDataPair oldPair = this.addOrUpdate(pair.getPeriod(), pair.getValue());
            if (oldPair != null) {
                try {
                    overwritten.add(oldPair);
                }
                catch (SeriesException e) {
                    System.err.println("TimeSeries.addAndOrUpdate(series): unable to add data to overwritten series.");
                }
            }
            ++i;
        }
        return overwritten;
    }

    public TimeSeriesDataPair addOrUpdate(TimePeriod period, Number value) {
        TimeSeriesDataPair overwritten = null;
        TimeSeriesDataPair key = new TimeSeriesDataPair(period, value);
        int index = Collections.binarySearch(this.data, key);
        if (index >= 0) {
            TimeSeriesDataPair existing = (TimeSeriesDataPair)this.data.get(index);
            overwritten = (TimeSeriesDataPair)existing.clone();
            existing.setValue(value);
            this.fireSeriesChanged();
        } else {
            this.data.add(-index - 1, new TimeSeriesDataPair(period, value));
        }
        return overwritten;
    }

    public void delete(TimePeriod period) {
        int index = this.getIndex(period);
        this.data.remove(index);
    }

    public BasicTimeSeries delete(int start, int end) {
        BasicTimeSeries removed = this.createCopy(start, end);
        int i = 0;
        while (i < removed.getItemCount()) {
            TimePeriod period = removed.getTimePeriod(i);
            this.delete(period);
            ++i;
        }
        this.fireSeriesChanged();
        return removed;
    }

    public Object clone() {
        BasicTimeSeries clone = this.createCopy(0, this.getItemCount() - 1);
        return clone;
    }

    public BasicTimeSeries createCopy(int start, int end) {
        BasicTimeSeries copy = (BasicTimeSeries)super.clone();
        copy.listeners = new ArrayList();
        copy.propertyChangeSupport = new PropertyChangeSupport(copy);
        copy.data = new ArrayList();
        if (this.data.size() > 0) {
            int index = start;
            while (index <= end) {
                TimeSeriesDataPair pair = (TimeSeriesDataPair)this.data.get(index);
                TimeSeriesDataPair clone = (TimeSeriesDataPair)pair.clone();
                try {
                    copy.add(clone);
                }
                catch (SeriesException e) {
                    System.err.println("TimeSeries.createCopy(): unable to add cloned data pair.");
                }
                ++index;
            }
        }
        return copy;
    }

    public BasicTimeSeries createCopy(TimePeriod start, TimePeriod end) {
        int startIndex = this.getIndex(start);
        int endIndex = this.getIndex(end);
        BasicTimeSeries copy = this.createCopy(startIndex, endIndex);
        return copy;
    }

    public static void main(String[] args) {
        BasicTimeSeries series = new BasicTimeSeries("Test", class$com$jrefinery$data$Minute == null ? (class$com$jrefinery$data$Minute = BasicTimeSeries.class$("com.jrefinery.data.Minute")) : class$com$jrefinery$data$Minute);
        series.add((TimePeriod)new Day(1, 1, 2002), 5.65);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DEFAULT_DOMAIN_DESCRIPTION = DEFAULT_DOMAIN_DESCRIPTION;
        DEFAULT_RANGE_DESCRIPTION = DEFAULT_RANGE_DESCRIPTION;
    }
}

