/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.ui;

import com.jrefinery.chart.AbstractTitle;
import com.jrefinery.layout.LCBLayout;
import com.jrefinery.ui.FontChooserPanel;
import com.jrefinery.ui.FontDisplayField;
import com.jrefinery.ui.PaintSample;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TitlePropertyEditPanel
extends JPanel
implements ActionListener {
    private JTextField titleField;
    private Font titleFont;
    private JTextField fontfield;
    private PaintSample titlePaint;

    public TitlePropertyEditPanel(AbstractTitle title) {
        this.setLayout(new BorderLayout());
        JPanel general = new JPanel(new BorderLayout());
        general.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "General:"));
        JPanel interior = new JPanel(new LCBLayout(3));
        interior.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        JLabel titleLabel = new JLabel("Text:");
        interior.add(titleLabel);
        interior.add(this.titleField);
        interior.add(new JPanel());
        interior.add(new JLabel("Font:"));
        this.fontfield = new FontDisplayField(this.titleFont);
        JButton b = new JButton("Select...");
        b.setActionCommand("SelectFont");
        b.addActionListener(this);
        interior.add(this.fontfield);
        interior.add(b);
        interior.add(new JLabel("Color:"));
        b = new JButton("Select...");
        b.setActionCommand("SelectPaint");
        b.addActionListener(this);
        interior.add(this.titlePaint);
        interior.add(b);
        general.add(interior);
        this.add((Component)general, "North");
    }

    public String getTitle() {
        return this.titleField.getText();
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public Paint getTitlePaint() {
        return this.titlePaint.getPaint();
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("SelectFont")) {
            this.attemptFontSelection();
        } else if (command.equals("SelectPaint")) {
            this.attemptPaintSelection();
        }
    }

    public void attemptFontSelection() {
        FontChooserPanel panel = new FontChooserPanel(this.titleFont);
        int result = JOptionPane.showConfirmDialog(this, panel, "Font Selection", 2, -1);
        if (result == 0) {
            this.titleFont = panel.getSelectedFont();
            this.fontfield.setText(this.titleFont.getFontName() + " " + this.titleFont.getSize());
        }
    }

    public void attemptPaintSelection() {
        Color c = JColorChooser.showDialog(this, "Title Color", Color.blue);
        if (c != null) {
            this.titlePaint.setPaint(c);
        }
    }

    public void setTitleProperties(AbstractTitle title) {
        if (title instanceof AbstractTitle) {
            // empty if block
        }
    }
}

