/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.ui;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.ui.AxisPropertyEditPanel;
import com.jrefinery.layout.LCBLayout;
import com.jrefinery.ui.InsetsChooserPanel;
import com.jrefinery.ui.InsetsTextField;
import com.jrefinery.ui.PaintSample;
import com.jrefinery.ui.StrokeChooserPanel;
import com.jrefinery.ui.StrokeSample;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class PlotPropertyEditPanel
extends JPanel
implements ActionListener {
    private PaintSample backgroundPaintSample;
    private StrokeSample outlineStrokeSample;
    private PaintSample outlinePaintSample;
    private AxisPropertyEditPanel domainAxisPropertyPanel;
    private AxisPropertyEditPanel rangeAxisPropertyPanel;
    private StrokeSample[] availableStrokeSamples;
    private Insets _insets;
    private InsetsTextField insetsTextField;

    public PlotPropertyEditPanel(Plot plot) {
        this._insets = plot.getInsets();
        this.backgroundPaintSample = new PaintSample(plot.getBackgroundPaint());
        this.outlineStrokeSample = new StrokeSample(plot.getOutlineStroke());
        this.outlinePaintSample = new PaintSample(plot.getOutlinePaint());
        this.setLayout(new BorderLayout());
        this.availableStrokeSamples = new StrokeSample[3];
        this.availableStrokeSamples[0] = new StrokeSample(new BasicStroke(1.0f));
        this.availableStrokeSamples[1] = new StrokeSample(new BasicStroke(2.0f));
        this.availableStrokeSamples[2] = new StrokeSample(new BasicStroke(3.0f));
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), plot.getPlotType() + ":"));
        JPanel general = new JPanel(new BorderLayout());
        general.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "General:"));
        JPanel interior = new JPanel(new LCBLayout(4));
        interior.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        interior.add(new JLabel("Insets:"));
        JButton button = new JButton("Edit...");
        button.setActionCommand("Insets");
        button.addActionListener(this);
        this.insetsTextField = new InsetsTextField(this._insets);
        this.insetsTextField.setEnabled(false);
        interior.add(this.insetsTextField);
        interior.add(button);
        interior.add(new JLabel("Outline stroke:"));
        button = new JButton("Select...");
        button.setActionCommand("OutlineStroke");
        button.addActionListener(this);
        interior.add(this.outlineStrokeSample);
        interior.add(button);
        interior.add(new JLabel("Outline paint:"));
        button = new JButton("Select...");
        button.setActionCommand("OutlinePaint");
        button.addActionListener(this);
        interior.add(this.outlinePaintSample);
        interior.add(button);
        interior.add(new JLabel("Background paint:"));
        button = new JButton("Select...");
        button.setActionCommand("BackgroundPaint");
        button.addActionListener(this);
        interior.add(this.backgroundPaintSample);
        interior.add(button);
        general.add((Component)interior, "North");
        JPanel appearance = new JPanel(new BorderLayout());
        appearance.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        appearance.add((Component)general, "North");
        JTabbedPane tabs = new JTabbedPane();
        tabs.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        Axis domainAxis = null;
        if (plot instanceof CategoryPlot) {
            domainAxis = ((CategoryPlot)plot).getDomainAxis();
        } else if (plot instanceof XYPlot) {
            domainAxis = ((XYPlot)plot).getDomainAxis();
        }
        this.domainAxisPropertyPanel = AxisPropertyEditPanel.getInstance(domainAxis);
        if (this.domainAxisPropertyPanel != null) {
            this.domainAxisPropertyPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            tabs.add("Domain Axis", this.domainAxisPropertyPanel);
        }
        ValueAxis rangeAxis = null;
        if (plot instanceof CategoryPlot) {
            rangeAxis = ((CategoryPlot)plot).getRangeAxis();
        } else if (plot instanceof XYPlot) {
            rangeAxis = ((XYPlot)plot).getRangeAxis();
        }
        this.rangeAxisPropertyPanel = AxisPropertyEditPanel.getInstance(rangeAxis);
        if (this.rangeAxisPropertyPanel != null) {
            this.rangeAxisPropertyPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            tabs.add("Range Axis", this.rangeAxisPropertyPanel);
        }
        tabs.add("Appearance", appearance);
        panel.add(tabs);
        this.add(panel);
    }

    public Insets getPlotInsets() {
        if (this._insets == null) {
            this._insets = new Insets(0, 0, 0, 0);
        }
        return this._insets;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaintSample.getPaint();
    }

    public Stroke getOutlineStroke() {
        return this.outlineStrokeSample.getStroke();
    }

    public Paint getOutlinePaint() {
        return this.outlinePaintSample.getPaint();
    }

    public AxisPropertyEditPanel getDomainAxisPropertyEditPanel() {
        return this.domainAxisPropertyPanel;
    }

    public AxisPropertyEditPanel getRangeAxisPropertyEditPanel() {
        return this.rangeAxisPropertyPanel;
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("BackgroundPaint")) {
            this.attemptBackgroundPaintSelection();
        } else if (command.equals("OutlineStroke")) {
            this.attemptOutlineStrokeSelection();
        } else if (command.equals("OutlinePaint")) {
            this.attemptOutlinePaintSelection();
        } else if (command.equals("Insets")) {
            this.editInsets();
        }
    }

    private void attemptBackgroundPaintSelection() {
        Color c = JColorChooser.showDialog(this, "Background Color", Color.blue);
        if (c != null) {
            this.backgroundPaintSample.setPaint(c);
        }
    }

    private void attemptOutlineStrokeSelection() {
        StrokeChooserPanel panel = new StrokeChooserPanel(null, this.availableStrokeSamples);
        int result = JOptionPane.showConfirmDialog(this, panel, "Stroke Selection", 2, -1);
        if (result == 0) {
            this.outlineStrokeSample.setStroke(panel.getSelectedStroke());
        }
    }

    private void attemptOutlinePaintSelection() {
        Color c = JColorChooser.showDialog(this, "Outline Color", Color.blue);
        if (c != null) {
            this.outlinePaintSample.setPaint(c);
        }
    }

    private void editInsets() {
        InsetsChooserPanel panel = new InsetsChooserPanel(this._insets);
        int result = JOptionPane.showConfirmDialog(this, panel, "Edit Insets", 2, -1);
        if (result == 0) {
            this._insets = panel.getInsets();
            this.insetsTextField.setInsets(this._insets);
        }
    }

    public void updatePlotProperties(Plot plot) {
        Axis rangeAxis;
        Axis domainAxis;
        plot.setOutlinePaint(this.getOutlinePaint());
        plot.setOutlineStroke(this.getOutlineStroke());
        plot.setBackgroundPaint(this.getBackgroundPaint());
        plot.setInsets(this.getPlotInsets());
        if (this.domainAxisPropertyPanel != null && (domainAxis = null) != null) {
            this.domainAxisPropertyPanel.setAxisProperties(domainAxis);
        }
        if (this.rangeAxisPropertyPanel != null && (rangeAxis = null) != null) {
            this.rangeAxisPropertyPanel.setAxisProperties(rangeAxis);
        }
    }
}

