/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.ui;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.chart.ui.AxisPropertyEditPanel;
import com.jrefinery.layout.LCBLayout;
import com.jrefinery.ui.PaintSample;
import com.jrefinery.ui.StrokeChooserPanel;
import com.jrefinery.ui.StrokeSample;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

class NumberAxisPropertyEditPanel
extends AxisPropertyEditPanel
implements FocusListener {
    private boolean autoRange;
    private double minimumValue;
    private double maximumValue;
    private JCheckBox autoRangeCheckBox;
    private JTextField minimumRangeValue;
    private JTextField maximumRangeValue;
    private JCheckBox showGridLinesCheckBox;
    private PaintSample gridPaintSample;
    private StrokeSample gridStrokeSample;
    private StrokeSample[] availableStrokeSamples;

    public NumberAxisPropertyEditPanel(NumberAxis axis) {
        super(axis);
        this.autoRange = axis.isAutoRange();
        this.minimumValue = axis.getMinimumAxisValue();
        this.maximumValue = axis.getMaximumAxisValue();
        this.gridPaintSample = new PaintSample(axis.getGridPaint());
        this.gridStrokeSample = new StrokeSample(axis.getGridStroke());
        this.availableStrokeSamples = new StrokeSample[3];
        this.availableStrokeSamples[0] = new StrokeSample(new BasicStroke(1.0f));
        this.availableStrokeSamples[1] = new StrokeSample(new BasicStroke(2.0f));
        this.availableStrokeSamples[2] = new StrokeSample(new BasicStroke(3.0f));
        JTabbedPane other = this.getOtherTabs();
        JPanel range = new JPanel(new LCBLayout(3));
        range.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        range.add(new JPanel());
        this.autoRangeCheckBox = new JCheckBox("Auto-adjust range:", this.autoRange);
        this.autoRangeCheckBox.setActionCommand("AutoRangeOnOff");
        this.autoRangeCheckBox.addActionListener(this);
        range.add(this.autoRangeCheckBox);
        range.add(new JPanel());
        range.add(new JLabel("Minimum range value:"));
        this.minimumRangeValue = new JTextField(Double.toString(this.minimumValue));
        this.minimumRangeValue.setEnabled(!this.autoRange);
        this.minimumRangeValue.setActionCommand("MinimumRange");
        this.minimumRangeValue.addActionListener(this);
        this.minimumRangeValue.addFocusListener(this);
        range.add(this.minimumRangeValue);
        range.add(new JPanel());
        range.add(new JLabel("Maximum range value:"));
        this.maximumRangeValue = new JTextField(Double.toString(this.maximumValue));
        this.maximumRangeValue.setEnabled(!this.autoRange);
        this.maximumRangeValue.setActionCommand("MaximumRange");
        this.maximumRangeValue.addActionListener(this);
        this.maximumRangeValue.addFocusListener(this);
        range.add(this.maximumRangeValue);
        range.add(new JPanel());
        other.add("Range", range);
        JPanel grid = new JPanel(new LCBLayout(3));
        grid.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        grid.add(new JPanel());
        this.showGridLinesCheckBox = new JCheckBox("Show grid lines", axis.isGridLinesVisible());
        grid.add(this.showGridLinesCheckBox);
        grid.add(new JPanel());
        grid.add(new JLabel("Grid stroke:"));
        JButton button = new JButton("Set stroke...");
        button.setActionCommand("GridStroke");
        button.addActionListener(this);
        grid.add(this.gridStrokeSample);
        grid.add(button);
        grid.add(new JLabel("Grid paint:"));
        button = new JButton("Set paint...");
        button.setActionCommand("GridPaint");
        button.addActionListener(this);
        grid.add(this.gridPaintSample);
        grid.add(button);
        other.add("Grid", grid);
    }

    public boolean isAutoRange() {
        return this.autoRange;
    }

    public double getMinimumValue() {
        return this.minimumValue;
    }

    public double getMaximumValue() {
        return this.maximumValue;
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("GridStroke")) {
            this.attemptGridStrokeSelection();
        } else if (command.equals("GridPaint")) {
            this.attemptGridPaintSelection();
        } else if (command.equals("AutoRangeOnOff")) {
            this.toggleAutoRange();
        } else if (command.equals("MinimumRange")) {
            this.validateMinimum();
        } else if (command.equals("MaximumRange")) {
            this.validateMaximum();
        } else {
            super.actionPerformed(event);
        }
    }

    private void attemptGridStrokeSelection() {
        StrokeChooserPanel panel = new StrokeChooserPanel(null, this.availableStrokeSamples);
        int result = JOptionPane.showConfirmDialog(this, panel, "Stroke Selection", 2, -1);
        if (result == 0) {
            this.gridStrokeSample.setStroke(panel.getSelectedStroke());
        }
    }

    private void attemptGridPaintSelection() {
        Color c = JColorChooser.showDialog(this, "Grid Color", Color.blue);
        if (c != null) {
            this.gridPaintSample.setPaint(c);
        }
    }

    public void focusGained(FocusEvent event) {
    }

    public void focusLost(FocusEvent event) {
        if (event.getSource() == this.minimumRangeValue) {
            this.validateMinimum();
        } else if (event.getSource() == this.maximumRangeValue) {
            this.validateMaximum();
        }
    }

    public void toggleAutoRange() {
        this.autoRange = this.autoRangeCheckBox.isSelected();
        if (this.autoRange) {
            this.minimumRangeValue.setText(Double.toString(this.minimumValue));
            this.minimumRangeValue.setEnabled(false);
            this.maximumRangeValue.setText(Double.toString(this.maximumValue));
            this.maximumRangeValue.setEnabled(false);
        } else {
            this.minimumRangeValue.setEnabled(true);
            this.maximumRangeValue.setEnabled(true);
        }
    }

    public void validateMinimum() {
        double newMin;
        try {
            newMin = Double.parseDouble(this.minimumRangeValue.getText());
            if (newMin >= this.maximumValue) {
                newMin = this.minimumValue;
            }
        }
        catch (NumberFormatException e) {
            newMin = this.minimumValue;
        }
        this.minimumValue = newMin;
        this.minimumRangeValue.setText(Double.toString(this.minimumValue));
    }

    public void validateMaximum() {
        double newMax;
        try {
            newMax = Double.parseDouble(this.maximumRangeValue.getText());
            if (newMax <= this.minimumValue) {
                newMax = this.maximumValue;
            }
        }
        catch (NumberFormatException e) {
            newMax = this.maximumValue;
        }
        this.maximumValue = newMax;
        this.maximumRangeValue.setText(Double.toString(this.maximumValue));
    }

    public void setAxisProperties(Axis axis) {
        super.setAxisProperties(axis);
        NumberAxis numberAxis = (NumberAxis)axis;
        numberAxis.setAutoRange(this.autoRange);
        if (!this.autoRange) {
            numberAxis.setMinimumAxisValue(this.minimumValue);
            numberAxis.setMaximumAxisValue(this.maximumValue);
        }
        numberAxis.setGridLinesVisible(this.showGridLinesCheckBox.isSelected());
        numberAxis.setGridPaint(this.gridPaintSample.getPaint());
        numberAxis.setGridStroke(this.gridStrokeSample.getStroke());
    }
}

