/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.ui;

import com.jrefinery.chart.Legend;
import com.jrefinery.chart.StandardLegend;
import com.jrefinery.layout.LCBLayout;
import com.jrefinery.ui.FontChooserPanel;
import com.jrefinery.ui.FontDisplayField;
import com.jrefinery.ui.PaintSample;
import com.jrefinery.ui.StrokeChooserPanel;
import com.jrefinery.ui.StrokeSample;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

class LegendPropertyEditPanel
extends JPanel
implements ActionListener {
    private StrokeSample outlineStroke;
    private PaintSample outlinePaint;
    private PaintSample backgroundPaint;
    private Font seriesFont;
    private PaintSample seriesPaint;
    private StrokeSample[] availableStrokeSamples;

    public LegendPropertyEditPanel(Legend legend) {
        StandardLegend l = (StandardLegend)legend;
        this.outlineStroke = new StrokeSample(l.getOutlineStroke());
        this.outlinePaint = new PaintSample(l.getOutlinePaint());
        this.backgroundPaint = new PaintSample(l.getBackgroundPaint());
        this.seriesFont = l.getItemFont();
        this.seriesPaint = new PaintSample(l.getItemPaint());
        this.availableStrokeSamples = new StrokeSample[4];
        this.availableStrokeSamples[0] = new StrokeSample(new BasicStroke(1.0f));
        this.availableStrokeSamples[1] = new StrokeSample(new BasicStroke(2.0f));
        this.availableStrokeSamples[2] = new StrokeSample(new BasicStroke(3.0f));
        this.availableStrokeSamples[3] = new StrokeSample(new BasicStroke(4.0f));
        this.setLayout(new BorderLayout());
        JPanel general = new JPanel(new BorderLayout());
        general.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "General:"));
        JPanel interior = new JPanel(new LCBLayout(5));
        interior.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        interior.add(new JLabel("Outline:"));
        interior.add(this.outlineStroke);
        JButton button = new JButton("Select...");
        button.setActionCommand("OutlineStroke");
        button.addActionListener(this);
        interior.add(button);
        interior.add(new JLabel("Outline Paint:"));
        button = new JButton("Select...");
        button.setActionCommand("OutlinePaint");
        button.addActionListener(this);
        interior.add(this.outlinePaint);
        interior.add(button);
        interior.add(new JLabel("Background:"));
        button = new JButton("Select...");
        button.setActionCommand("BackgroundPaint");
        button.addActionListener(this);
        interior.add(this.backgroundPaint);
        interior.add(button);
        interior.add(new JLabel("Series label font:"));
        button = new JButton("Select...");
        button.setActionCommand("SeriesFont");
        button.addActionListener(this);
        interior.add(new FontDisplayField(this.seriesFont));
        interior.add(button);
        interior.add(new JLabel("Series label paint:"));
        button = new JButton("Select...");
        button.setActionCommand("SeriesPaint");
        button.addActionListener(this);
        interior.add(this.seriesPaint);
        interior.add(button);
        general.add(interior);
        this.add((Component)general, "North");
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke.getStroke();
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint.getPaint();
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint.getPaint();
    }

    public Font getSeriesFont() {
        return this.seriesFont;
    }

    public Paint getSeriesPaint() {
        return this.seriesPaint.getPaint();
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("OutlineStroke")) {
            this.attemptModifyOutlineStroke();
        } else if (command.equals("OutlinePaint")) {
            this.attemptModifyOutlinePaint();
        } else if (command.equals("BackgroundPaint")) {
            this.attemptModifyBackgroundPaint();
        } else if (command.equals("SeriesFont")) {
            this.attemptModifySeriesFont();
        } else if (command.equals("SeriesPaint")) {
            this.attemptModifySeriesPaint();
        }
    }

    private void attemptModifyOutlineStroke() {
        StrokeChooserPanel panel = new StrokeChooserPanel(this.outlineStroke, this.availableStrokeSamples);
        int result = JOptionPane.showConfirmDialog(this, panel, "Pen/Stroke Selection", 2, -1);
        if (result == 0) {
            this.outlineStroke.setStroke(panel.getSelectedStroke());
        }
    }

    private void attemptModifyOutlinePaint() {
        Color c = JColorChooser.showDialog(this, "Outline Color", Color.blue);
        if (c != null) {
            this.outlinePaint.setPaint(c);
        }
    }

    private void attemptModifyBackgroundPaint() {
        Color c = JColorChooser.showDialog(this, "Background Color", Color.blue);
        if (c != null) {
            this.backgroundPaint.setPaint(c);
        }
    }

    public void attemptModifySeriesFont() {
        FontChooserPanel panel = new FontChooserPanel(this.seriesFont);
        int result = JOptionPane.showConfirmDialog(this, panel, "Font Selection", 2, -1);
        if (result == 0) {
            this.seriesFont = panel.getSelectedFont();
        }
    }

    private void attemptModifySeriesPaint() {
        Color c = JColorChooser.showDialog(this, "Series Label Color", Color.blue);
        if (c != null) {
            this.seriesPaint.setPaint(c);
        }
    }

    public void setLegendProperties(Legend legend) {
        if (legend instanceof StandardLegend) {
            StandardLegend standard = (StandardLegend)legend;
            standard.setOutlineStroke(this.getOutlineStroke());
            standard.setOutlinePaint(this.getOutlinePaint());
            standard.setBackgroundPaint(this.getBackgroundPaint());
            standard.setItemFont(this.getSeriesFont());
            standard.setItemPaint(this.getSeriesPaint());
        }
    }
}

