/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.ui;

import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.Legend;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.ui.LegendPropertyEditPanel;
import com.jrefinery.chart.ui.PlotPropertyEditPanel;
import com.jrefinery.chart.ui.TitlePropertyEditPanel;
import com.jrefinery.layout.LCBLayout;
import com.jrefinery.ui.PaintSample;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class ChartPropertyEditPanel
extends JPanel
implements ActionListener {
    TitlePropertyEditPanel titlePropertiesPanel;
    LegendPropertyEditPanel legendPropertiesPanel;
    PlotPropertyEditPanel plotPropertiesPanel;
    JCheckBox antialias;
    PaintSample background;

    public ChartPropertyEditPanel(JFreeChart chart) {
        this.setLayout(new BorderLayout());
        JPanel other = new JPanel(new BorderLayout());
        other.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JPanel general = new JPanel(new BorderLayout());
        general.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "General:"));
        JPanel interior = new JPanel(new LCBLayout(6));
        interior.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.antialias = new JCheckBox("Draw anti-aliased");
        this.antialias.setSelected(chart.getAntiAlias());
        interior.add(this.antialias);
        interior.add(new JLabel(""));
        interior.add(new JLabel(""));
        interior.add(new JLabel("Background paint:"));
        this.background = new PaintSample(chart.getBackgroundPaint());
        interior.add(this.background);
        JButton button = new JButton("Select...");
        button.setActionCommand("BackgroundPaint");
        button.addActionListener(this);
        interior.add(button);
        interior.add(new JLabel("Series Paint:"));
        JTextField info = new JTextField("No editor implemented");
        info.setEnabled(false);
        interior.add(info);
        button = new JButton("Edit...");
        button.setEnabled(false);
        interior.add(button);
        interior.add(new JLabel("Series Stroke:"));
        info = new JTextField("No editor implemented");
        info.setEnabled(false);
        interior.add(info);
        button = new JButton("Edit...");
        button.setEnabled(false);
        interior.add(button);
        interior.add(new JLabel("Series Outline Paint:"));
        info = new JTextField("No editor implemented");
        info.setEnabled(false);
        interior.add(info);
        button = new JButton("Edit...");
        button.setEnabled(false);
        interior.add(button);
        interior.add(new JLabel("Series Outline Stroke:"));
        info = new JTextField("No editor implemented");
        info.setEnabled(false);
        interior.add(info);
        button = new JButton("Edit...");
        button.setEnabled(false);
        interior.add(button);
        general.add((Component)interior, "North");
        other.add((Component)general, "North");
        JPanel parts = new JPanel(new BorderLayout());
        Legend legend = chart.getLegend();
        Plot plot = chart.getPlot();
        JTabbedPane tabs = new JTabbedPane();
        if (legend != null) {
            this.legendPropertiesPanel = new LegendPropertyEditPanel(legend);
            this.legendPropertiesPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            tabs.addTab("Legend", this.legendPropertiesPanel);
        }
        this.plotPropertiesPanel = new PlotPropertyEditPanel(plot);
        this.plotPropertiesPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        tabs.addTab("Plot", this.plotPropertiesPanel);
        tabs.add("Other", other);
        parts.add((Component)tabs, "North");
        this.add(parts);
    }

    public TitlePropertyEditPanel getTitlePropertyEditPanel() {
        return this.titlePropertiesPanel;
    }

    public LegendPropertyEditPanel getLegendPropertyEditPanel() {
        return this.legendPropertiesPanel;
    }

    public PlotPropertyEditPanel getPlotPropertyEditPanel() {
        return this.plotPropertiesPanel;
    }

    public boolean getAntiAlias() {
        return this.antialias.isSelected();
    }

    public Paint getBackgroundPaint() {
        return this.background.getPaint();
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("BackgroundPaint")) {
            this.attemptModifyBackgroundPaint();
        }
    }

    private void attemptModifyBackgroundPaint() {
        Color c = JColorChooser.showDialog(this, "Background Color", Color.blue);
        if (c != null) {
            this.background.setPaint(c);
        }
    }

    public void updateChartProperties(JFreeChart chart) {
        if (this.legendPropertiesPanel != null) {
            this.legendPropertiesPanel.setLegendProperties(chart.getLegend());
        }
        this.plotPropertiesPanel.updatePlotProperties(chart.getPlot());
        chart.setAntiAlias(this.getAntiAlias());
        chart.setBackgroundPaint(this.getBackgroundPaint());
    }
}

