/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.tooltips;

import com.jrefinery.chart.tooltips.XYToolTipGenerator;
import com.jrefinery.data.XYDataset;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimeSeriesToolTipGenerator
implements XYToolTipGenerator {
    protected DateFormat domainFormat;
    protected NumberFormat rangeFormat;

    public TimeSeriesToolTipGenerator() {
        this(DateFormat.getInstance(), NumberFormat.getNumberInstance());
    }

    public TimeSeriesToolTipGenerator(String dateFormat, String valueFormat) {
        this(new SimpleDateFormat(dateFormat), new DecimalFormat(valueFormat));
    }

    public TimeSeriesToolTipGenerator(DateFormat domainFormat, NumberFormat rangeFormat) {
        this.domainFormat = domainFormat;
        this.rangeFormat = rangeFormat;
    }

    public String generateToolTip(XYDataset data, int series, int item) {
        String result = data.getSeriesName(series) + ": ";
        long x = data.getXValue(series, item).longValue();
        result = result + "date = " + this.domainFormat.format(new Date(x));
        Number y = data.getYValue(series, item);
        result = y != null ? result + ", value = " + this.rangeFormat.format(y) : result + ", value = null";
        return result;
    }
}

