/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.tooltips;

import com.jrefinery.chart.tooltips.XYToolTipGenerator;
import com.jrefinery.data.XYDataset;
import java.text.NumberFormat;

public class StandardXYToolTipGenerator
implements XYToolTipGenerator {
    protected NumberFormat xFormat;
    protected NumberFormat yFormat;

    public StandardXYToolTipGenerator() {
        this(NumberFormat.getNumberInstance(), NumberFormat.getNumberInstance());
    }

    public StandardXYToolTipGenerator(NumberFormat xFormat, NumberFormat yFormat) {
        this.xFormat = xFormat;
        this.yFormat = yFormat;
    }

    public String generateToolTip(XYDataset data, int series, int item) {
        String result = data.getSeriesName(series) + ": ";
        Number x = data.getXValue(series, item);
        result = result + "x: " + this.xFormat.format(x);
        Number y = data.getYValue(series, item);
        result = y != null ? result + ", y: " + this.yFormat.format(y) : result + ", y: null";
        return result;
    }
}

