/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.junit;

import com.jrefinery.chart.ChartFactory;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.event.ChartChangeEvent;
import com.jrefinery.chart.event.ChartChangeListener;
import com.jrefinery.data.DefaultCategoryDataset;
import com.jrefinery.data.Range;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class VerticalBarChartTests
extends TestCase {
    private JFreeChart verticalBarChart;
    static /* synthetic */ Class class$com$jrefinery$chart$junit$VerticalBarChartTests;

    public static Test suite() {
        return new TestSuite(class$com$jrefinery$chart$junit$VerticalBarChartTests == null ? (class$com$jrefinery$chart$junit$VerticalBarChartTests = VerticalBarChartTests.class$("com.jrefinery.chart.junit.VerticalBarChartTests")) : class$com$jrefinery$chart$junit$VerticalBarChartTests);
    }

    public VerticalBarChartTests(String name) {
        super(name);
    }

    protected void setUp() {
        this.verticalBarChart = VerticalBarChartTests.createVerticalBarChart();
    }

    public void testDrawWithNullInfo() {
        boolean success = false;
        try {
            BufferedImage image = new BufferedImage(200, 100, 1);
            Graphics2D g2 = image.createGraphics();
            this.verticalBarChart.draw(g2, new Rectangle2D.Double(0.0, 0.0, 200.0, 100.0), null);
            g2.dispose();
            success = true;
        }
        catch (Exception e) {
            success = false;
        }
        VerticalBarChartTests.assertTrue((boolean)success);
    }

    public void testReplaceDataset() {
        Number[][] data = new Integer[][]{{new Integer(-30), new Integer(-20)}, {new Integer(-10), new Integer(10)}, {new Integer(20), new Integer(30)}};
        DefaultCategoryDataset newData = new DefaultCategoryDataset(data);
        LocalListener l = new LocalListener();
        this.verticalBarChart.addChangeListener(l);
        this.verticalBarChart.getPlot().setDataset(newData);
        VerticalBarChartTests.assertEquals((boolean)true, (boolean)l.flag);
        ValueAxis axis = this.verticalBarChart.getCategoryPlot().getRangeAxis();
        Range range = axis.getRange();
        VerticalBarChartTests.assertTrue((String)("Expecting the lower bound of the range to be around -30." + range.getLowerBound()), (range.getLowerBound() <= -30.0 ? 1 : 0) != 0);
        VerticalBarChartTests.assertTrue((String)("Expecting the upper bound of the range to be around 30:" + range.getUpperBound()), (range.getUpperBound() >= 30.0 ? 1 : 0) != 0);
    }

    private static JFreeChart createVerticalBarChart() {
        Number[][] data = new Integer[][]{{new Integer(-3), new Integer(-2)}, {new Integer(-1), new Integer(1)}, {new Integer(2), new Integer(3)}};
        DefaultCategoryDataset dataset = new DefaultCategoryDataset(data);
        return ChartFactory.createVerticalBarChart("Vertical Bar Chart", "Domain", "Range", dataset, true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class LocalListener
    implements ChartChangeListener {
        boolean flag = false;

        LocalListener() {
        }

        public void chartChanged(ChartChangeEvent event) {
            this.flag = true;
        }
    }
}

