/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.junit;

import com.jrefinery.chart.ChartFactory;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.event.ChartChangeEvent;
import com.jrefinery.chart.event.ChartChangeListener;
import com.jrefinery.data.DefaultCategoryDataset;
import com.jrefinery.data.Range;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class HorizontalBarChart3DTests
extends TestCase {
    private JFreeChart horizontalBarChart;
    static /* synthetic */ Class class$com$jrefinery$chart$junit$HorizontalBarChart3DTests;

    public static Test suite() {
        return new TestSuite(class$com$jrefinery$chart$junit$HorizontalBarChart3DTests == null ? (class$com$jrefinery$chart$junit$HorizontalBarChart3DTests = HorizontalBarChart3DTests.class$("com.jrefinery.chart.junit.HorizontalBarChart3DTests")) : class$com$jrefinery$chart$junit$HorizontalBarChart3DTests);
    }

    public HorizontalBarChart3DTests(String name) {
        super(name);
    }

    protected void setUp() {
        this.horizontalBarChart = HorizontalBarChart3DTests.createHorizontalBarChart();
    }

    public void testDrawWithNullInfo() {
        boolean success = false;
        try {
            BufferedImage image = new BufferedImage(200, 100, 1);
            Graphics2D g2 = image.createGraphics();
            this.horizontalBarChart.draw(g2, new Rectangle2D.Double(0.0, 0.0, 200.0, 100.0), null);
            g2.dispose();
            success = true;
        }
        catch (Exception e) {
            success = false;
        }
        HorizontalBarChart3DTests.assertTrue((boolean)success);
    }

    public void testReplaceDataset() {
        Number[][] data = new Integer[][]{{new Integer(-30), new Integer(-20)}, {new Integer(-10), new Integer(10)}, {new Integer(20), new Integer(30)}};
        DefaultCategoryDataset newData = new DefaultCategoryDataset(data);
        LocalListener l = new LocalListener();
        this.horizontalBarChart.addChangeListener(l);
        this.horizontalBarChart.getPlot().setDataset(newData);
        HorizontalBarChart3DTests.assertEquals((boolean)true, (boolean)l.flag);
        ValueAxis axis = this.horizontalBarChart.getCategoryPlot().getRangeAxis();
        Range range = axis.getRange();
        HorizontalBarChart3DTests.assertTrue((String)("Expecting the lower bound of the range to be around -30." + range.getLowerBound()), (range.getLowerBound() <= -30.0 ? 1 : 0) != 0);
        HorizontalBarChart3DTests.assertTrue((String)("Expecting the upper bound of the range to be around 30:" + range.getUpperBound()), (range.getUpperBound() >= 30.0 ? 1 : 0) != 0);
    }

    private static JFreeChart createHorizontalBarChart() {
        Number[][] data = new Integer[][]{{new Integer(-3), new Integer(-2)}, {new Integer(-1), new Integer(1)}, {new Integer(2), new Integer(3)}};
        DefaultCategoryDataset dataset = new DefaultCategoryDataset(data);
        return ChartFactory.createHorizontalBarChart3D("Horizontal Bar Chart 3D", "Domain", "Range", dataset, true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class LocalListener
    implements ChartChangeListener {
        boolean flag = false;

        LocalListener() {
        }

        public void chartChanged(ChartChangeEvent event) {
            this.flag = true;
        }
    }
}

