/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo.jdbc.servlet;

import com.jrefinery.chart.ChartFactory;
import com.jrefinery.chart.ChartUtilities;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.PiePlot;
import com.jrefinery.chart.TextTitle;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.data.LinearPlotFitAlgorithm;
import com.jrefinery.chart.data.MovingAveragePlotFitAlgorithm;
import com.jrefinery.chart.data.PlotFit;
import com.jrefinery.chart.demo.jdbc.servlet.Constants;
import com.jrefinery.data.JdbcCategoryDataset;
import com.jrefinery.data.JdbcPieDataset;
import com.jrefinery.data.JdbcXYDataset;
import com.jrefinery.data.XYDataset;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BaseImageServlet
extends HttpServlet
implements Constants {
    protected int sqlServerType = 0;
    protected String servletName = "Base Chart ";
    protected boolean debug = false;
    protected String chartTitle = "Data";
    protected String xAxisTitle = "";
    protected String yAxisTitle = "";
    static final char alphaStart = 'b';
    Connection con_;
    String dbDriver_ = "oracle.jdbc.driver.OracleDriver";
    String dbUrl_ = "jdbc:oracle:thin:@yourdb:1521:prod";
    String dbUser_ = "your_user";
    String dbPwd_ = "your_password";
    String dbSchema_ = null;

    protected Color getColor(int color) {
        switch (color % 11) {
            case 0: {
                return Color.white;
            }
            case 1: {
                return Color.black;
            }
            case 2: {
                return Color.blue;
            }
            case 3: {
                return Color.green;
            }
            case 4: {
                return Color.red;
            }
            case 5: {
                return Color.yellow;
            }
            case 6: {
                return Color.gray;
            }
            case 7: {
                return Color.orange;
            }
            case 8: {
                return Color.cyan;
            }
            case 9: {
                return Color.magenta;
            }
            case 10: {
                return Color.pink;
            }
            case 11: {
                return Color.getHSBColor(60.0f, 50.0f, 100.0f);
            }
        }
        return Color.white;
    }

    protected JFreeChart createChart(int type, String sql) {
        JFreeChart chart = null;
        if (this.debug) {
            System.out.println("Creating chart of type " + type);
        }
        if (!this.testConnection()) {
            return null;
        }
        chart = type < 10 ? this.createPieChart(type, sql) : (type < 20 ? this.createCategoryChart(type, sql) : this.createXYChart(type, sql));
        return chart;
    }

    protected JFreeChart createXYChart(int type, String sql) {
        JdbcXYDataset chartData = new JdbcXYDataset(this.con_, sql);
        try {
            XYDataset xyData;
            switch (type) {
                case 21: {
                    MovingAveragePlotFitAlgorithm mavg = new MovingAveragePlotFitAlgorithm();
                    mavg.setPeriod(30);
                    PlotFit pf = new PlotFit(chartData, mavg);
                    xyData = pf.getFit();
                    break;
                }
                case 22: {
                    PlotFit pf = new PlotFit(chartData, new LinearPlotFitAlgorithm());
                    xyData = pf.getFit();
                    break;
                }
                default: {
                    xyData = chartData;
                }
            }
            JFreeChart chart = chartData.isTimeSeries ? ChartFactory.createTimeSeriesChart("", "", "", xyData, true) : ChartFactory.createXYChart("", "", "", xyData, true);
            VerticalNumberAxis vnAxis = (VerticalNumberAxis)chart.getXYPlot().getRangeAxis();
            vnAxis.setAutoRangeIncludesZero(false);
            vnAxis.setCrosshairVisible(false);
            vnAxis.configure();
            ValueAxis axis = chart.getXYPlot().getDomainAxis();
            axis.setCrosshairVisible(false);
            return chart;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            if (this.debug) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected JFreeChart createPieChart(int type, String sql) {
        try {
            JdbcPieDataset chartData = new JdbcPieDataset(this.con_);
            chartData.executeQuery(sql);
            JFreeChart chart = ChartFactory.createPieChart("", chartData, true);
            return chart;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    protected JFreeChart createCategoryChart(int type, String sql) {
        try {
            JFreeChart chart;
            JdbcCategoryDataset chartData = new JdbcCategoryDataset(this.con_);
            chartData.executeQuery(sql);
            switch (type) {
                case 11: {
                    chart = ChartFactory.createVerticalBarChart3D("", "", "", chartData, true);
                    break;
                }
                case 12: {
                    chart = ChartFactory.createStackedVerticalBarChart("", "", "", chartData, true);
                    break;
                }
                case 13: {
                    chart = ChartFactory.createStackedVerticalBarChart3D("", "", "", chartData, true);
                    break;
                }
                case 14: {
                    chart = ChartFactory.createHorizontalBarChart("", "", "", chartData, true);
                    break;
                }
                case 15: {
                    chart = ChartFactory.createStackedHorizontalBarChart("", "", "", chartData, true);
                    break;
                }
                default: {
                    chart = ChartFactory.createVerticalBarChart("", "", "", chartData, true);
                }
            }
            return chart;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public void init(ServletConfig config) throws ServletException {
        String test = null;
        super.init(config);
        try {
            this.sqlServerType = Integer.parseInt(this.getServletContext().getInitParameter("DBserver.type"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.dbUser_ = this.getServletContext().getInitParameter("DBuser");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.dbPwd_ = this.getServletContext().getInitParameter("DBpwd");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.dbUrl_ = this.getServletContext().getInitParameter("DBurl");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.dbDriver_ = this.getServletContext().getInitParameter("DBdriver");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.dbSchema_ = this.getServletContext().getInitParameter("DBschema");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            test = this.getServletContext().getInitParameter("DEBUG");
            if (test != null) {
                test = test.trim().toUpperCase();
                this.statusMessage("Setting debug to '" + test + "'");
                this.debug = test.equals("TRUE");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            test = this.getInitParameter("DBuser");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (test != null && test.length() > 0) {
            this.dbUser_ = test;
        }
        try {
            test = this.getInitParameter("DBpwd");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (test != null && test.length() > 0) {
            this.dbPwd_ = test;
        }
        try {
            test = this.getInitParameter("DBurl");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (test != null && test.length() > 0) {
            this.dbUrl_ = test;
        }
        try {
            test = this.getInitParameter("DBdriver");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (test != null && test.length() > 0) {
            this.dbDriver_ = test;
        }
        try {
            test = this.getInitParameter("DBschema");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (test != null && test.length() > 0) {
            this.dbSchema_ = test;
        }
        try {
            test = this.getInitParameter("ChartTitle");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (test != null && test.length() > 0) {
            this.chartTitle = test;
        }
        try {
            test = this.getInitParameter("xAxisTitle");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (test != null && test.length() > 0) {
            this.xAxisTitle = test;
        }
        try {
            test = this.getInitParameter("yAxisTitle");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (test != null && test.length() > 0) {
            this.yAxisTitle = test;
        }
        if (this.dbSchema_ != null && this.dbSchema_.length() > 0) {
            if (!this.dbSchema_.endsWith(".")) {
                this.dbSchema_ = this.dbSchema_ + ".";
            }
        } else {
            this.dbSchema_ = " ";
        }
        this.statusMessage("Debug    : " + this.debug);
        this.statusMessage("Driver   : " + this.dbDriver_);
        this.statusMessage("Database : " + this.dbUrl_);
        this.statusMessage("Schema   : " + this.dbSchema_);
        this.statusMessage("User     : " + this.dbUser_);
        this.statusMessage("Password : #######");
        this.openConnection();
    }

    protected String generateSQL(HttpServletRequest request) {
        return "select 1, 10 from dual";
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        initColor = 0;
        finalColor = 0;
        type = 0;
        width = 700;
        height = 400;
        flag = false;
        showLegend = true;
        imageOutputType = 1;
        chartTitle_ = this.chartTitle;
        xTitle_ = this.xAxisTitle;
        yTitle_ = this.yAxisTitle;
        sql = "";
        test = "";
        try {
            type = Integer.parseInt(request.getParameter("type"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            width = Integer.parseInt(request.getParameter("width"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            height = Integer.parseInt(request.getParameter("height"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            initColor = Integer.parseInt(request.getParameter("initColor"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            finalColor = Integer.parseInt(request.getParameter("finalColor"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            chartTitle_ = request.getParameter("title");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            xTitle_ = request.getParameter("xaxistitle");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            yTitle_ = request.getParameter("yaxistitle");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            flag = request.getParameter("zero").trim().toLowerCase().equals("true");
        }
        catch (Exception e) {
            flag = true;
        }
        try {
            showLegend = request.getParameter("legend").trim().toLowerCase().equals("false") == false;
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            test = request.getParameter("output");
            if (test != null) {
                test = test.trim();
                imageOutputType = Integer.parseInt(test);
            }
        }
        catch (Exception e) {
            try {
                i = 1;
                while (i < Constants.CONTENT_TYPE.length) {
                    if (Constants.CONTENT_TYPE[i][0].equalsIgnoreCase(test)) {
                        imageOutputType = i;
                        i = Constants.CONTENT_TYPE.length;
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                type = 1;
            }
        }
        if (width > 2000) {
            width = 2000;
        }
        if (width < 10) {
            width = 10;
        }
        if (height > 1000) {
            height = 1000;
        }
        if (height < 10) {
            height = 10;
        }
        sql = this.generateSQL(request);
        this.statusMessage(sql);
        chart = this.createChart(type, sql);
        if (chart == null) {
            this.writeErrorPage(response, "No Chart returned. \nSQL : " + sql);
            return;
        }
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, this.getColor(initColor), 0.0f, height, this.getColor(finalColor)));
        if (showLegend) {
            legend = chart.getLegend();
            legend.setAnchor(2);
        } else {
            chart.setLegend(null);
        }
        chartPlot = chart.getPlot();
        axis = null;
        if (chartPlot instanceof XYPlot) {
            axis = ((XYPlot)chartPlot).getRangeAxis();
        }
        if (axis != null) {
            if (yTitle_ != null) {
                axis.setLabel(yTitle_);
            }
            if (axis instanceof VerticalNumberAxis) {
                vnAxis = (VerticalNumberAxis)axis;
                vnAxis.setAutoRangeIncludesZero(flag);
            }
        }
        if (chartPlot instanceof XYPlot) {
            axis = ((XYPlot)chartPlot).getDomainAxis();
        }
        if (axis != null && xTitle_ != null) {
            axis.setLabel(xTitle_);
        }
        if (chartPlot instanceof PiePlot) {
            pie = (PiePlot)chartPlot;
            x = -1.0;
            try {
                x = Double.parseDouble(request.getParameter("radiusPercent")) / 100.0;
                if (x > 0.0 && x <= 1.0) {
                    pie.setRadiusPercent(x);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            x = -1.0;
            try {
                type = Integer.parseInt(request.getParameter("explode"));
                if (type >= 0 && type < pie.getCategories().size()) {
                    x = Double.parseDouble(request.getParameter("explodePercent")) / 100.0;
                    pie.setExplodePercent(type, x);
                } else {
                    this.statusMessage("invalid explosion chosen : " + type + ", valid range (0-" + pie.getCategories().size() + ")");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                flag = request.getParameter("circular").trim().toLowerCase().equals("false");
                pie.setCircular(flag);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                type = Integer.parseInt(request.getParameter("labelType"));
                pie.setSectionLabelType(type);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (chartTitle_ != null) {
            titles = new ArrayList<TextTitle>();
            subtitle = new TextTitle(chartTitle_, new Font("SansSerif", 1, 12));
            titles.add(subtitle);
            chart.setTitles(titles);
        }
        this.modifyChart(chart, request);
        out = response.getOutputStream();
        try {
            try {
                response.setContentType(Constants.CONTENT_TYPE[imageOutputType][1]);
                switch (imageOutputType) {
                    case 2: {
                        ChartUtilities.writeChartAsPNG((OutputStream)out, chart, width, height);
                        ** break;
                    }
                }
                ChartUtilities.writeChartAsJPEG((OutputStream)out, chart, width, height);
            }
            catch (Exception ex) {
                this.statusMessage("Error SQL = " + sql);
                ex.printStackTrace();
                var24_42 = null;
                out.flush();
                out.close();
                return;
            }
lbl175:
            // 2 sources

            var24_41 = null;
        }
        catch (Throwable var23_44) {
            var24_43 = null;
            out.flush();
            out.close();
            throw var23_44;
        }
        out.flush();
        out.close();
    }

    protected BufferedImage draw(JFreeChart chart, int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics2D g2 = img.createGraphics();
        chart.draw(g2, new Rectangle2D.Double(0.0, 0.0, width, height), null);
        g2.dispose();
        return img;
    }

    public void modifyChart(JFreeChart chart, HttpServletRequest request) {
    }

    public void destroy() {
    }

    protected void openConnection() {
        Object obj = null;
        try {
            obj = this.getServletContext().getAttribute("SHARED_DB");
            if (obj != null) {
                this.con_ = (Connection)obj;
                this.con_.isClosed();
                this.statusMessage("Shared connection retrieved ");
            }
        }
        catch (Exception e) {
            this.statusMessage("Shared connection failure detected");
            this.con_ = null;
        }
        if (this.con_ == null) {
            try {
                Class.forName(this.dbDriver_);
            }
            catch (ClassNotFoundException cnfe) {
                this.statusMessage("Cannot find database JDBC drivers using " + this.dbDriver_ + " - check CLASSPATH");
                return;
            }
            try {
                this.con_ = DriverManager.getConnection(this.dbUrl_, this.dbUser_, this.dbPwd_);
            }
            catch (SQLException sqle) {
                this.statusMessage("Cannot get database connection when instantiating class - " + sqle);
            }
            if (this.con_ == null) {
                this.statusMessage("Cannot connect to database using URL " + this.dbUrl_ + " as user " + this.dbUser_);
                return;
            }
            this.getServletContext().setAttribute("SHARED_DB", (Object)this.con_);
            this.getServletContext().setAttribute("SHARED_DB_OPENER", (Object)this.servletName);
            this.statusMessage("Shared Connection Established");
        }
    }

    private void closeConnection() {
        try {
            if (this.con_ != null) {
                this.con_.close();
            }
            this.statusMessage("Connection Closed");
        }
        catch (SQLException ex) {
            this.statusMessage("Error in closing the database connection: ");
        }
        this.con_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean testConnection() {
        try {
            try {
                this.con_.isClosed();
            }
            catch (Exception r) {
                this.statusMessage("Connection failure detected - attempting to reconnect");
                this.con_ = null;
                this.getServletContext().setAttribute("SHARED_DB", null);
                this.openConnection();
                Object var3_2 = null;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
        return this.con_ != null;
    }

    private void statusMessage(String message) {
        if (this.debug) {
            System.out.println(this.servletName + " - " + message);
        }
    }

    protected void writeErrorPage(HttpServletResponse response, String message) {
        System.out.println("Returning Error Page");
        try {
            response.setContentType(Constants.CONTENT_TYPE[0][1]);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream());
            writer.write("<H1>ERROR</H1>");
            writer.write("<P>An error has occured processing your image request.</P>");
            writer.write("<P>" + message + "</P>");
            writer.write("<P>More information may be available from the server console.</P>");
            writer.flush();
            writer.close();
        }
        catch (Exception ex) {
            System.err.println("Error writing error message : " + ex.getMessage());
        }
    }

    static {
        alphaStart = (char)98;
    }
}

