/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.ChartPanel;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.JFreeChartConstants;
import com.jrefinery.chart.JThermometer;
import com.jrefinery.chart.MeterPlot;
import com.jrefinery.data.DefaultMeterDataset;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ThermometerDemo
extends JPanel {
    protected static final String[] OPTIONS = new String[]{"None", "Right", "Bulb"};
    DefaultMeterDataset data = new DefaultMeterDataset();
    MeterPlot meterplot = new MeterPlot(this.data);
    JFreeChart meterchart = new JFreeChart("Meter Chart", JFreeChartConstants.DEFAULT_TITLE_FONT, this.meterplot, false);
    ChartPanel panelMeter = new ChartPanel(this.meterchart);
    JPanel jPanel1 = new JPanel();
    JButton butUp3 = new JButton();
    JButton butDown3 = new JButton();
    JPanel jPanel2 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel3 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel4 = new JPanel();
    JButton butDown2 = new JButton();
    JButton butUp2 = new JButton();
    JPanel jPanel5 = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    JPanel jPanel6 = new JPanel();
    JButton butUp1 = new JButton();
    JButton butDown1 = new JButton();
    JThermometer thermo1 = new JThermometer();
    JThermometer thermo2 = new JThermometer();
    JThermometer thermo3 = new JThermometer();
    JThermometer[] thermo = new JThermometer[3];
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel7 = new JPanel();
    JPanel jPanel8 = new JPanel();
    JPanel jPanel9 = new JPanel();
    GridLayout gridLayout2 = new GridLayout();
    GridLayout gridLayout3 = new GridLayout();
    GridLayout gridLayout4 = new GridLayout();
    JComboBox pickShow1 = new JComboBox<String>(OPTIONS);
    JComboBox pickShow2 = new JComboBox<String>(OPTIONS);
    JComboBox pickShow3 = new JComboBox<String>(OPTIONS);
    JComboBox[] pickShow = new JComboBox[3];
    JPanel jPanel10 = new JPanel();
    BorderLayout borderLayout4 = new BorderLayout();
    JPanel jPanel11 = new JPanel();
    JButton butDown4 = new JButton();
    JButton butUp4 = new JButton();

    public ThermometerDemo() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.data.setRange(new Double(-20.0), new Double(20.0));
        this.thermo[0] = this.thermo1;
        this.thermo[1] = this.thermo2;
        this.thermo[2] = this.thermo3;
        this.thermo[0].setValue(0.0);
        this.thermo[1].setValue(0.2);
        this.thermo[2].setValue(0.3);
        this.thermo[0].setBackground(Color.white);
        this.thermo[2].setBackground(Color.white);
        this.thermo[0].setOutlinePaint(null);
        this.thermo[1].setOutlinePaint(null);
        this.thermo[2].setOutlinePaint(null);
        this.thermo[0].setUnits(0);
        this.thermo[1].setUnits(1);
        this.thermo[2].setUnits(2);
        this.thermo[0].setFont(new Font("Arial", 1, 20));
        this.thermo[0].setShowValueLines(true);
        this.thermo[0].setFollowData(true);
        this.thermo[1].setDisplayLocation(1);
        this.thermo[1].setForeground(Color.blue);
        this.thermo[2].setForeground(Color.pink);
        this.thermo[0].setRangeInfo(0, 0.0, 20.0, 0.0, 26.0);
        this.thermo[0].setRangeInfo(1, 20.0, 24.0, 0.0, 26.0);
        this.thermo[0].setRangeInfo(2, 24.0, 26.0, 0.0, 26.0);
        this.thermo[0].addTitle("Sea Water Temp");
        this.thermo[1].addTitle("Air Temp", new Font("Arial", 1, 24));
        this.thermo[2].addTitle("Ship Temp", new Font("Arial", 3, 20));
        this.thermo[1].setValueFormat(new DecimalFormat("#0.0"));
        this.thermo[2].setValueFormat(new DecimalFormat("#0.00"));
        this.pickShow[0] = this.pickShow1;
        this.pickShow[1] = this.pickShow2;
        this.pickShow[2] = this.pickShow3;
        this.setLayout(this.gridLayout1);
        this.butDown3.setText("<");
        this.butDown3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThermometerDemo.this.setValue(2, -1.0);
            }
        });
        this.butUp3.setText(">");
        this.butUp3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThermometerDemo.this.setValue(2, 1.0);
            }
        });
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel3.setLayout(this.borderLayout3);
        this.butDown2.setText("<");
        this.butDown2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThermometerDemo.this.setValue(1, -1.0);
            }
        });
        this.butUp2.setText(">");
        this.butUp2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThermometerDemo.this.setValue(1, 1.0);
            }
        });
        this.butUp1.setText(">");
        this.butUp1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThermometerDemo.this.setValue(0, 1.0);
            }
        });
        this.butDown1.setText("<");
        this.butDown1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThermometerDemo.this.setValue(0, -1.0);
            }
        });
        this.jPanel5.setLayout(this.borderLayout1);
        this.pickShow1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThermometerDemo.this.setShowValue(0);
            }
        });
        this.pickShow2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThermometerDemo.this.setShowValue(1);
            }
        });
        this.pickShow3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThermometerDemo.this.setShowValue(2);
            }
        });
        this.jPanel9.setLayout(this.gridLayout2);
        this.gridLayout2.setColumns(1);
        this.jPanel8.setLayout(this.gridLayout3);
        this.jPanel7.setLayout(this.gridLayout4);
        this.jPanel5.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel6.setBackground(Color.white);
        this.jPanel2.setBackground(Color.white);
        this.jPanel9.setBackground(Color.white);
        this.jPanel10.setLayout(this.borderLayout4);
        this.butDown4.setText("<");
        this.butDown4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThermometerDemo.this.setMeterValue(-1.1);
            }
        });
        this.butUp4.setText(">");
        this.butUp4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThermometerDemo.this.setMeterValue(1.1);
            }
        });
        this.jPanel1.add((Component)this.thermo3, "Center");
        this.jPanel1.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.butDown3, null);
        this.jPanel2.add((Component)this.butUp3, null);
        this.jPanel1.add((Component)this.jPanel9, "North");
        this.jPanel9.add((Component)this.pickShow3, null);
        this.add((Component)this.jPanel10, null);
        this.jPanel10.add((Component)this.jPanel11, "South");
        this.jPanel11.add((Component)this.butDown4, null);
        this.jPanel11.add((Component)this.butUp4, null);
        this.jPanel4.add((Component)this.butDown2, null);
        this.jPanel4.add((Component)this.butUp2, null);
        this.jPanel3.add((Component)this.jPanel8, "North");
        this.jPanel8.add((Component)this.pickShow2, null);
        this.jPanel3.add((Component)this.thermo2, "Center");
        this.jPanel3.add((Component)this.jPanel4, "South");
        this.add((Component)this.jPanel5, null);
        this.jPanel5.add((Component)this.thermo1, "Center");
        this.jPanel5.add((Component)this.jPanel6, "South");
        this.jPanel6.add((Component)this.butDown1, null);
        this.jPanel6.add((Component)this.butUp1, null);
        this.jPanel5.add((Component)this.jPanel7, "North");
        this.jPanel7.add((Component)this.pickShow1, null);
        this.add((Component)this.jPanel3, null);
        this.add((Component)this.jPanel1, null);
        this.jPanel10.add((Component)this.panelMeter, "Center");
    }

    public static void main(String[] args) {
        ThermometerDemo panel = new ThermometerDemo();
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout(5, 5));
        frame.setDefaultCloseOperation(3);
        frame.setTitle("Thermometer Test");
        frame.getContentPane().add((Component)panel, "Center");
        frame.setSize(700, 400);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
        frame.setVisible(true);
    }

    private void setValue(int thermometer, double value) {
        if (thermometer >= 0 && thermometer < 3) {
            try {
                this.thermo[thermometer].setValue(this.thermo[thermometer].getValue().doubleValue() + value);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void setMeterValue(double value) {
        try {
            double newValue = value;
            if (this.data.isValueValid()) {
                newValue += this.data.getValue().doubleValue();
            }
            this.data.setValue(new Double(newValue));
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }

    private void setShowValue(int thermometer) {
        if (thermometer >= 0 && thermometer < 3) {
            this.thermo[thermometer].setDisplayLocation(this.pickShow[thermometer].getSelectedIndex());
        }
    }
}

