/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.ChartFrame;
import com.jrefinery.chart.CombinedXYPlot;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.JFreeChartConstants;
import com.jrefinery.chart.OverlaidXYPlot;
import com.jrefinery.chart.StandardXYItemRenderer;
import com.jrefinery.chart.VerticalSymbolicAxis;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.demo.SampleYSymbolicDataset;
import com.jrefinery.chart.tooltips.SymbolicXYToolTipGenerator;
import com.jrefinery.data.CombinedDataset;
import com.jrefinery.data.SeriesDataset;
import com.jrefinery.data.SubSeriesDataset;
import com.jrefinery.data.XYDataset;
import com.jrefinery.data.YisSymbolic;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Color;
import java.awt.GradientPaint;

public class SymbolicYPlotDemo {
    private static void displayYSymbolic(String frameTitle, XYDataset data, String chartTitle, String xAxisLabel, String yAxisLabel) {
        JFreeChart chart = SymbolicYPlotDemo.createYSymbolicPlot(chartTitle, xAxisLabel, yAxisLabel, data, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.green));
        ChartFrame frame = new ChartFrame(frameTitle, chart);
        frame.pack();
        RefineryUtilities.positionFrameRandomly(frame);
        frame.show();
    }

    private static void displayYSymbolicOverlaid(String frameTitle, XYDataset data1, XYDataset data2) {
        String title = "Animals Overlaid";
        String xAxisLabel = "Miles";
        String yAxisLabel = "Animal";
        String[] combinedYSymbolicValues = SampleYSymbolicDataset.combineYSymbolicDataset((YisSymbolic)((Object)data1), (YisSymbolic)((Object)data2));
        CombinedDataset data = new CombinedDataset();
        data.add(data1);
        data.add(data2);
        SubSeriesDataset series0 = new SubSeriesDataset((SeriesDataset)data, 0);
        SubSeriesDataset series1 = new SubSeriesDataset((SeriesDataset)data, 1);
        SubSeriesDataset series2 = new SubSeriesDataset((SeriesDataset)data, 2);
        SubSeriesDataset series3 = new SubSeriesDataset((SeriesDataset)data, 3);
        SubSeriesDataset series4 = new SubSeriesDataset((SeriesDataset)data, 4);
        SubSeriesDataset series5 = new SubSeriesDataset((SeriesDataset)data, 5);
        SubSeriesDataset series6 = new SubSeriesDataset((SeriesDataset)data, 6);
        SubSeriesDataset series7 = new SubSeriesDataset((SeriesDataset)data, 7);
        HorizontalNumberAxis valueAxis = new HorizontalNumberAxis(xAxisLabel);
        VerticalSymbolicAxis symbolicAxis = new VerticalSymbolicAxis(yAxisLabel, combinedYSymbolicValues);
        OverlaidXYPlot mainPlot = new OverlaidXYPlot(valueAxis, symbolicAxis);
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(1, null);
        XYPlot subplot0 = new XYPlot(series0, null, null, renderer);
        XYPlot subplot1 = new XYPlot(series1, null, null, renderer);
        XYPlot subplot2 = new XYPlot(series2, null, null, renderer);
        XYPlot subplot3 = new XYPlot(series3, null, null, renderer);
        XYPlot subplot4 = new XYPlot(series4, null, null, renderer);
        XYPlot subplot5 = new XYPlot(series5, null, null, renderer);
        XYPlot subplot6 = new XYPlot(series6, null, null, renderer);
        XYPlot subplot7 = new XYPlot(series7, null, null, renderer);
        mainPlot.add(subplot0);
        mainPlot.add(subplot1);
        mainPlot.add(subplot2);
        mainPlot.add(subplot3);
        mainPlot.add(subplot4);
        mainPlot.add(subplot5);
        mainPlot.add(subplot6);
        mainPlot.add(subplot7);
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, mainPlot, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        ChartFrame frame = new ChartFrame(frameTitle, chart);
        frame.pack();
        RefineryUtilities.positionFrameRandomly(frame);
        frame.show();
    }

    private static void displayYSymbolicCombinedHorizontally(String frameTitle, SampleYSymbolicDataset data1, SampleYSymbolicDataset data2) {
        String title = "Animals Horizontally Combined";
        String xAxisLabel = "Miles";
        String yAxisLabel = null;
        String[] combinedYSymbolicValues = SampleYSymbolicDataset.combineYSymbolicDataset(data1, data2);
        CombinedDataset data = new CombinedDataset();
        data.add(data1);
        data.add(data2);
        SubSeriesDataset series0 = new SubSeriesDataset((SeriesDataset)data, 0);
        SubSeriesDataset series1 = new SubSeriesDataset((SeriesDataset)data, 1);
        SubSeriesDataset series2 = new SubSeriesDataset((SeriesDataset)data, 2);
        SubSeriesDataset series3 = new SubSeriesDataset((SeriesDataset)data, 3);
        SubSeriesDataset series4 = new SubSeriesDataset((SeriesDataset)data, 4);
        SubSeriesDataset series5 = new SubSeriesDataset((SeriesDataset)data, 5);
        SubSeriesDataset series6 = new SubSeriesDataset((SeriesDataset)data, 6);
        SubSeriesDataset series7 = new SubSeriesDataset((SeriesDataset)data, 7);
        HorizontalNumberAxis valueAxis1 = new HorizontalNumberAxis(xAxisLabel);
        HorizontalNumberAxis valueAxis2 = new HorizontalNumberAxis(xAxisLabel);
        VerticalSymbolicAxis symbolicAxis = new VerticalSymbolicAxis(yAxisLabel, combinedYSymbolicValues);
        CombinedXYPlot mainPlot = new CombinedXYPlot(symbolicAxis, 0);
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(1, null);
        XYPlot subplot0 = new XYPlot(series0, valueAxis1, null, renderer);
        XYPlot subplot1 = new XYPlot(series1, valueAxis1, null, renderer);
        XYPlot subplot2 = new XYPlot(series2, valueAxis1, null, renderer);
        XYPlot subplot3 = new XYPlot(series3, valueAxis1, null, renderer);
        XYPlot subplot4 = new XYPlot(series4, valueAxis2, null, renderer);
        XYPlot subplot5 = new XYPlot(series5, valueAxis2, null, renderer);
        XYPlot subplot6 = new XYPlot(series6, valueAxis2, null, renderer);
        XYPlot subplot7 = new XYPlot(series7, valueAxis2, null, renderer);
        mainPlot.add(subplot0, 1);
        mainPlot.add(subplot1, 1);
        mainPlot.add(subplot2, 1);
        mainPlot.add(subplot3, 1);
        mainPlot.add(subplot4, 1);
        mainPlot.add(subplot5, 1);
        mainPlot.add(subplot6, 1);
        mainPlot.add(subplot7, 1);
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, mainPlot, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        ChartFrame ySymbolicFrame = new ChartFrame(frameTitle, chart);
        ySymbolicFrame.pack();
        RefineryUtilities.positionFrameRandomly(ySymbolicFrame);
        ySymbolicFrame.show();
    }

    private static void displayYSymbolicCombinedVertically(String frameTitle, SampleYSymbolicDataset data1, SampleYSymbolicDataset data2) {
        String title = "Animals Vertically Combined";
        String xAxisLabel = "Miles";
        String yAxisLabel = null;
        CombinedDataset data = new CombinedDataset();
        data.add(data1);
        data.add(data2);
        SubSeriesDataset series0 = new SubSeriesDataset((SeriesDataset)data, 0);
        SubSeriesDataset series1 = new SubSeriesDataset((SeriesDataset)data, 1);
        SubSeriesDataset series2 = new SubSeriesDataset((SeriesDataset)data, 2);
        SubSeriesDataset series3 = new SubSeriesDataset((SeriesDataset)data, 3);
        SubSeriesDataset series4 = new SubSeriesDataset((SeriesDataset)data, 4);
        SubSeriesDataset series5 = new SubSeriesDataset((SeriesDataset)data, 5);
        SubSeriesDataset series6 = new SubSeriesDataset((SeriesDataset)data, 6);
        SubSeriesDataset series7 = new SubSeriesDataset((SeriesDataset)data, 7);
        HorizontalNumberAxis valueAxis = new HorizontalNumberAxis(xAxisLabel);
        VerticalSymbolicAxis symbolicAxis1 = new VerticalSymbolicAxis(yAxisLabel, data1.getYSymbolicValues());
        VerticalSymbolicAxis symbolicAxis2 = new VerticalSymbolicAxis(yAxisLabel, data2.getYSymbolicValues());
        CombinedXYPlot mainPlot = new CombinedXYPlot(valueAxis, 1);
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(1, null);
        XYPlot subplot0 = new XYPlot(series0, null, symbolicAxis1, renderer);
        XYPlot subplot1 = new XYPlot(series1, null, symbolicAxis1, renderer);
        XYPlot subplot2 = new XYPlot(series2, null, symbolicAxis1, renderer);
        XYPlot subplot3 = new XYPlot(series3, null, symbolicAxis1, renderer);
        XYPlot subplot4 = new XYPlot(series4, null, symbolicAxis2, renderer);
        XYPlot subplot5 = new XYPlot(series5, null, symbolicAxis2, renderer);
        XYPlot subplot6 = new XYPlot(series6, null, symbolicAxis2, renderer);
        XYPlot subplot7 = new XYPlot(series7, null, symbolicAxis2, renderer);
        mainPlot.add(subplot0, 1);
        mainPlot.add(subplot1, 1);
        mainPlot.add(subplot2, 1);
        mainPlot.add(subplot3, 1);
        mainPlot.add(subplot4, 1);
        mainPlot.add(subplot5, 1);
        mainPlot.add(subplot6, 1);
        mainPlot.add(subplot7, 1);
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, mainPlot, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        ChartFrame frame = new ChartFrame(frameTitle, chart);
        frame.pack();
        RefineryUtilities.positionFrameRandomly(frame);
        frame.show();
    }

    public static JFreeChart createYSymbolicPlot(String title, String xAxisLabel, String yAxisLabel, XYDataset data, boolean legend) {
        HorizontalNumberAxis valueAxis = new HorizontalNumberAxis(xAxisLabel);
        VerticalSymbolicAxis symbolicAxis = new VerticalSymbolicAxis(yAxisLabel, ((YisSymbolic)((Object)data)).getYSymbolicValues());
        XYPlot plot = new XYPlot(data, valueAxis, symbolicAxis);
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(1, new SymbolicXYToolTipGenerator());
        plot.setXYItemRenderer(renderer);
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, legend);
        return chart;
    }

    public static SampleYSymbolicDataset createYSymbolicSample1() {
        String[] sData = new String[]{"Lion", "Elephant", "Monkey", "Hippopotamus", "Giraffe"};
        SampleYSymbolicDataset data = new SampleYSymbolicDataset("AY Sample", 20, sData, 4, 20, new String[]{"A Fall", "A Spring", "A Summer", "A Winter"});
        return data;
    }

    public static SampleYSymbolicDataset createYSymbolicSample2() {
        String[] sData = new String[]{"Giraffe", "Gazelle", "Zebra", "Gnu"};
        SampleYSymbolicDataset data = new SampleYSymbolicDataset("BY Sample", 40, sData, 4, 20, new String[]{"B Fall", "B Spring", "B Summer", "B Winter"});
        return data;
    }

    public static void main(String[] args) {
        SampleYSymbolicDataset s1 = SymbolicYPlotDemo.createYSymbolicSample1();
        SampleYSymbolicDataset s2 = SymbolicYPlotDemo.createYSymbolicSample2();
        SymbolicYPlotDemo.displayYSymbolic("Example 1", s1, "Animal A", "Miles", "Animal");
        SymbolicYPlotDemo.displayYSymbolic("Example 2", s2, "Animal B", "Miles", "Animal");
        SymbolicYPlotDemo.displayYSymbolicCombinedHorizontally("Example 3", (SampleYSymbolicDataset)s1.clone(), (SampleYSymbolicDataset)s2.clone());
        SymbolicYPlotDemo.displayYSymbolicCombinedVertically("Example 4", (SampleYSymbolicDataset)s1.clone(), (SampleYSymbolicDataset)s2.clone());
        SymbolicYPlotDemo.displayYSymbolicOverlaid("Example 5", (SampleYSymbolicDataset)s1.clone(), (SampleYSymbolicDataset)s2.clone());
    }
}

