/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.ChartFrame;
import com.jrefinery.chart.CombinedXYPlot;
import com.jrefinery.chart.HorizontalSymbolicAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.JFreeChartConstants;
import com.jrefinery.chart.OverlaidXYPlot;
import com.jrefinery.chart.StandardXYItemRenderer;
import com.jrefinery.chart.VerticalSymbolicAxis;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.demo.SampleXYSymbolicDataset;
import com.jrefinery.chart.demo.SampleYSymbolicDataset;
import com.jrefinery.chart.tooltips.SymbolicXYToolTipGenerator;
import com.jrefinery.data.CombinedDataset;
import com.jrefinery.data.SeriesDataset;
import com.jrefinery.data.SubSeriesDataset;
import com.jrefinery.data.XYDataset;
import com.jrefinery.data.XisSymbolic;
import com.jrefinery.data.YisSymbolic;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Color;
import java.awt.GradientPaint;
import java.lang.reflect.Array;

public class SymbolicXYPlotDemo {
    public static JFreeChart createXYSymbolicPlot(String title, String xAxisLabel, String yAxisLabel, XYDataset data, boolean legend) {
        HorizontalSymbolicAxis xSymbolicAxis = new HorizontalSymbolicAxis(xAxisLabel, ((XisSymbolic)((Object)data)).getXSymbolicValues());
        VerticalSymbolicAxis ySymbolicAxis = new VerticalSymbolicAxis(yAxisLabel, ((YisSymbolic)((Object)data)).getYSymbolicValues());
        XYPlot plot = new XYPlot(data, xSymbolicAxis, ySymbolicAxis);
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(1, new SymbolicXYToolTipGenerator());
        plot.setXYItemRenderer(renderer);
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, legend);
        return chart;
    }

    public static SampleYSymbolicDataset createYSymbolicSample1() {
        String[] sData = new String[]{"Lion", "Elephant", "Monkey", "Hippopotamus", "Giraffe"};
        SampleYSymbolicDataset data = new SampleYSymbolicDataset("AY Sample", 20, sData, 4, 20, new String[]{"Fall", "Spring", "Summer", "Winter"});
        return data;
    }

    public static SampleYSymbolicDataset createYSymbolicSample2() {
        String[] sData = new String[]{"Giraffe", "Gazelle", "Zebra", "Gnu"};
        SampleYSymbolicDataset data = new SampleYSymbolicDataset("BY Sample", 40, sData, 4, 10, new String[]{"Fall", "Spring", "Summer", "Winter"});
        return data;
    }

    public static SampleXYSymbolicDataset createXYSymbolicSample1() {
        String[] xsData = new String[]{"Atmosphere", "Continental Ecosystem", "Limnic Ecosystem", "Marine Ecosystem"};
        String[] ysData = new String[]{"Ionizing radiations", "Thermic pollutants", "Hydrocarbon", "Synthetic materials", "Pesticides", "Detergent", "Synthetic organic materials", "Sulphur", "Nitrate", "Phosphate", "Heavy metals", "Fluors", "Aerosols", "Dead organic materials", "Pathogen micro-organisms"};
        int[][] xd = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3}};
        int[][] yd = new int[][]{{0, 2, 3, 7, 10, 11, 12, 14, 0, 2, 3, 4, 7, 8, 9, 10, 11, 12, 14, 0, 1, 2, 3, 4, 5, 7, 8, 9, 10, 13, 14, 0, 1, 2, 3, 4, 5, 8, 9, 10, 13, 14}};
        Integer[][] xData = (Integer[][])SymbolicXYPlotDemo.toArray(xd);
        Integer[][] yData = (Integer[][])SymbolicXYPlotDemo.toArray(yd);
        SampleXYSymbolicDataset xySymbolicData = new SampleXYSymbolicDataset("AXY Sample", xData, yData, xsData, ysData, new String[]{"A"});
        return xySymbolicData;
    }

    public static SampleXYSymbolicDataset createXYSymbolicSample2() {
        String[] xsData = new String[]{"Physic pollutant", "Chemical pollutant", "Biological pollutant"};
        String[] ysData = new String[]{"Ionizing radiations", "Thermic pollutants", "Hydrocarbon", "Synthetic materials", "Pesticides", "Detergent", "Synthetic organic materials", "Sulphur", "Nitrate", "Phosphate", "Heavy metals", "Fluors", "Aerosols", "Dead organic materials", "Pathogen micro-organisms"};
        int[][] xd = new int[][]{{0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2}};
        int[][] yd = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14}};
        Integer[][] xData = (Integer[][])SymbolicXYPlotDemo.toArray(xd);
        Integer[][] yData = (Integer[][])SymbolicXYPlotDemo.toArray(yd);
        SampleXYSymbolicDataset xySymbolicData = new SampleXYSymbolicDataset("BXY Sample", xData, yData, xsData, ysData, new String[]{"B"});
        return xySymbolicData;
    }

    private static void displayXYSymbolic(String frameTitle, XYDataset data, String chartTitle, String xAxisLabel, String yAxisLabel) {
        JFreeChart chart = SymbolicXYPlotDemo.createXYSymbolicPlot(chartTitle, xAxisLabel, yAxisLabel, data, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.green));
        ChartFrame frame = new ChartFrame(frameTitle, chart);
        frame.pack();
        RefineryUtilities.positionFrameRandomly(frame);
        frame.show();
    }

    private static void displayXYSymbolicOverlaid(String frameTitle, XYDataset data1, XYDataset data2) {
        String title = "Pollutant Overlaid";
        String xAxisLabel = "Contamination and Type";
        String yAxisLabel = "Pollutant";
        String[] combinedXSymbolicValues = SampleXYSymbolicDataset.combineXSymbolicDataset((XisSymbolic)((Object)data1), (XisSymbolic)((Object)data2));
        String[] combinedYSymbolicValues = SampleXYSymbolicDataset.combineYSymbolicDataset((YisSymbolic)((Object)data1), (YisSymbolic)((Object)data2));
        CombinedDataset data = new CombinedDataset();
        data.add(data1);
        data.add(data2);
        SubSeriesDataset series0 = new SubSeriesDataset((SeriesDataset)data, 0);
        SubSeriesDataset series1 = new SubSeriesDataset((SeriesDataset)data, 1);
        HorizontalSymbolicAxis hsymbolicAxis = new HorizontalSymbolicAxis(xAxisLabel, combinedXSymbolicValues);
        VerticalSymbolicAxis vsymbolicAxis = new VerticalSymbolicAxis(yAxisLabel, combinedYSymbolicValues);
        OverlaidXYPlot mainPlot = new OverlaidXYPlot(hsymbolicAxis, vsymbolicAxis);
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(1, null);
        XYPlot subplot0 = new XYPlot(series0, null, null, renderer);
        XYPlot subplot1 = new XYPlot(series1, null, null, renderer);
        mainPlot.add(subplot0);
        mainPlot.add(subplot1);
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, mainPlot, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        ChartFrame frame = new ChartFrame(frameTitle, chart);
        frame.pack();
        RefineryUtilities.positionFrameRandomly(frame);
        frame.show();
    }

    private static void displayXYSymbolicCombinedHorizontally(String frameTitle, XYDataset data1, XYDataset data2) {
        String title = "Pollutant Horizontally Combined";
        String x1AxisLabel = "Contamination";
        String x2AxisLabel = "Type";
        String yAxisLabel = "Pollutant";
        String[] combinedYSymbolicValues = SampleXYSymbolicDataset.combineYSymbolicDataset((YisSymbolic)((Object)data1), (YisSymbolic)((Object)data2));
        CombinedDataset data = new CombinedDataset();
        data.add(data1);
        data.add(data2);
        SubSeriesDataset series0 = new SubSeriesDataset((SeriesDataset)data, 0);
        SubSeriesDataset series1 = new SubSeriesDataset((SeriesDataset)data, 1);
        JFreeChart chart = null;
        HorizontalSymbolicAxis hsymbolicAxis0 = new HorizontalSymbolicAxis(x1AxisLabel, ((XisSymbolic)((Object)data1)).getXSymbolicValues());
        HorizontalSymbolicAxis hsymbolicAxis1 = new HorizontalSymbolicAxis(x2AxisLabel, ((XisSymbolic)((Object)data2)).getXSymbolicValues());
        VerticalSymbolicAxis symbolicAxis = new VerticalSymbolicAxis(yAxisLabel, combinedYSymbolicValues);
        CombinedXYPlot mainPlot = new CombinedXYPlot(symbolicAxis, 0);
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(1, null);
        XYPlot subplot0 = new XYPlot(series0, hsymbolicAxis0, null, renderer);
        XYPlot subplot1 = new XYPlot(series1, hsymbolicAxis1, null, renderer);
        mainPlot.add(subplot0, 1);
        mainPlot.add(subplot1, 1);
        chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, mainPlot, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        ChartFrame frame = new ChartFrame(frameTitle, chart);
        frame.pack();
        RefineryUtilities.positionFrameRandomly(frame);
        frame.show();
    }

    private static void displayXYSymbolicCombinedVertically(String frameTitle, XYDataset data1, XYDataset data2) {
        String title = "Pollutant Vertically Combined";
        String xAxisLabel = "Contamination and Type";
        String yAxisLabel = "Pollutant";
        String[] combinedXSymbolicValues = SampleXYSymbolicDataset.combineXSymbolicDataset((XisSymbolic)((Object)data1), (XisSymbolic)((Object)data2));
        CombinedDataset data = new CombinedDataset();
        data.add(data1);
        data.add(data2);
        SubSeriesDataset series0 = new SubSeriesDataset((SeriesDataset)data, 0);
        SubSeriesDataset series1 = new SubSeriesDataset((SeriesDataset)data, 1);
        HorizontalSymbolicAxis hsymbolicAxis = new HorizontalSymbolicAxis(xAxisLabel, combinedXSymbolicValues);
        VerticalSymbolicAxis vsymbolicAxis0 = new VerticalSymbolicAxis(yAxisLabel, ((YisSymbolic)((Object)data1)).getYSymbolicValues());
        VerticalSymbolicAxis vsymbolicAxis1 = new VerticalSymbolicAxis(yAxisLabel, ((YisSymbolic)((Object)data2)).getYSymbolicValues());
        CombinedXYPlot mainPlot = new CombinedXYPlot(hsymbolicAxis, 1);
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(1, null);
        XYPlot subplot0 = new XYPlot(series0, null, vsymbolicAxis0, renderer);
        XYPlot subplot1 = new XYPlot(series1, null, vsymbolicAxis1, renderer);
        mainPlot.add(subplot0, 1);
        mainPlot.add(subplot1, 1);
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, mainPlot, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        ChartFrame frame = new ChartFrame(frameTitle, chart);
        frame.pack();
        RefineryUtilities.positionFrameRandomly(frame);
        frame.show();
    }

    private static Object toArray(Object arr) {
        if (arr == null) {
            return arr;
        }
        Class<?> cls = arr.getClass();
        if (!cls.isArray()) {
            return arr;
        }
        Class<?> compType = cls.getComponentType();
        int dim = 1;
        while (!compType.isPrimitive()) {
            if (!compType.isArray()) {
                return arr;
            }
            ++dim;
            compType = compType.getComponentType();
        }
        int[] length = new int[dim];
        length[0] = Array.getLength(arr);
        Object[] newarr = null;
        try {
            if (compType.equals(Integer.TYPE)) {
                newarr = (Object[])Array.newInstance(Class.forName("java.lang.Integer"), length);
            } else if (compType.equals(Double.TYPE)) {
                newarr = (Object[])Array.newInstance(Class.forName("java.lang.Double"), length);
            } else if (compType.equals(Long.TYPE)) {
                newarr = (Object[])Array.newInstance(Class.forName("java.lang.Long"), length);
            } else if (compType.equals(Float.TYPE)) {
                newarr = (Object[])Array.newInstance(Class.forName("java.lang.Float"), length);
            } else if (compType.equals(Short.TYPE)) {
                newarr = (Object[])Array.newInstance(Class.forName("java.lang.Short"), length);
            } else if (compType.equals(Byte.TYPE)) {
                newarr = (Object[])Array.newInstance(Class.forName("java.lang.Byte"), length);
            } else if (compType.equals(Character.TYPE)) {
                newarr = (Object[])Array.newInstance(Class.forName("java.lang.Character"), length);
            } else if (compType.equals(Boolean.TYPE)) {
                newarr = (Object[])Array.newInstance(Class.forName("java.lang.Boolean"), length);
            }
        }
        catch (ClassNotFoundException ex) {
            System.out.println(ex);
        }
        int i = 0;
        while (i < length[0]) {
            newarr[i] = dim != 1 ? SymbolicXYPlotDemo.toArray(Array.get(arr, i)) : Array.get(arr, i);
            ++i;
        }
        return newarr;
    }

    public static void main(String[] args) {
        SampleXYSymbolicDataset s1 = SymbolicXYPlotDemo.createXYSymbolicSample1();
        SampleXYSymbolicDataset s2 = SymbolicXYPlotDemo.createXYSymbolicSample2();
        SymbolicXYPlotDemo.displayXYSymbolic("Example 1", s1, "Pollutant", "contamination", "pollutant");
        SymbolicXYPlotDemo.displayXYSymbolic("Example 2", s2, "Pollutant", "type", "pollutant");
        SymbolicXYPlotDemo.displayXYSymbolicCombinedHorizontally("Example 3", (SampleXYSymbolicDataset)s1.clone(), (SampleXYSymbolicDataset)s2.clone());
        SymbolicXYPlotDemo.displayXYSymbolicCombinedVertically("Example 4", (SampleXYSymbolicDataset)s1.clone(), (SampleXYSymbolicDataset)s2.clone());
        SymbolicXYPlotDemo.displayXYSymbolicOverlaid("Example 5", (SampleXYSymbolicDataset)s1.clone(), (SampleXYSymbolicDataset)s2.clone());
    }
}

