/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.data.AbstractSeriesDataset;
import com.jrefinery.data.XYDataset;

public class SampleXYDataset2
extends AbstractSeriesDataset
implements XYDataset {
    private static final int SERIES_COUNT = 2;
    private static final int ITEM_COUNT = 100;
    private static final double RANGE = 200.0;
    private Double[][] xValues = new Double[2][100];
    private Double[][] yValues = new Double[2][100];

    public SampleXYDataset2() {
        int series = 0;
        while (series < 2) {
            int item = 0;
            while (item < 100) {
                double x = (Math.random() - 0.5) * 200.0;
                this.xValues[series][item] = new Double(x);
                this.yValues[series][item] = new Double((Math.random() + 0.5) * x * x + 1000.0);
                ++item;
            }
            ++series;
        }
    }

    public Number getXValue(int series, int item) {
        return this.xValues[series][item];
    }

    public Number getYValue(int series, int item) {
        return this.yValues[series][item];
    }

    public int getSeriesCount() {
        return 2;
    }

    public String getSeriesName(int series) {
        return "Sample " + series;
    }

    public int getItemCount(int series) {
        return 100;
    }

    static {
        SERIES_COUNT = 2;
        ITEM_COUNT = 100;
        RANGE = 200.0;
    }
}

