/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.ChartPanel;
import com.jrefinery.chart.CombinedXYPlot;
import com.jrefinery.chart.HorizontalDateAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.JFreeChartConstants;
import com.jrefinery.chart.StandardXYItemRenderer;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.VerticalXYBarRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.tooltips.TimeSeriesToolTipGenerator;
import com.jrefinery.data.BasicTimeSeries;
import com.jrefinery.data.Day;
import com.jrefinery.data.IntervalXYDataset;
import com.jrefinery.data.TimePeriod;
import com.jrefinery.data.TimeSeriesCollection;
import com.jrefinery.data.XYDataset;
import com.jrefinery.ui.ApplicationFrame;

public class PriceVolumeDemo
extends ApplicationFrame {
    static /* synthetic */ Class class$com$jrefinery$data$Day;

    public PriceVolumeDemo(String title) {
        super(title);
        JFreeChart chart = this.createCombinedChart();
        ChartPanel panel = new ChartPanel(chart, true, true, true, false, true);
        this.setContentPane(panel);
    }

    private JFreeChart createCombinedChart() {
        XYDataset priceData = this.createPriceDataset();
        StandardXYItemRenderer renderer1 = new StandardXYItemRenderer();
        renderer1.setToolTipGenerator(new TimeSeriesToolTipGenerator("d-MMM-yyyy", "0.00"));
        VerticalNumberAxis axis = new VerticalNumberAxis("Price");
        axis.setAutoRangeIncludesZero(false);
        XYPlot subplot1 = new XYPlot(priceData, null, axis, renderer1);
        IntervalXYDataset volumeData = this.createVolumeDataset();
        VerticalXYBarRenderer renderer2 = new VerticalXYBarRenderer(0.2);
        renderer2.setToolTipGenerator(new TimeSeriesToolTipGenerator("d-MMM-yyyy", "0.00"));
        XYPlot subplot2 = new XYPlot(volumeData, null, new VerticalNumberAxis("Volume"), renderer2);
        CombinedXYPlot plot = new CombinedXYPlot(new HorizontalDateAxis("Date"), 1);
        plot.add(subplot1, 3);
        plot.add(subplot2, 1);
        return new JFreeChart("Price / Volume Example", JFreeChartConstants.DEFAULT_TITLE_FONT, plot, true);
    }

    private XYDataset createPriceDataset() {
        BasicTimeSeries series1 = new BasicTimeSeries("Price", class$com$jrefinery$data$Day == null ? (class$com$jrefinery$data$Day = PriceVolumeDemo.class$("com.jrefinery.data.Day")) : class$com$jrefinery$data$Day);
        series1.add((TimePeriod)new Day(1, 3, 2002), 12353.3);
        series1.add((TimePeriod)new Day(4, 3, 2002), 13984.3);
        series1.add((TimePeriod)new Day(5, 3, 2002), 12999.4);
        series1.add((TimePeriod)new Day(6, 3, 2002), 14274.3);
        series1.add((TimePeriod)new Day(7, 3, 2002), 15943.5);
        series1.add((TimePeriod)new Day(8, 3, 2002), 14845.3);
        series1.add((TimePeriod)new Day(11, 3, 2002), 17232.3);
        series1.add((TimePeriod)new Day(12, 3, 2002), 14232.2);
        series1.add((TimePeriod)new Day(13, 3, 2002), 13102.2);
        series1.add((TimePeriod)new Day(14, 3, 2002), 14230.2);
        series1.add((TimePeriod)new Day(15, 3, 2002), 11435.2);
        series1.add((TimePeriod)new Day(18, 3, 2002), 14525.3);
        series1.add((TimePeriod)new Day(19, 3, 2002), 13984.3);
        series1.add((TimePeriod)new Day(20, 3, 2002), 12999.4);
        series1.add((TimePeriod)new Day(21, 3, 2002), 14274.3);
        series1.add((TimePeriod)new Day(22, 3, 2002), 15943.5);
        series1.add((TimePeriod)new Day(25, 3, 2002), 16234.6);
        series1.add((TimePeriod)new Day(26, 3, 2002), 17232.3);
        series1.add((TimePeriod)new Day(27, 3, 2002), 14232.2);
        series1.add((TimePeriod)new Day(28, 3, 2002), 13102.2);
        return new TimeSeriesCollection(series1);
    }

    private IntervalXYDataset createVolumeDataset() {
        BasicTimeSeries series2 = new BasicTimeSeries("Volume", class$com$jrefinery$data$Day == null ? (class$com$jrefinery$data$Day = PriceVolumeDemo.class$("com.jrefinery.data.Day")) : class$com$jrefinery$data$Day);
        series2.add((TimePeriod)new Day(1, 3, 2002), 500.0);
        series2.add((TimePeriod)new Day(4, 3, 2002), 100.0);
        series2.add((TimePeriod)new Day(5, 3, 2002), 350.0);
        series2.add((TimePeriod)new Day(6, 3, 2002), 975.0);
        series2.add((TimePeriod)new Day(7, 3, 2002), 675.0);
        series2.add((TimePeriod)new Day(8, 3, 2002), 525.0);
        series2.add((TimePeriod)new Day(11, 3, 2002), 675.0);
        series2.add((TimePeriod)new Day(12, 3, 2002), 700.0);
        series2.add((TimePeriod)new Day(13, 3, 2002), 250.0);
        series2.add((TimePeriod)new Day(14, 3, 2002), 225.0);
        series2.add((TimePeriod)new Day(15, 3, 2002), 425.0);
        series2.add((TimePeriod)new Day(18, 3, 2002), 600.0);
        series2.add((TimePeriod)new Day(19, 3, 2002), 300.0);
        series2.add((TimePeriod)new Day(20, 3, 2002), 325.0);
        series2.add((TimePeriod)new Day(21, 3, 2002), 925.0);
        series2.add((TimePeriod)new Day(22, 3, 2002), 525.0);
        series2.add((TimePeriod)new Day(25, 3, 2002), 775.0);
        series2.add((TimePeriod)new Day(26, 3, 2002), 725.0);
        series2.add((TimePeriod)new Day(27, 3, 2002), 125.0);
        series2.add((TimePeriod)new Day(28, 3, 2002), 150.0);
        return new TimeSeriesCollection(series2);
    }

    public static void main(String[] args) {
        PriceVolumeDemo demo = new PriceVolumeDemo("Price Volume Chart Demo");
        demo.pack();
        demo.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

