/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import java.util.Date;

public class Performance2 {
    double primitive = 42.0;
    Number object = new Double(42.0);

    public double getPrimitive() {
        return this.primitive;
    }

    public Number getPrimitiveAsObject() {
        return new Double(this.primitive);
    }

    public Number getObject() {
        return this.object;
    }

    public double getObjectAsPrimitive() {
        return this.object.doubleValue();
    }

    public void getPrimitiveLoop(int count) {
        int i = 0;
        while (i < count) {
            double d = this.getPrimitive();
            ++i;
        }
    }

    public void getPrimitiveAsObjectLoop(int count) {
        int i = 0;
        while (i < count) {
            double d = this.getPrimitiveAsObject().doubleValue();
            ++i;
        }
    }

    public void getObjectAsPrimitiveLoop(int count) {
        int i = 0;
        while (i < count) {
            double d = this.getObjectAsPrimitive();
            ++i;
        }
    }

    public void getObjectLoop(int count) {
        int i = 0;
        while (i < count) {
            double d = this.getObject().doubleValue();
            ++i;
        }
    }

    public void status(String label, Date start, Date end) {
        long elapsed = end.getTime() - start.getTime();
        System.out.println(label + start.getTime() + "-->" + end.getTime() + " = " + elapsed);
    }

    public static void main(String[] args) {
        Performance2 performance = new Performance2();
        int count = 10000000;
        int repeat = 0;
        while (repeat < 3) {
            Date s1 = new Date();
            performance.getPrimitiveLoop(count);
            Date e1 = new Date();
            performance.status("getPrimitive() : ", s1, e1);
            Date s2 = new Date();
            performance.getPrimitiveAsObjectLoop(count);
            Date e2 = new Date();
            performance.status("getPrimitiveAsObject() : ", s2, e2);
            Date s3 = new Date();
            performance.getObjectLoop(count);
            Date e3 = new Date();
            performance.status("getObject() : ", s3, e3);
            Date s4 = new Date();
            performance.getObjectAsPrimitiveLoop(count);
            Date e4 = new Date();
            performance.status("getObjectAsPrimitive() : ", s4, e4);
            System.out.println("-------------------");
            ++repeat;
        }
    }
}

