/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.ChartFrame;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.JFreeChartConstants;
import com.jrefinery.chart.MeterLegend;
import com.jrefinery.chart.MeterPlot;
import com.jrefinery.data.DefaultMeterDataset;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Insets;

public class MeterPlotDemo {
    void displayMeterChart(double value, int type) {
        JFreeChart chart = null;
        String title = "Meter Chart";
        DefaultMeterDataset data = new DefaultMeterDataset(new Double(23.0), new Double(140.0), new Double(value), "Units");
        data.setNormalRange(new Double(70.0), new Double(85.0));
        data.setWarningRange(new Double(85.0), new Double(100.0));
        data.setCriticalRange(new Double(50.0), new Double(120.0));
        data.setBorderType(2);
        MeterPlot plot = new MeterPlot(data);
        plot.setMeterAngle(270);
        plot.setDialType(type);
        plot.setInsets(new Insets(5, 5, 5, 5));
        chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, false);
        MeterLegend legend = new MeterLegend(chart, "Sample Meter");
        chart.setLegend(legend);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        ChartFrame chartFrame = new ChartFrame("Meter Chart", chart);
        chartFrame.pack();
        RefineryUtilities.positionFrameRandomly(chartFrame);
        chartFrame.setSize(250, 250);
        chartFrame.show();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Usage: java TestMeter <type> <value>");
            System.err.println("Type:  0 = DIALTYPE_PIE");
            System.err.println("Type:  1 = DIALTYPE_CIRCLE");
            System.err.println("Type:  2 = DIALTYPE_CHORD");
        }
        MeterPlotDemo h = new MeterPlotDemo();
        double val = 50.0;
        int type = 1;
        if (args.length > 0) {
            type = Integer.parseInt(args[0]);
        }
        if (args.length > 1) {
            val = new Double(args[1]);
        }
        h.displayMeterChart(val, type);
    }
}

