/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartFactory;
import com.jrefinery.chart.ChartUtilities;
import com.jrefinery.chart.HorizontalCategoryAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.data.LinearPlotFitAlgorithm;
import com.jrefinery.chart.data.MovingAveragePlotFitAlgorithm;
import com.jrefinery.chart.data.PlotFit;
import com.jrefinery.chart.demo.DemoDatasetFactory;
import com.jrefinery.chart.demo.SampleXYDataset;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.DatasetUtilities;
import com.jrefinery.data.DefaultCategoryDataset;
import com.jrefinery.data.DefaultXYDataset;
import com.jrefinery.data.HighLowDataset;
import com.jrefinery.data.PieDataset;
import com.jrefinery.data.TimeSeriesCollection;
import com.jrefinery.data.XYDataset;
import java.awt.Color;
import java.awt.GradientPaint;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JFreeChartServletDemo
extends HttpServlet {
    ServletContext context = null;

    protected Color getColor(int color) {
        switch (color % 11) {
            case 0: {
                return Color.white;
            }
            case 1: {
                return Color.black;
            }
            case 2: {
                return Color.blue;
            }
            case 3: {
                return Color.green;
            }
            case 4: {
                return Color.red;
            }
            case 5: {
                return Color.yellow;
            }
            case 6: {
                return Color.gray;
            }
            case 7: {
                return Color.orange;
            }
            case 8: {
                return Color.cyan;
            }
            case 9: {
                return Color.magenta;
            }
            case 10: {
                return Color.pink;
            }
        }
        return Color.white;
    }

    public CategoryDataset createCategoryDataset() {
        Number[][] data = new Integer[][]{{new Integer(10), new Integer(4), new Integer(15), new Integer(14)}, {new Integer(5), new Integer(7), new Integer(14), new Integer(3)}, {new Integer(6), new Integer(17), new Integer(12), new Integer(7)}, {new Integer(7), new Integer(15), new Integer(11), new Integer(0)}, {new Integer(8), new Integer(6), new Integer(10), new Integer(9)}, {new Integer(9), new Integer(8), new Integer(8), new Integer(6)}, {new Integer(10), new Integer(9), new Integer(7), new Integer(7)}, {new Integer(11), new Integer(13), new Integer(9), new Integer(9)}, {new Integer(3), new Integer(7), new Integer(11), new Integer(10)}};
        return new DefaultCategoryDataset(data);
    }

    private Date createDate(int year, int month, int day) {
        GregorianCalendar calendar = new GregorianCalendar(year, month, day);
        return calendar.getTime();
    }

    private Date createDateTime(int year, int month, int day, int hour, int minute) {
        GregorianCalendar calendar = new GregorianCalendar(year, month, day, hour, minute);
        return calendar.getTime();
    }

    public XYDataset createTestXYDataset() {
        Object[][][] data = new Object[][][]{{{this.createDateTime(2000, 9, 18, 9, 5), new Double(10921.0)}, {this.createDateTime(2000, 9, 18, 10, 6), new Double(10886.7)}, {this.createDateTime(2000, 9, 18, 11, 6), new Double(10846.6)}, {this.createDateTime(2000, 9, 18, 12, 6), new Double(10843.7)}, {this.createDateTime(2000, 9, 18, 13, 6), new Double(10841.2)}, {this.createDateTime(2000, 9, 18, 14, 6), new Double(10830.7)}, {this.createDateTime(2000, 9, 18, 15, 6), new Double(10795.8)}, {this.createDateTime(2000, 9, 18, 16, 7), new Double(10733.8)}}};
        return new DefaultXYDataset(data);
    }

    public HighLowDataset createHighLowDataset() {
        Object[][][] data = new Object[][][]{{{this.createDate(1999, 0, 4), new Double(47.0)}, {this.createDate(1999, 0, 4), new Double(33.0)}, {this.createDate(1999, 0, 4), new Double(35.0)}, {this.createDate(1999, 0, 4), new Double(33.0)}, {this.createDate(1999, 0, 5), new Double(47.0)}, {this.createDate(1999, 0, 5), new Double(32.0)}, {this.createDate(1999, 0, 5), new Double(41.0)}, {this.createDate(1999, 0, 5), new Double(37.0)}, {this.createDate(1999, 0, 6), new Double(49.0)}, {this.createDate(1999, 0, 6), new Double(43.0)}, {this.createDate(1999, 0, 6), new Double(46.0)}, {this.createDate(1999, 0, 6), new Double(48.0)}, {this.createDate(1999, 0, 7), new Double(51.0)}, {this.createDate(1999, 0, 7), new Double(39.0)}, {this.createDate(1999, 0, 7), new Double(40.0)}, {this.createDate(1999, 0, 7), new Double(47.0)}, {this.createDate(1999, 0, 8), new Double(60.0)}, {this.createDate(1999, 0, 8), new Double(40.0)}, {this.createDate(1999, 0, 8), new Double(46.0)}, {this.createDate(1999, 0, 8), new Double(53.0)}, {this.createDate(1999, 0, 9), new Double(62.0)}, {this.createDate(1999, 0, 9), new Double(55.0)}, {this.createDate(1999, 0, 9), new Double(57.0)}, {this.createDate(1999, 0, 9), new Double(61.0)}, {this.createDate(1999, 0, 10), new Double(65.0)}, {this.createDate(1999, 0, 10), new Double(56.0)}, {this.createDate(1999, 0, 10), new Double(62.0)}, {this.createDate(1999, 0, 10), new Double(59.0)}, {this.createDate(1999, 0, 11), new Double(55.0)}, {this.createDate(1999, 0, 11), new Double(43.0)}, {this.createDate(1999, 0, 11), new Double(45.0)}, {this.createDate(1999, 0, 11), new Double(47.0)}, {this.createDate(1999, 0, 12), new Double(54.0)}, {this.createDate(1999, 0, 12), new Double(33.0)}, {this.createDate(1999, 0, 12), new Double(40.0)}, {this.createDate(1999, 0, 12), new Double(51.0)}, {this.createDate(1999, 0, 13), new Double(58.0)}, {this.createDate(1999, 0, 13), new Double(42.0)}, {this.createDate(1999, 0, 13), new Double(44.0)}, {this.createDate(1999, 0, 13), new Double(57.0)}, {this.createDate(1999, 0, 14), new Double(54.0)}, {this.createDate(1999, 0, 14), new Double(38.0)}, {this.createDate(1999, 0, 14), new Double(43.0)}, {this.createDate(1999, 0, 14), new Double(52.0)}, {this.createDate(1999, 0, 15), new Double(48.0)}, {this.createDate(1999, 0, 15), new Double(41.0)}, {this.createDate(1999, 0, 15), new Double(44.0)}, {this.createDate(1999, 0, 15), new Double(41.0)}, {this.createDate(1999, 0, 17), new Double(60.0)}, {this.createDate(1999, 0, 17), new Double(30.0)}, {this.createDate(1999, 0, 17), new Double(34.0)}, {this.createDate(1999, 0, 17), new Double(44.0)}, {this.createDate(1999, 0, 18), new Double(58.0)}, {this.createDate(1999, 0, 18), new Double(44.0)}, {this.createDate(1999, 0, 18), new Double(54.0)}, {this.createDate(1999, 0, 18), new Double(56.0)}, {this.createDate(1999, 0, 19), new Double(54.0)}, {this.createDate(1999, 0, 19), new Double(32.0)}, {this.createDate(1999, 0, 19), new Double(42.0)}, {this.createDate(1999, 0, 19), new Double(53.0)}, {this.createDate(1999, 0, 20), new Double(53.0)}, {this.createDate(1999, 0, 20), new Double(39.0)}, {this.createDate(1999, 0, 20), new Double(50.0)}, {this.createDate(1999, 0, 20), new Double(49.0)}, {this.createDate(1999, 0, 21), new Double(47.0)}, {this.createDate(1999, 0, 21), new Double(38.0)}, {this.createDate(1999, 0, 21), new Double(41.0)}, {this.createDate(1999, 0, 21), new Double(40.0)}, {this.createDate(1999, 0, 22), new Double(55.0)}, {this.createDate(1999, 0, 22), new Double(37.0)}, {this.createDate(1999, 0, 22), new Double(43.0)}, {this.createDate(1999, 0, 22), new Double(45.0)}, {this.createDate(1999, 0, 23), new Double(54.0)}, {this.createDate(1999, 0, 23), new Double(42.0)}, {this.createDate(1999, 0, 23), new Double(50.0)}, {this.createDate(1999, 0, 23), new Double(42.0)}, {this.createDate(1999, 0, 24), new Double(48.0)}, {this.createDate(1999, 0, 24), new Double(37.0)}, {this.createDate(1999, 0, 24), new Double(37.0)}, {this.createDate(1999, 0, 24), new Double(47.0)}, {this.createDate(1999, 0, 25), new Double(58.0)}, {this.createDate(1999, 0, 25), new Double(33.0)}, {this.createDate(1999, 0, 25), new Double(39.0)}, {this.createDate(1999, 0, 25), new Double(41.0)}, {this.createDate(1999, 0, 26), new Double(47.0)}, {this.createDate(1999, 0, 26), new Double(31.0)}, {this.createDate(1999, 0, 26), new Double(36.0)}, {this.createDate(1999, 0, 26), new Double(41.0)}, {this.createDate(1999, 0, 27), new Double(58.0)}, {this.createDate(1999, 0, 27), new Double(44.0)}, {this.createDate(1999, 0, 27), new Double(49.0)}, {this.createDate(1999, 0, 27), new Double(44.0)}, {this.createDate(1999, 0, 28), new Double(46.0)}, {this.createDate(1999, 0, 28), new Double(41.0)}, {this.createDate(1999, 0, 28), new Double(43.0)}, {this.createDate(1999, 0, 28), new Double(44.0)}, {this.createDate(1999, 0, 29), new Double(56.0)}, {this.createDate(1999, 0, 29), new Double(39.0)}, {this.createDate(1999, 0, 29), new Double(39.0)}, {this.createDate(1999, 0, 29), new Double(51.0)}, {this.createDate(1999, 0, 30), new Double(56.0)}, {this.createDate(1999, 0, 30), new Double(39.0)}, {this.createDate(1999, 0, 30), new Double(47.0)}, {this.createDate(1999, 0, 30), new Double(49.0)}, {this.createDate(1999, 0, 31), new Double(53.0)}, {this.createDate(1999, 0, 31), new Double(39.0)}, {this.createDate(1999, 0, 31), new Double(52.0)}, {this.createDate(1999, 0, 31), new Double(47.0)}, {this.createDate(1999, 1, 1), new Double(51.0)}, {this.createDate(1999, 1, 1), new Double(30.0)}, {this.createDate(1999, 1, 1), new Double(45.0)}, {this.createDate(1999, 1, 1), new Double(47.0)}, {this.createDate(1999, 1, 2), new Double(47.0)}, {this.createDate(1999, 1, 2), new Double(30.0)}, {this.createDate(1999, 1, 2), new Double(34.0)}, {this.createDate(1999, 1, 2), new Double(46.0)}, {this.createDate(1999, 1, 3), new Double(57.0)}, {this.createDate(1999, 1, 3), new Double(37.0)}, {this.createDate(1999, 1, 3), new Double(44.0)}, {this.createDate(1999, 1, 3), new Double(56.0)}, {this.createDate(1999, 1, 4), new Double(49.0)}, {this.createDate(1999, 1, 4), new Double(40.0)}, {this.createDate(1999, 1, 4), new Double(47.0)}, {this.createDate(1999, 1, 4), new Double(44.0)}, {this.createDate(1999, 1, 5), new Double(46.0)}, {this.createDate(1999, 1, 5), new Double(38.0)}, {this.createDate(1999, 1, 5), new Double(43.0)}, {this.createDate(1999, 1, 5), new Double(40.0)}, {this.createDate(1999, 1, 6), new Double(55.0)}, {this.createDate(1999, 1, 6), new Double(38.0)}, {this.createDate(1999, 1, 6), new Double(39.0)}, {this.createDate(1999, 1, 6), new Double(53.0)}, {this.createDate(1999, 1, 7), new Double(50.0)}, {this.createDate(1999, 1, 7), new Double(33.0)}, {this.createDate(1999, 1, 7), new Double(37.0)}, {this.createDate(1999, 1, 7), new Double(37.0)}, {this.createDate(1999, 1, 8), new Double(59.0)}, {this.createDate(1999, 1, 8), new Double(34.0)}, {this.createDate(1999, 1, 8), new Double(57.0)}, {this.createDate(1999, 1, 8), new Double(43.0)}, {this.createDate(1999, 1, 9), new Double(48.0)}, {this.createDate(1999, 1, 9), new Double(39.0)}, {this.createDate(1999, 1, 9), new Double(46.0)}, {this.createDate(1999, 1, 9), new Double(47.0)}, {this.createDate(1999, 1, 10), new Double(55.0)}, {this.createDate(1999, 1, 10), new Double(30.0)}, {this.createDate(1999, 1, 10), new Double(37.0)}, {this.createDate(1999, 1, 10), new Double(30.0)}, {this.createDate(1999, 1, 11), new Double(60.0)}, {this.createDate(1999, 1, 11), new Double(32.0)}, {this.createDate(1999, 1, 11), new Double(56.0)}, {this.createDate(1999, 1, 11), new Double(36.0)}, {this.createDate(1999, 1, 12), new Double(56.0)}, {this.createDate(1999, 1, 12), new Double(42.0)}, {this.createDate(1999, 1, 12), new Double(53.0)}, {this.createDate(1999, 1, 12), new Double(54.0)}, {this.createDate(1999, 1, 13), new Double(49.0)}, {this.createDate(1999, 1, 13), new Double(42.0)}, {this.createDate(1999, 1, 13), new Double(45.0)}, {this.createDate(1999, 1, 13), new Double(42.0)}, {this.createDate(1999, 1, 14), new Double(55.0)}, {this.createDate(1999, 1, 14), new Double(42.0)}, {this.createDate(1999, 1, 14), new Double(47.0)}, {this.createDate(1999, 1, 14), new Double(54.0)}, {this.createDate(1999, 1, 15), new Double(49.0)}, {this.createDate(1999, 1, 15), new Double(35.0)}, {this.createDate(1999, 1, 15), new Double(38.0)}, {this.createDate(1999, 1, 15), new Double(35.0)}, {this.createDate(1999, 1, 16), new Double(47.0)}, {this.createDate(1999, 1, 16), new Double(38.0)}, {this.createDate(1999, 1, 16), new Double(43.0)}, {this.createDate(1999, 1, 16), new Double(42.0)}, {this.createDate(1999, 1, 17), new Double(53.0)}, {this.createDate(1999, 1, 17), new Double(42.0)}, {this.createDate(1999, 1, 17), new Double(47.0)}, {this.createDate(1999, 1, 17), new Double(48.0)}, {this.createDate(1999, 1, 18), new Double(47.0)}, {this.createDate(1999, 1, 18), new Double(44.0)}, {this.createDate(1999, 1, 18), new Double(46.0)}, {this.createDate(1999, 1, 18), new Double(44.0)}, {this.createDate(1999, 1, 19), new Double(46.0)}, {this.createDate(1999, 1, 19), new Double(40.0)}, {this.createDate(1999, 1, 19), new Double(43.0)}, {this.createDate(1999, 1, 19), new Double(44.0)}, {this.createDate(1999, 1, 20), new Double(48.0)}, {this.createDate(1999, 1, 20), new Double(41.0)}, {this.createDate(1999, 1, 20), new Double(46.0)}, {this.createDate(1999, 1, 20), new Double(41.0)}}};
        return null;
    }

    protected JFreeChart createChart(int type, int initGradColor, int finalGradColor) {
        CategoryDataset categoryData = this.createCategoryDataset();
        try {
            switch (type) {
                case 1: {
                    JFreeChart chart = ChartFactory.createVerticalBarChart("Vertical Bar Chart", "Categories", "Values", categoryData, true);
                    chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, this.getColor(initGradColor), 1000.0f, 0.0f, this.getColor(finalGradColor)));
                    CategoryPlot plot = chart.getCategoryPlot();
                    HorizontalCategoryAxis axis = (HorizontalCategoryAxis)plot.getDomainAxis();
                    axis.setVerticalCategoryLabels(true);
                    return chart;
                }
                case 2: {
                    JFreeChart chart = ChartFactory.createHorizontalBarChart("Horizontal Bar Chart", "Categories", "Values", categoryData, true);
                    chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, this.getColor(initGradColor), 1000.0f, 0.0f, this.getColor(finalGradColor)));
                    return chart;
                }
                case 3: {
                    JFreeChart chart = ChartFactory.createLineChart("Line Chart", "Categories", "Values", categoryData, true);
                    chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, this.getColor(initGradColor), 1000.0f, 0.0f, this.getColor(finalGradColor)));
                    return chart;
                }
                case 4: {
                    SampleXYDataset xyData = new SampleXYDataset();
                    JFreeChart chart = ChartFactory.createXYChart("XY Plot", "X", "Y", xyData, true);
                    chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, this.getColor(initGradColor), 1000.0f, 0.0f, this.getColor(finalGradColor)));
                    Plot xyPlot = chart.getPlot();
                    return chart;
                }
                case 5: {
                    TimeSeriesCollection xyData1 = DemoDatasetFactory.createTimeSeriesCollection3();
                    JFreeChart chart = ChartFactory.createTimeSeriesChart("Time Series Chart", "Date", "USD per GBP", xyData1, true);
                    chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, this.getColor(initGradColor), 1000.0f, 0.0f, this.getColor(finalGradColor)));
                    XYPlot plot5 = chart.getXYPlot();
                    VerticalNumberAxis axis5 = (VerticalNumberAxis)plot5.getRangeAxis();
                    axis5.setAutoRangeIncludesZero(false);
                    plot5.setDataset(xyData1);
                    return chart;
                }
                case 6: {
                    categoryData = this.createCategoryDataset();
                    PieDataset pieData = DatasetUtilities.createPieDataset(categoryData, 0);
                    JFreeChart chart = ChartFactory.createPieChart("Pie Chart", pieData, true);
                    chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, this.getColor(initGradColor), 1000.0f, 0.0f, this.getColor(finalGradColor)));
                    return chart;
                }
                case 7: {
                    HighLowDataset data7 = this.createHighLowDataset();
                    JFreeChart chart = ChartFactory.createHighLowChart("High-Low-Open-Close IBM", "Date", "Price", data7, true);
                    chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, this.getColor(initGradColor), 1000.0f, 0.0f, this.getColor(finalGradColor)));
                    XYPlot plot7 = chart.getXYPlot();
                    ValueAxis axis7 = plot7.getRangeAxis();
                    axis7.setLabel("Price in ($) per share");
                    return chart;
                }
                case 8: {
                    XYDataset xyData2 = DemoDatasetFactory.createTimeSeriesCollection3();
                    MovingAveragePlotFitAlgorithm mavg = new MovingAveragePlotFitAlgorithm();
                    mavg.setPeriod(30);
                    PlotFit pf = new PlotFit(xyData2, mavg);
                    xyData2 = pf.getFit();
                    JFreeChart chart = ChartFactory.createTimeSeriesChart("Moving Average", "Date", "Value", xyData2, true);
                    chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, this.getColor(initGradColor), 1000.0f, 0.0f, this.getColor(finalGradColor)));
                    XYPlot plot8 = chart.getXYPlot();
                    NumberAxis axis8 = (NumberAxis)plot8.getRangeAxis();
                    axis8.setLabel("USD per GBP");
                    axis8.setAutoRangeIncludesZero(false);
                    return chart;
                }
                case 9: {
                    XYDataset data9 = DemoDatasetFactory.createTimeSeriesCollection2();
                    PlotFit pf = new PlotFit(data9, new LinearPlotFitAlgorithm());
                    data9 = pf.getFit();
                    JFreeChart chart = ChartFactory.createTimeSeriesChart("Linear Fit", "Date", "Value", data9, true);
                    XYPlot plot9 = chart.getXYPlot();
                    NumberAxis axis9 = (NumberAxis)plot9.getRangeAxis();
                    axis9.setLabel("USD per GBP");
                    axis9.setAutoRangeIncludesZero(false);
                    return chart;
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.context = config.getServletContext();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("image/jpeg");
        int type = 1;
        try {
            type = Integer.parseInt(request.getParameter("type"));
        }
        catch (Exception e) {
            // empty catch block
        }
        int initGradColor = 0;
        int finalGradColor = 0;
        try {
            initGradColor = Integer.parseInt(request.getParameter("initGradColor"));
            finalGradColor = Integer.parseInt(request.getParameter("finalGradColor"));
        }
        catch (Exception e) {
            // empty catch block
        }
        JFreeChart chart = this.createChart(type, initGradColor, finalGradColor);
        int width = 400;
        int height = 300;
        try {
            width = Integer.parseInt(request.getParameter("width"));
            height = Integer.parseInt(request.getParameter("height"));
        }
        catch (Exception e) {
            // empty catch block
        }
        ServletOutputStream out = response.getOutputStream();
        ChartUtilities.writeChartAsJPEG((OutputStream)out, chart, width, height);
        out.close();
    }
}

