/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartFactory;
import com.jrefinery.chart.ChartFrame;
import com.jrefinery.chart.ChartPanel;
import com.jrefinery.chart.CombinedXYPlot;
import com.jrefinery.chart.HighLowRenderer;
import com.jrefinery.chart.HorizontalCategoryAxis;
import com.jrefinery.chart.HorizontalDateAxis;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.JFreeChartConstants;
import com.jrefinery.chart.MeterPlot;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.chart.OverlaidXYPlot;
import com.jrefinery.chart.PiePlot;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.Spacer;
import com.jrefinery.chart.TextTitle;
import com.jrefinery.chart.ThermometerPlot;
import com.jrefinery.chart.TickUnits;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalLogarithmicAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.VerticalXYBarRenderer;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.data.MovingAveragePlotFitAlgorithm;
import com.jrefinery.chart.data.PlotFit;
import com.jrefinery.chart.demo.DemoDatasetFactory;
import com.jrefinery.chart.demo.DescriptionPanel;
import com.jrefinery.chart.demo.EmptyXYDataset;
import com.jrefinery.chart.demo.SampleXYDataset;
import com.jrefinery.chart.demo.SampleXYDataset2;
import com.jrefinery.chart.demo.SampleXYDatasetThread;
import com.jrefinery.chart.tooltips.HighLowToolTipGenerator;
import com.jrefinery.chart.tooltips.TimeSeriesToolTipGenerator;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.CombinedDataset;
import com.jrefinery.data.DatasetUtilities;
import com.jrefinery.data.DefaultMeterDataset;
import com.jrefinery.data.HighLowDataset;
import com.jrefinery.data.PieDataset;
import com.jrefinery.data.SeriesDataset;
import com.jrefinery.data.SignalsDataset;
import com.jrefinery.data.SubSeriesDataset;
import com.jrefinery.data.TimeSeriesCollection;
import com.jrefinery.data.WindDataset;
import com.jrefinery.data.XYDataset;
import com.jrefinery.layout.LCBLayout;
import com.jrefinery.ui.RefineryUtilities;
import com.jrefinery.ui.about.AboutFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Image;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class JFreeChartDemo
extends JFrame
implements ActionListener,
WindowListener {
    public static final String EXIT_COMMAND = "EXIT";
    public static final String ABOUT_COMMAND = "ABOUT";
    public static final String[][] CHART_COMMANDS;
    private JFreeChart[] chart = new JFreeChart[CHART_COMMANDS.length];
    private ChartFrame[] frame = new ChartFrame[CHART_COMMANDS.length];
    private JPanel[] panels = null;
    public static final Dimension PREFERRED_SIZE;
    private AboutFrame aboutFrame;
    private JTabbedPane tabbedPane;
    private ResourceBundle resources;
    static /* synthetic */ Class class$com$jrefinery$chart$JFreeChart;

    public JFreeChartDemo() {
        super(JFreeChart.INFO.getName() + " " + JFreeChart.INFO.getVersion() + " Demo");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JFreeChartDemo.this.dispose();
                System.exit(0);
            }
        });
        String baseResourceClass = "com.jrefinery.chart.demo.resources.DemoResources";
        this.resources = ResourceBundle.getBundle(baseResourceClass);
        JMenuBar menuBar = this.createMenuBar(this.resources);
        this.setJMenuBar(menuBar);
        JPanel content = new JPanel(new BorderLayout());
        content.add(this.createTabbedPane(this.resources));
        this.setContentPane(content);
    }

    public Dimension getPreferredSize() {
        return PREFERRED_SIZE;
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals(EXIT_COMMAND)) {
            this.attemptExit();
        } else if (command.equals(ABOUT_COMMAND)) {
            this.about();
        } else {
            int chartnum = -1;
            int i = CHART_COMMANDS.length;
            while (i > 0) {
                if (!command.equals(CHART_COMMANDS[--i][0])) continue;
                chartnum = i;
                i = 0;
            }
            if (chartnum >= 0 && chartnum < this.frame.length) {
                if (this.frame[chartnum] == null) {
                    this.getChart(chartnum);
                    String str = this.resources.getString(CHART_COMMANDS[chartnum][2] + ".title");
                    this.frame[chartnum] = new ChartFrame(str, this.chart[chartnum]);
                    this.frame[chartnum].pack();
                    RefineryUtilities.positionFrameRandomly(this.frame[chartnum]);
                    try {
                        str = this.resources.getString(CHART_COMMANDS[chartnum][2] + ".zoom");
                        if (str != null && str.toLowerCase().equals("true")) {
                            ChartPanel panel = this.frame[chartnum].getChartPanel();
                            panel.setMouseZoomable(true);
                            panel.setHorizontalAxisTrace(true);
                            panel.setVerticalAxisTrace(true);
                        }
                    }
                    catch (Exception ex) {
                        System.out.println(ex.toString());
                    }
                    this.frame[chartnum].show();
                } else {
                    this.frame[chartnum].show();
                    this.frame[chartnum].requestFocus();
                }
            }
        }
    }

    public JFreeChart getChart(int i) {
        if (i < 0 && i >= this.chart.length) {
            i = 0;
        }
        if (this.chart[i] == null) {
            try {
                Method method = this.getClass().getDeclaredMethod(CHART_COMMANDS[i][1], null);
                this.chart[i] = (JFreeChart)method.invoke((Object)this, null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.chart[i];
    }

    private void attemptExit() {
        String title = this.resources.getString("dialog.exit.title");
        String message = this.resources.getString("dialog.exit.message");
        int result = JOptionPane.showConfirmDialog(this, message, title, 0, 3);
        if (result == 0) {
            this.dispose();
            System.exit(0);
        }
    }

    public JFreeChart createHorizontalBarChart() {
        String title = this.resources.getString("bar.horizontal.title");
        String domain = this.resources.getString("bar.horizontal.domain");
        String range = this.resources.getString("bar.horizontal.range");
        CategoryDataset data = DemoDatasetFactory.createCategoryDataset();
        JFreeChart chart = ChartFactory.createHorizontalBarChart(title, domain, range, data, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.orange));
        CategoryPlot plot = chart.getCategoryPlot();
        NumberAxis axis = (NumberAxis)plot.getRangeAxis();
        axis.setStandardTickUnits(TickUnits.createIntegerTickUnits());
        axis.setCrosshairVisible(false);
        axis.setInverted(true);
        return chart;
    }

    public JFreeChart createStackedHorizontalBarChart() {
        String title = this.resources.getString("bar.horizontal-stacked.title");
        String domain = this.resources.getString("bar.horizontal-stacked.domain");
        String range = this.resources.getString("bar.horizontal-stacked.range");
        CategoryDataset data = DemoDatasetFactory.createCategoryDataset();
        JFreeChart chart = ChartFactory.createStackedHorizontalBarChart(title, domain, range, data, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.blue));
        return chart;
    }

    public JFreeChart createVerticalBarChart() {
        String title = this.resources.getString("bar.vertical.title");
        String domain = this.resources.getString("bar.vertical.domain");
        String range = this.resources.getString("bar.vertical.range");
        CategoryDataset data = DemoDatasetFactory.createCategoryDataset();
        JFreeChart chart = ChartFactory.createVerticalBarChart(title, domain, range, data, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.red));
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setForegroundAlpha(0.9f);
        NumberAxis verticalAxis = (NumberAxis)plot.getRangeAxis();
        verticalAxis.setStandardTickUnits(TickUnits.createIntegerTickUnits());
        return chart;
    }

    public JFreeChart createVertical3DBarChart() {
        String title = this.resources.getString("bar.vertical3D.title");
        String domain = this.resources.getString("bar.vertical3D.domain");
        String range = this.resources.getString("bar.vertical3D.range");
        CategoryDataset data = DemoDatasetFactory.createCategoryDataset();
        JFreeChart chart = ChartFactory.createVerticalBarChart3D(title, domain, range, data, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.blue));
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setForegroundAlpha(0.75f);
        NumberAxis axis = (NumberAxis)plot.getRangeAxis();
        return chart;
    }

    public JFreeChart createVerticalStackedBarChart() {
        String title = this.resources.getString("bar.vertical-stacked.title");
        String domain = this.resources.getString("bar.vertical-stacked.domain");
        String range = this.resources.getString("bar.vertical-stacked.range");
        CategoryDataset data = DemoDatasetFactory.createCategoryDataset();
        JFreeChart chart = ChartFactory.createStackedVerticalBarChart(title, domain, range, data, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.red));
        return chart;
    }

    public JFreeChart createVerticalStacked3DBarChart() {
        String title = this.resources.getString("bar.vertical-stacked3D.title");
        String domain = this.resources.getString("bar.vertical-stacked3D.domain");
        String range = this.resources.getString("bar.vertical-stacked3D.range");
        CategoryDataset data = DemoDatasetFactory.createCategoryDataset();
        JFreeChart chart = ChartFactory.createStackedVerticalBarChart3D(title, domain, range, data, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.red));
        return chart;
    }

    public JFreeChart createPieChartOne() {
        String title = this.resources.getString("pie.pie1.title");
        CategoryDataset data = DemoDatasetFactory.createCategoryDataset();
        PieDataset extracted = DatasetUtilities.createPieDataset(data, 0);
        JFreeChart chart = ChartFactory.createPieChart(title, extracted, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.orange));
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setCircular(false);
        plot.setRadiusPercent(0.6);
        plot.setExplodePercent(1, 1.0);
        return chart;
    }

    public JFreeChart createPieChartTwo() {
        ImageIcon icon = new ImageIcon((class$com$jrefinery$chart$JFreeChart == null ? (class$com$jrefinery$chart$JFreeChart = JFreeChartDemo.class$("com.jrefinery.chart.JFreeChart")) : class$com$jrefinery$chart$JFreeChart).getResource("gorilla.jpg"));
        Image bgimage = icon.getImage();
        String title = this.resources.getString("pie.pie2.title");
        CategoryDataset data = DemoDatasetFactory.createCategoryDataset();
        Object category = data.getCategories().get(1);
        PieDataset extracted = DatasetUtilities.createPieDataset(data, category);
        JFreeChart chart = ChartFactory.createPieChart(title, extracted, true);
        chart.setBackgroundPaint(Color.lightGray);
        PiePlot pie = (PiePlot)chart.getPlot();
        pie.setSectionLabelType(5);
        pie.setBackgroundImage(bgimage);
        pie.setBackgroundPaint(Color.white);
        pie.setBackgroundAlpha(0.6f);
        pie.setForegroundAlpha(0.75f);
        return chart;
    }

    public JFreeChart createXYPlot() {
        String title = this.resources.getString("xyplot.sample1.title");
        String domain = this.resources.getString("xyplot.sample1.domain");
        String range = this.resources.getString("xyplot.sample1.range");
        XYDataset data = DemoDatasetFactory.createSampleXYDataset();
        JFreeChart chart = ChartFactory.createXYChart(title, domain, range, data, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.green));
        return chart;
    }

    public JFreeChart createTimeSeries1Chart() {
        String title = this.resources.getString("timeseries.sample1.title");
        String subtitle = this.resources.getString("timeseries.sample1.subtitle");
        String domain = this.resources.getString("timeseries.sample1.domain");
        String range = this.resources.getString("timeseries.sample1.range");
        String copyrightStr = this.resources.getString("timeseries.sample1.copyright");
        TimeSeriesCollection data = DemoDatasetFactory.createTimeSeriesCollection3();
        JFreeChart chart = ChartFactory.createTimeSeriesChart(title, domain, range, data, true);
        TextTitle title2 = new TextTitle(subtitle, new Font("SansSerif", 0, 12));
        title2.setSpacer(new Spacer(0, 0.05, 0.05, 0.05, 0.0));
        chart.addTitle(title2);
        TextTitle copyright = new TextTitle(copyrightStr, new Font("SansSerif", 0, 9));
        copyright.setPosition(1);
        copyright.setHorizontalAlignment(2);
        chart.addTitle(copyright);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        XYPlot plot = chart.getXYPlot();
        HorizontalDateAxis axis = (HorizontalDateAxis)plot.getDomainAxis();
        axis.setVerticalTickLabels(true);
        return chart;
    }

    public JFreeChart createTimeSeries2Chart() {
        String title = this.resources.getString("timeseries.sample2.title");
        String subtitleStr = this.resources.getString("timeseries.sample2.subtitle");
        String domain = this.resources.getString("timeseries.sample2.domain");
        String range = this.resources.getString("timeseries.sample2.range");
        TimeSeriesCollection data = DemoDatasetFactory.createTimeSeriesCollection4();
        JFreeChart chart = ChartFactory.createTimeSeriesChart(title, domain, range, data, true);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addTitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        Plot plot = chart.getPlot();
        VerticalLogarithmicAxis vla = new VerticalLogarithmicAxis(range);
        chart.getXYPlot().setRangeAxis(vla);
        return chart;
    }

    public JFreeChart createTimeSeriesWithMAChart() {
        String title = this.resources.getString("timeseries.sample3.title");
        String domain = this.resources.getString("timeseries.sample3.domain");
        String range = this.resources.getString("timeseries.sample3.range");
        String subtitleStr = this.resources.getString("timeseries.sample3.subtitle");
        XYDataset data = DemoDatasetFactory.createTimeSeriesCollection2();
        MovingAveragePlotFitAlgorithm mavg = new MovingAveragePlotFitAlgorithm();
        mavg.setPeriod(30);
        PlotFit pf = new PlotFit(data, mavg);
        data = pf.getFit();
        JFreeChart chart = ChartFactory.createTimeSeriesChart(title, domain, range, data, true);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addTitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return chart;
    }

    public JFreeChart createHighLowChart() {
        String title = this.resources.getString("timeseries.highlow.title");
        String domain = this.resources.getString("timeseries.highlow.domain");
        String range = this.resources.getString("timeseries.highlow.range");
        String subtitleStr = this.resources.getString("timeseries.highlow.subtitle");
        HighLowDataset data = DemoDatasetFactory.createSampleHighLowDataset();
        JFreeChart chart = ChartFactory.createHighLowChart(title, domain, range, data, true);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addTitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.magenta));
        return chart;
    }

    public JFreeChart createCandlestickChart() {
        String title = this.resources.getString("timeseries.candlestick.title");
        String domain = this.resources.getString("timeseries.candlestick.domain");
        String range = this.resources.getString("timeseries.candlestick.range");
        String subtitleStr = this.resources.getString("timeseries.candlestick.subtitle");
        HighLowDataset data = DemoDatasetFactory.createSampleHighLowDataset();
        JFreeChart chart = ChartFactory.createCandlestickChart(title, domain, range, data, false);
        chart.getPlot().setSeriesPaint(new Paint[]{Color.blue});
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addTitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.green));
        return chart;
    }

    public JFreeChart createSignalChart() {
        String title = this.resources.getString("timeseries.signal.title");
        String domain = this.resources.getString("timeseries.signal.domain");
        String range = this.resources.getString("timeseries.signal.range");
        String subtitleStr = this.resources.getString("timeseries.signal.subtitle");
        SignalsDataset data = DemoDatasetFactory.createSampleSignalDataset();
        JFreeChart chart = ChartFactory.createSignalChart(title, domain, range, data, true);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addTitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return chart;
    }

    public JFreeChart createThermometerChart() {
        String title = this.resources.getString("meter.thermo.title");
        String subtitleStr = this.resources.getString("meter.thermo.subtitle");
        String units = this.resources.getString("meter.thermo.units");
        DefaultMeterDataset data = DemoDatasetFactory.createMeterDataset();
        data.setValue(new Double(34.0));
        ThermometerPlot plot = new ThermometerPlot(data);
        plot.setUnits(units);
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, false);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addTitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return chart;
    }

    public JFreeChart createMeterChart() {
        String title = this.resources.getString("meter.meter.title");
        String subtitleStr = this.resources.getString("meter.meter.subtitle");
        String units = this.resources.getString("meter.meter.units");
        DefaultMeterDataset data = DemoDatasetFactory.createMeterDataset();
        data.setUnits(units);
        MeterPlot meterplot = new MeterPlot(data);
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, meterplot, false);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addTitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return chart;
    }

    public JFreeChart createWindPlot() {
        String title = this.resources.getString("other.wind.title");
        String domain = this.resources.getString("other.wind.domain");
        String range = this.resources.getString("other.wind.range");
        WindDataset data = DemoDatasetFactory.createWindDataset1();
        JFreeChart chart = ChartFactory.createWindPlot(title, domain, range, data, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.green));
        return chart;
    }

    public JFreeChart createScatterPlot() {
        String title = this.resources.getString("other.scatter.title");
        String domain = this.resources.getString("other.scatter.domain");
        String range = this.resources.getString("other.scatter.range");
        SampleXYDataset2 data = new SampleXYDataset2();
        JFreeChart chart = ChartFactory.createScatterPlot(title, domain, range, data, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.green));
        XYPlot plot = (XYPlot)chart.getPlot();
        ValueAxis domainAxis = plot.getDomainAxis();
        domainAxis.setCrosshairVisible(true);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setCrosshairVisible(true);
        rangeAxis.setAutoRangeIncludesZero(false);
        return chart;
    }

    public JFreeChart createLineChart() {
        String title = this.resources.getString("other.line.title");
        String domain = this.resources.getString("other.line.domain");
        String range = this.resources.getString("other.line.range");
        CategoryDataset data = DemoDatasetFactory.createCategoryDataset();
        JFreeChart chart = ChartFactory.createLineChart(title, domain, range, data, true);
        ImageIcon icon = new ImageIcon((class$com$jrefinery$chart$JFreeChart == null ? (class$com$jrefinery$chart$JFreeChart = JFreeChartDemo.class$("com.jrefinery.chart.JFreeChart")) : class$com$jrefinery$chart$JFreeChart).getResource("gorilla.jpg"));
        chart.setBackgroundImage(icon.getImage());
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.green));
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setBackgroundAlpha(0.65f);
        HorizontalCategoryAxis axis = (HorizontalCategoryAxis)plot.getDomainAxis();
        axis.setVerticalCategoryLabels(true);
        return chart;
    }

    public JFreeChart createVerticalXYBarChart() {
        String title = this.resources.getString("other.xybar.title");
        String domain = this.resources.getString("other.xybar.domain");
        String range = this.resources.getString("other.xybar.range");
        TimeSeriesCollection data = DemoDatasetFactory.createTimeSeriesCollection1();
        JFreeChart chart = ChartFactory.createVerticalXYBarChart(title, domain, range, data, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.blue));
        XYItemRenderer renderer = chart.getXYPlot().getItemRenderer();
        renderer.setToolTipGenerator(new TimeSeriesToolTipGenerator());
        return chart;
    }

    public JFreeChart createNullXYPlot() {
        String title = this.resources.getString("test.null.title");
        String domain = this.resources.getString("test.null.domain");
        String range = this.resources.getString("test.null.range");
        XYDataset data = null;
        JFreeChart chart = ChartFactory.createXYChart(title, domain, range, data, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.red));
        return chart;
    }

    public JFreeChart createXYPlotZeroData() {
        String title = this.resources.getString("test.zero.title");
        String domain = this.resources.getString("test.zero.domain");
        String range = this.resources.getString("test.zero.range");
        EmptyXYDataset data = new EmptyXYDataset();
        JFreeChart chart = ChartFactory.createXYChart(title, domain, range, data, true);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.red));
        return chart;
    }

    public JFreeChart createTimeSeriesChartInScrollPane() {
        String title = this.resources.getString("test.scroll.title");
        String domain = this.resources.getString("test.scroll.domain");
        String range = this.resources.getString("test.scroll.range");
        String subtitleStr = this.resources.getString("test.scroll.subtitle");
        TimeSeriesCollection data = DemoDatasetFactory.createTimeSeriesCollection2();
        JFreeChart chart = ChartFactory.createTimeSeriesChart(title, domain, range, data, true);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addTitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.gray));
        Plot plot = chart.getPlot();
        return chart;
    }

    public JFreeChart createSingleSeriesBarChart() {
        String title = this.resources.getString("test.single.title");
        String domain = this.resources.getString("test.single.domain");
        String range = this.resources.getString("test.single.range");
        String subtitle1Str = this.resources.getString("test.single.subtitle1");
        String subtitle2Str = this.resources.getString("test.single.subtitle2");
        CategoryDataset data = DemoDatasetFactory.createSingleSeriesCategoryDataset();
        JFreeChart chart = ChartFactory.createHorizontalBarChart(title, domain, range, data, true);
        chart.addTitle(new TextTitle(subtitle1Str));
        chart.addTitle(new TextTitle(subtitle2Str));
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.red));
        return chart;
    }

    public JFreeChart createDynamicXYChart() {
        String title = this.resources.getString("test.dynamic.title");
        String domain = this.resources.getString("test.dynamic.domain");
        String range = this.resources.getString("test.dynamic.range");
        SampleXYDataset data = new SampleXYDataset();
        JFreeChart chart = ChartFactory.createXYChart(title, domain, range, data, true);
        SampleXYDatasetThread update = new SampleXYDatasetThread(data);
        Thread thread = new Thread(update);
        thread.start();
        return chart;
    }

    public JFreeChart createOverlaidChart() {
        String title = this.resources.getString("combined.overlaid.title");
        String subtitleStr = this.resources.getString("combined.overlaid.subtitle");
        String domain = this.resources.getString("combined.overlaid.domain");
        String range = this.resources.getString("combined.overlaid.range");
        HighLowDataset highLowData = DemoDatasetFactory.createSampleHighLowDataset();
        MovingAveragePlotFitAlgorithm mavg = new MovingAveragePlotFitAlgorithm();
        mavg.setPeriod(5);
        PlotFit pf = new PlotFit(highLowData, mavg);
        XYDataset maData = pf.getFit();
        OverlaidXYPlot overlaidPlot = new OverlaidXYPlot("Date", "Price");
        overlaidPlot.setDomainAxis(new HorizontalDateAxis("Date"));
        HighLowRenderer renderer1 = new HighLowRenderer(new HighLowToolTipGenerator());
        XYPlot subplot1 = new XYPlot(highLowData, null, null, renderer1);
        overlaidPlot.add(subplot1);
        SubSeriesDataset data2 = new SubSeriesDataset((SeriesDataset)maData, 1);
        XYPlot subplot2 = new XYPlot(data2, null, null);
        subplot2.getItemRenderer().setToolTipGenerator(new TimeSeriesToolTipGenerator("d-MMM-yyyy", "0.00"));
        overlaidPlot.add(subplot2);
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, overlaidPlot, true);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addTitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return chart;
    }

    public JFreeChart createHorizontallyCombinedChart() {
        String title = this.resources.getString("combined.horizontal.title");
        String subtitleStr = this.resources.getString("combined.horizontal.subtitle");
        String[] domains = this.resources.getStringArray("combined.horizontal.domains");
        String range = this.resources.getString("combined.horizontal.range");
        MovingAveragePlotFitAlgorithm mavg = new MovingAveragePlotFitAlgorithm();
        mavg.setPeriod(30);
        PlotFit pf = new PlotFit(DemoDatasetFactory.createTimeSeriesCollection2(), mavg);
        XYDataset tempDataset = pf.getFit();
        CombinedDataset data = new CombinedDataset();
        data.add(tempDataset);
        SubSeriesDataset series0 = new SubSeriesDataset((SeriesDataset)data, 0);
        SubSeriesDataset series1 = new SubSeriesDataset((SeriesDataset)data, 1);
        JFreeChart chart = null;
        VerticalNumberAxis valueAxis = new VerticalNumberAxis(range);
        valueAxis.setAutoRangeIncludesZero(false);
        valueAxis.setCrosshairVisible(false);
        CombinedXYPlot multiPlot = new CombinedXYPlot(valueAxis, 0);
        int[] weight = new int[]{1, 1, 1};
        XYPlot subplot1 = new XYPlot(series0, new HorizontalDateAxis("Date"), null);
        multiPlot.add(subplot1, weight[0]);
        XYPlot subplot2 = new XYPlot(data, new HorizontalDateAxis("Date"), null);
        multiPlot.add(subplot2, weight[1]);
        XYPlot subplot3 = new XYPlot(series0, new HorizontalDateAxis("Date"), null, new VerticalXYBarRenderer(0.2));
        multiPlot.add(subplot3, weight[2]);
        chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, multiPlot, true);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addTitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return chart;
    }

    public JFreeChart createVerticallyCombinedChart() {
        String title = this.resources.getString("combined.vertical.title");
        String subtitleStr = this.resources.getString("combined.vertical.subtitle");
        String domain = this.resources.getString("combined.vertical.domain");
        String[] ranges = this.resources.getStringArray("combined.vertical.ranges");
        MovingAveragePlotFitAlgorithm mavg = new MovingAveragePlotFitAlgorithm();
        mavg.setPeriod(30);
        PlotFit pf = new PlotFit(DemoDatasetFactory.createTimeSeriesCollection2(), mavg);
        XYDataset tempDataset = pf.getFit();
        CombinedDataset data = new CombinedDataset();
        data.add(tempDataset);
        data.add(DemoDatasetFactory.createSampleHighLowDataset());
        SubSeriesDataset series0 = new SubSeriesDataset((SeriesDataset)data, 0);
        SubSeriesDataset series1 = new SubSeriesDataset((SeriesDataset)data, 1);
        SubSeriesDataset series2 = new SubSeriesDataset((SeriesDataset)data, 2);
        CombinedDataset data0 = new CombinedDataset(new SeriesDataset[]{series0});
        CombinedDataset data1 = new CombinedDataset(new SeriesDataset[]{series0, series1});
        CombinedDataset data2 = new CombinedDataset(new SeriesDataset[]{series2});
        HorizontalDateAxis timeAxis = new HorizontalDateAxis(domain);
        timeAxis.setCrosshairVisible(false);
        CombinedXYPlot multiPlot = new CombinedXYPlot(timeAxis, 1);
        int[] weight = new int[]{1, 1, 1, 1};
        XYPlot subplot1 = new XYPlot(data0, null, new VerticalNumberAxis("Value"));
        NumberAxis range1 = (NumberAxis)subplot1.getRangeAxis();
        range1.setAutoRangeIncludesZero(false);
        multiPlot.add(subplot1, weight[0]);
        XYPlot subplot2 = new XYPlot(data1, null, new VerticalNumberAxis("Value"));
        NumberAxis range2 = (NumberAxis)subplot2.getRangeAxis();
        range2.setAutoRangeIncludesZero(false);
        multiPlot.add(subplot2, weight[1]);
        XYPlot subplot3 = new XYPlot(data2, null, new VerticalNumberAxis("Value"));
        HighLowRenderer renderer3 = new HighLowRenderer();
        subplot3.setXYItemRenderer(renderer3);
        NumberAxis range3 = (NumberAxis)subplot3.getRangeAxis();
        range3.setAutoRangeIncludesZero(false);
        multiPlot.add(subplot3, weight[2]);
        XYPlot subplot4 = new XYPlot(data0, null, new VerticalNumberAxis("Value"));
        VerticalXYBarRenderer renderer4 = new VerticalXYBarRenderer();
        subplot4.setXYItemRenderer(renderer4);
        NumberAxis range4 = (NumberAxis)subplot4.getRangeAxis();
        range4.setAutoRangeIncludesZero(false);
        multiPlot.add(subplot4, weight[3]);
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, multiPlot, true);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addTitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return chart;
    }

    public JFreeChart createCombinedAndOverlaidChart1() {
        String title = this.resources.getString("combined.combined-overlaid.title");
        String subtitleStr = this.resources.getString("combined.combined-overlaid.subtitle");
        String domain = this.resources.getString("combined.combined-overlaid.domain");
        String[] ranges = this.resources.getStringArray("combined.combined-overlaid.ranges");
        HighLowDataset highLowData = DemoDatasetFactory.createSampleHighLowDataset();
        TimeSeriesCollection timeSeriesData = DemoDatasetFactory.createTimeSeriesCollection2();
        MovingAveragePlotFitAlgorithm mavg = new MovingAveragePlotFitAlgorithm();
        mavg.setPeriod(5);
        PlotFit pf = new PlotFit(highLowData, mavg);
        XYDataset highLowMAData = pf.getFit();
        mavg = new MovingAveragePlotFitAlgorithm();
        mavg.setPeriod(30);
        pf = new PlotFit(timeSeriesData, mavg);
        XYDataset timeSeriesMAData = pf.getFit();
        CombinedDataset data = new CombinedDataset();
        data.add(timeSeriesData);
        data.add(timeSeriesMAData, 1);
        data.add(highLowData);
        data.add(highLowMAData, 1);
        SubSeriesDataset series0 = new SubSeriesDataset((SeriesDataset)data, 0);
        SubSeriesDataset series1 = new SubSeriesDataset((SeriesDataset)data, 1);
        SubSeriesDataset series2 = new SubSeriesDataset((SeriesDataset)data, 2);
        SubSeriesDataset series3 = new SubSeriesDataset((SeriesDataset)data, 3);
        CombinedDataset data0 = new CombinedDataset(new SeriesDataset[]{series0});
        CombinedDataset data1 = new CombinedDataset(new SeriesDataset[]{series0, series1});
        CombinedDataset data2 = new CombinedDataset(new SeriesDataset[]{series2, series3});
        int n = 3;
        NumberAxis[] valueAxis = new NumberAxis[3];
        int i = 0;
        while (i < valueAxis.length) {
            valueAxis[i] = new VerticalNumberAxis(ranges[i]);
            valueAxis[i].setCrosshairVisible(false);
            if (i <= 1) {
                valueAxis[i].setAutoRangeIncludesZero(false);
            }
            ++i;
        }
        CombinedXYPlot multiPlot = new CombinedXYPlot(new HorizontalDateAxis(domain), 1);
        int[] weight = new int[]{1, 2, 2};
        XYPlot subplot1 = new XYPlot(data0, null, new VerticalNumberAxis(ranges[0]));
        NumberAxis axis1 = (NumberAxis)subplot1.getRangeAxis();
        axis1.setTickLabelFont(new Font("Monospaced", 0, 7));
        axis1.setLabelFont(new Font("SansSerif", 0, 8));
        axis1.setAutoRangeIncludesZero(false);
        multiPlot.add(subplot1, weight[0]);
        OverlaidXYPlot subplot2 = new OverlaidXYPlot(null, new VerticalNumberAxis(ranges[1]));
        NumberAxis axis2 = (NumberAxis)subplot2.getRangeAxis();
        axis2.setTickLabelFont(new Font("Monospaced", 0, 7));
        axis2.setLabelFont(new Font("SansSerif", 0, 8));
        axis2.setAutoRangeIncludesZero(false);
        XYPlot p1 = new XYPlot(series0, null, null);
        subplot2.add(p1);
        XYPlot p2 = new XYPlot(series1, null, null);
        subplot2.add(p2);
        multiPlot.add(subplot2, weight[1]);
        OverlaidXYPlot subplot3 = new OverlaidXYPlot(null, new VerticalNumberAxis(ranges[2]));
        NumberAxis axis3 = (NumberAxis)subplot3.getRangeAxis();
        axis3.setTickLabelFont(new Font("Monospaced", 0, 7));
        axis3.setLabelFont(new Font("SansSerif", 0, 8));
        axis3.setAutoRangeIncludesZero(false);
        HighLowRenderer renderer3 = new HighLowRenderer();
        XYPlot p3 = new XYPlot(series2, null, null, renderer3);
        subplot3.add(p3);
        XYPlot p4 = new XYPlot(series3, null, null);
        subplot3.add(p4);
        multiPlot.add(subplot3, weight[2]);
        JFreeChart chart = new JFreeChart(title, new Font("SansSerif", 1, 12), multiPlot, true);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 10));
        chart.addTitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return chart;
    }

    public JFreeChart createCombinedAndOverlaidDynamicXYChart() {
        String title = this.resources.getString("combined.dynamic.title");
        String subtitleStr = this.resources.getString("combined.dynamic.subtitle");
        String domain = this.resources.getString("combined.dynamic.domain");
        String[] ranges = this.resources.getStringArray("combined.dynamic.ranges");
        SampleXYDataset data = new SampleXYDataset();
        SubSeriesDataset series0 = new SubSeriesDataset((SeriesDataset)data, 0);
        SubSeriesDataset series1 = new SubSeriesDataset((SeriesDataset)data, 1);
        CombinedDataset combinedData = new CombinedDataset();
        combinedData.add(series0);
        combinedData.add(series1);
        HorizontalNumberAxis timeAxis = new HorizontalNumberAxis(domain);
        timeAxis.setTickMarksVisible(true);
        timeAxis.setAutoRangeIncludesZero(false);
        timeAxis.setCrosshairVisible(false);
        NumberAxis[] valueAxis = new NumberAxis[4];
        int i = 0;
        while (i < valueAxis.length) {
            valueAxis[i] = new VerticalNumberAxis(ranges[i]);
            valueAxis[i].setAutoRangeIncludesZero(false);
            valueAxis[i].setCrosshairVisible(false);
            ++i;
        }
        CombinedXYPlot plot = new CombinedXYPlot(timeAxis, 1);
        XYPlot subplot0 = new XYPlot(series0, null, valueAxis[0]);
        plot.add(subplot0, 1);
        XYPlot subplot1 = new XYPlot(series1, null, valueAxis[1]);
        plot.add(subplot1, 1);
        OverlaidXYPlot subplot2 = new OverlaidXYPlot(null, valueAxis[2]);
        XYPlot p1 = new XYPlot(series0, null, null);
        subplot2.add(p1);
        XYPlot p2 = new XYPlot(series1, null, null);
        subplot2.add(p2);
        plot.add(subplot2, 1);
        XYPlot subplot3 = new XYPlot(data, null, valueAxis[3]);
        plot.add(subplot3, 1);
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, true);
        TextTitle subtitle = new TextTitle(subtitleStr, new Font("SansSerif", 1, 12));
        chart.addTitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.cyan));
        SampleXYDatasetThread update = new SampleXYDatasetThread(data);
        Thread thread = new Thread(update);
        thread.start();
        return chart;
    }

    private void about() {
        String title = this.resources.getString("about.title");
        String versionLabel = this.resources.getString("about.version.label");
        if (this.aboutFrame == null) {
            this.aboutFrame = new AboutFrame(title, JFreeChart.INFO);
            this.aboutFrame.pack();
            this.aboutFrame.setSize(700, 350);
            RefineryUtilities.centerFrameOnScreen(this.aboutFrame);
        }
        this.aboutFrame.show();
        this.aboutFrame.requestFocus();
    }

    public static void main(String[] args) {
        JFreeChartDemo f = new JFreeChartDemo();
        f.pack();
        RefineryUtilities.centerFrameOnScreen(f);
        f.setVisible(true);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        if (e.getWindow() == this.aboutFrame) {
            this.aboutFrame = null;
        }
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    private JMenuBar createMenuBar(ResourceBundle resources) {
        JMenuBar menuBar = new JMenuBar();
        String label = resources.getString("menu.file");
        Character mnemonic = (Character)resources.getObject("menu.file.mnemonic");
        JMenu fileMenu = new JMenu(label, true);
        fileMenu.setMnemonic(mnemonic.charValue());
        label = resources.getString("menu.file.exit");
        mnemonic = (Character)resources.getObject("menu.file.exit.mnemonic");
        JMenuItem exitItem = new JMenuItem(label, mnemonic.charValue());
        exitItem.setActionCommand(EXIT_COMMAND);
        exitItem.addActionListener(this);
        fileMenu.add(exitItem);
        label = resources.getString("menu.help");
        mnemonic = (Character)resources.getObject("menu.help.mnemonic");
        JMenu helpMenu = new JMenu(label);
        helpMenu.setMnemonic(mnemonic.charValue());
        label = resources.getString("menu.help.about");
        mnemonic = (Character)resources.getObject("menu.help.about.mnemonic");
        JMenuItem aboutItem = new JMenuItem(label, mnemonic.charValue());
        aboutItem.setActionCommand(ABOUT_COMMAND);
        aboutItem.addActionListener(this);
        helpMenu.add(aboutItem);
        menuBar.add(fileMenu);
        menuBar.add(helpMenu);
        return menuBar;
    }

    private JTabbedPane createTabbedPane(ResourceBundle resources) {
        Font font = new Font("Dialog", 0, 12);
        JTabbedPane tabs = new JTabbedPane();
        int tab = 1;
        Vector<String> titles = new Vector<String>(0);
        String title = null;
        while (tab > 0) {
            try {
                title = resources.getString("tabs." + tab);
                if (title != null) {
                    titles.add(title);
                } else {
                    tab = -1;
                }
                ++tab;
            }
            catch (Exception ex) {
                tab = -1;
            }
        }
        if (titles.size() == 0) {
            titles.add("Default");
        }
        tab = titles.size();
        this.panels = new JPanel[tab];
        String[] tabTitles = new String[tab];
        --tab;
        while (tab >= 0) {
            tabTitles[tab] = title = titles.get(tab).toString();
            --tab;
        }
        titles.removeAllElements();
        int i = 0;
        while (i < tabTitles.length) {
            this.panels[i] = new JPanel();
            this.panels[i].setLayout(new LCBLayout(20));
            this.panels[i].setPreferredSize(new Dimension(360, 20));
            this.panels[i].setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            tabs.add(tabTitles[i], new JScrollPane(this.panels[i]));
            ++i;
        }
        String buttonText = resources.getString("charts.display");
        int i2 = 0;
        while (i2 <= CHART_COMMANDS.length - 1) {
            title = resources.getString(CHART_COMMANDS[i2][2] + ".title");
            String description = resources.getString(CHART_COMMANDS[i2][2] + ".description");
            try {
                tab = Integer.parseInt(resources.getString(CHART_COMMANDS[i2][2] + ".tab"));
                --tab;
            }
            catch (Exception ex) {
                System.err.println("Demo : Error retrieving tab identifier for chart " + CHART_COMMANDS[i2][2]);
                System.err.println("Demo : Error = " + ex.getMessage());
                tab = 0;
            }
            if (tab < 0 || tab >= this.panels.length) {
                tab = 0;
            }
            System.out.println("Demo : adding " + CHART_COMMANDS[i2][0] + " to panel " + tab);
            this.panels[tab].add(RefineryUtilities.createJLabel(title, font));
            this.panels[tab].add(new DescriptionPanel(new JTextArea(description)));
            JButton b1 = RefineryUtilities.createJButton(buttonText, font);
            b1.setActionCommand(CHART_COMMANDS[i2][0]);
            b1.addActionListener(this);
            this.panels[tab].add(b1);
            ++i2;
        }
        return tabs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        EXIT_COMMAND = EXIT_COMMAND;
        ABOUT_COMMAND = ABOUT_COMMAND;
        CHART_COMMANDS = new String[][]{{"HORIZONTAL_BAR_CHART", "createHorizontalBarChart", "chart1"}, {"HORIZONTAL_STACKED_BAR_CHART", "createStackedHorizontalBarChart", "chart2"}, {"VERTICAL_BAR_CHART", "createVerticalBarChart", "chart3"}, {"VERTICAL_3D_BAR_CHART", "createVertical3DBarChart", "chart4"}, {"VERTICAL_STACKED_BAR_CHART", "createVerticalStackedBarChart", "chart5"}, {"VERTICAL_STACKED_3D_BAR_CHART", "createVerticalStacked3DBarChart", "chart6"}, {"PIE_CHART_1", "createPieChartOne", "chart7"}, {"PIE_CHART_2", "createPieChartTwo", "chart8"}, {"XY_PLOT", "createXYPlot", "chart9"}, {"TIME_SERIES_1_CHART", "createTimeSeries1Chart", "chart10"}, {"TIME_SERIES_2_CHART", "createTimeSeries2Chart", "chart11"}, {"TIME_SERIES_WITH_MA_CHART", "createTimeSeriesWithMAChart", "chart12"}, {"HIGH_LOW_CHART", "createHighLowChart", "chart13"}, {"CANDLESTICK_CHART", "createCandlestickChart", "chart14"}, {"SIGNAL_CHART", "createSignalChart", "chart15"}, {"WIND_PLOT", "createWindPlot", "chart16"}, {"SCATTER_PLOT", "createScatterPlot", "chart17"}, {"LINE_CHART", "createLineChart", "chart18"}, {"VERTICAL_XY_BAR_CHART", "createVerticalXYBarChart", "chart19"}, {"XY_PLOT_NULL", "createNullXYPlot", "chart20"}, {"XY_PLOT_ZERO", "createXYPlotZeroData", "chart21"}, {"TIME_SERIES_CHART_SCROLL", "createTimeSeriesChartInScrollPane", "chart22"}, {"SINGLE_SERIES_BAR_CHART", "createSingleSeriesBarChart", "chart23"}, {"DYNAMIC_CHART", "createDynamicXYChart", "chart24"}, {"OVERLAID_CHART", "createOverlaidChart", "chart25"}, {"VERTICALLY_COMBINED_CHART", "createVerticallyCombinedChart", "chart26"}, {"HORIZONTALLY_COMBINED_CHART", "createHorizontallyCombinedChart", "chart27"}, {"COMBINED_OVERLAID_CHART", "createCombinedAndOverlaidChart1", "chart28"}, {"COMBINED_OVERLAID_DYNAMIC_CHART", "createCombinedAndOverlaidDynamicXYChart", "chart29"}, {"THERMOMETER_CHART", "createThermometerChart", "chart30"}, {"METER_CHART", "createMeterChart", "chart31"}};
        PREFERRED_SIZE = new Dimension(780, 400);
    }
}

